//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

//JsLint options (see http://www.jslint.com )
/*jslint white: true, undef: true, vars: true */

// Globals for JsLint to ignore 
/*global test, baja, bajaJsPrint, callbackify, beforeEach, describe, it, runs, expect, toEqualOrd, pass, fail, mock, waitsFor, VerifyInvokeAction */

var liveTest = { version: 1.0 };

(function () { 
  "use strict";
  
  var root = 'station:|slot:/',
      playground = root + 'playground',
      writables = root + 'writablePoints';
  
  beforeEach(function () {
    this.addMatchers({
      toEqualOrd: toEqualOrd
    });
  });

  // do all the tests
  describe("livetest namespace", function liveTestNamespace() {

    describe("resolve ord", function resolveOrd() {

      it("starts baja", function startBaja() {
        // asynchronously start baja
        var bajaStarted = false;
        runs(function() {
          baja.start(function() { 
            bajaStarted = true;
            expect(bajaStarted).toBeTruthy();
          });
        });

        // wait max of 5 seconds for baja to start
        waitsFor(function() {
            return bajaStarted;
        }, 5000);
      });

      it("resolves an ord succesfully", function resolveOrdSuccessfully() {
          baja.Ord.make(root + "Services/WebService").get({
              ok: function() { pass(); },
              fail: function() { fail("should have resolved ord"); }
          });
      });

      it("fails to resolve a bogus ord", function failToResolveAnOrd() {
          baja.Ord.make(root + "this_ord_does_not_exist").get({
              ok: function() { fail("should not have resolved ord"); },
              fail: function(err) { pass(); }
          });
      });

      it("adds a component", function addComponent() {
        var addCallbacks = callbackify({
          slot: "foo",
          value: "slot_value",
          ok: function(prop) {
            expect("slot_value").toEqualOrd(playground + '/foo');
          }
        });

        var getCallbacks = callbackify({
          ok: function (playground) {
            playground.add(addCallbacks);
          },
          subscriber: new baja.Subscriber()
        });
        
        runs(function () {
          baja.Ord.make(playground).get(getCallbacks);
        });
        waitsFor(addCallbacks.toHaveBeenCalled);
      });

      it("removes a component", function removeComponent() {
        var removeCallbacks = callbackify({
          slot: "foo",
          ok: function(prop) {
            expect(null).toEqualOrd(playground + '/foo');
          }
        });
        
        var getCallbacks = callbackify({
          ok: function(playground) {
            playground.remove(removeCallbacks);
          },
          subscriber: new baja.Subscriber()
        });
        
        runs(function () {
          baja.Ord.make(playground).get(getCallbacks);
        });
        waitsFor(removeCallbacks.toBeCalled);
      });
      

      it("sets a slot", function setSlot() {
        
        var statusNumeric = mock('baja:StatusNumeric', {
          status: baja.Status.nullStatus,
          value: 12345.0
        });

        var setCallbacks = callbackify({
          slot: "in2",
          value: statusNumeric,
          ok: function () {
            var expected = 12345.0,
                actual = test.get('station:|slot:/writablePoints/numWritable/in2/value');
            expect(actual).toEqual(expected);
            expect(12345.0).toEqualOrd(writables + '/numWritable/in2/value');
          }
        });
                
        var getCallbacks = callbackify({
          ok: function (numWritable) {
            numWritable.set(setCallbacks);
          },
          subscriber: new baja.Subscriber()
        });
        
        runs(function () {
          baja.Ord.make(writables + "/numWritable").get(getCallbacks);
        });
        
        waitsFor(setCallbacks.toBeCalled);
      });

      it("invokes an action", function invokeAction() {
        var numWritable,
            v = new VerifyInvokeAction(),
            verified = false;
        
        var invokeCallbacks = callbackify({
          slot: "emergencyOverride",
          value: 42.0
        });
        
        var getCallbacks = callbackify({
          ok: function (result) {
            numWritable = result;
            numWritable.invoke(invokeCallbacks);
          },
          subscriber: new baja.Subscriber()
        });
        
        runs(function () {
          baja.Ord.make(writables + "/numWritable").get(getCallbacks);
        });
        
        //first wait for action to invoke successfully...
        waitsFor(invokeCallbacks.toBeCalled);
        
        //... and then wait for changes to write through to the station
        waitsFor(function () {
          verified = v.doVerify();
          return verified;
        });
        
        runs(function () {
          expect(verified).toBeTruthy();
        });
      });
    }); 
  }); 
}());
