/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * Set up Jasmine Environment
 *
 * @author Logan Byam
 * @version 1.0.0.0
 */

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

// Globals for JsLint to ignore 
/*global jasmine, expect, test, baja, bajaJsPrint, window: true, location: true, error: true, runs, waitsFor, beforeEach, console*/

var setupJasmineEnv = { version: 1.0 },
    verify,
    verifyEq,
    failTest,
    errTest,
    typeMismatchError,
    undefinedError,
    testFolder,
    callbackify,
    errCallbackify,
    runAndWait,
    serverCall,
    verifyServerCall,
    lease,
    add;
         
(function runSetupJasmineEnv() { 
  "use strict";
  
  // Pre-load BajaScript Registry
  baja.registry.register(JSON.parse(baja.$ctypes));
  
  verify = function (o) {
    expect(o).toBeTruthy();
  }; 
  
  verifyEq = function (o0, o1) {
    expect(o0).toEqual(o1);
  };
  
  failTest = function (msg) {
    expect(String(msg || "failure!")).toBeUndefined();
  };
  
  errTest = function (func, err) {
    expect(func).toThrow(err);
  };
  
  //copy pasted from sys.js
  typeMismatchError = function (arg, ctor) {
    var nm = ctor.name;
    if (!nm && ctor.$name) {
      nm = ctor.$name;
    }

    var cnm = arg.name;
    if (!cnm && arg.$name) {
      cnm = arg.$name;
    }

    return "Invalid argument type. Expected " + nm + ", received " + cnm + " instead";
  };
  
  undefinedError = function (ctor) {
    var err = "Invalid argument (undefined)";
    if (ctor) {
      err += ". Expected " + ctor.name;
    }
    return err;
  };
  
  /**
   * Used to create Jasmine async friendly BajaScript callback objects.
   */
  callbackify = function (obj) {
    obj = obj || {};
    
    var callbacks,
        doOK,
        doFail,
        called = false;
    
    if (typeof obj === 'function') {
      callbacks = { ok: obj };
    } 
    else if (typeof obj === 'object') {
      callbacks = obj;
      if (typeof obj.ok !== 'function') {
        callbacks.ok = baja.ok;
      }
    }

    if (typeof callbacks.fail !== 'function') {
      callbacks.fail = function (msg) {
        jasmine.getEnv().currentSpec.expect(String(msg)).toBeUndefined();
      };
    }
    
    doOK = callbacks.ok;
    doFail = callbacks.fail;
    
    callbacks.ok = function () {
      if (called) {
        throw new Error("called ok callback a second time");
      }
      
      try {
        doOK.apply(this, arguments);
      } catch (e) {
       failTest(e);
      } finally {
        called = true;
      }
    };
    
    callbacks.fail = function (err) {
      if (called) {
        throw new Error("called fail callback a second time");
      }
      
      try {
        doFail.call(this, err);
      }
      finally {
        called = true;
      }
    };
    
    callbacks.isCalled = function () {
      return called;
    };
    
    return callbacks;
  };
  
  
  /**
   * Used to create Jasmine async friendly BajaScript callback objects for error tests.
   */
  errCallbackify = function (obj) {
    var doOK,
        doFail,
        called = false;
        
    if (typeof obj === 'function') {
      obj = { ok: obj };
    } 

    if (typeof obj.ok !== 'function') {
      obj.ok = baja.ok;
    }
    
    if (typeof obj.fail !== 'function') {
      obj.fail = baja.ok;
    }
    
    doOK = obj.ok;
    doFail = obj.fail;
    
    obj.ok = function () {
      try {
        verify(false);
        doOK.apply(this, arguments);
      }
      finally {
        called = true;
      }
    };
    
    obj.fail = function (err) {
      try {
        verify(true);
        doFail.call(this, err);
      }
      finally {
        called = true;
      }
    };
    
    obj.isCalled = function () {
      return called;
    };
    
    return obj;
  };
  
  /**
   * Combines Jasmine 'runs' and 'waitFor' into one function call
   */
  runAndWait = function (func, callbacks) {
    // Run this function
    runs(func);
    
    // Wait for the callback to finish
    waitsFor(callbacks.isCalled);
  };
  
  /**
   * Makes a Synchronous Server Side Call Handler invocation to TestBajaScriptServerSideHandler.
   */
  serverCall = function (methodName, value) {
    var retVal = false,
        batch;
                                
    // Synchronous Server Side Call to invoke Server Method...
    batch = new baja.comm.Batch();
    testFolder.serverSideCall({
      typeSpec: "testBajaScript:TestBajaScriptServerSideHandler",
      methodName: methodName,
      value: value,
      ok: function (val) {
        retVal = val;
      },
      fail: function (err) {
        baja.error(err);
        
        // This failed so mark this as an error
        verify(false);
      },
      batch: batch
    });
    batch.commitSync();
   
    return retVal;
  };
  
  /**
   * Makes a Synchronous Server Side Call and verifies the result to be truthy.
   */
  verifyServerCall = function (methodName, value) {
    expect(serverCall.apply(this, arguments)).toBeTruthy();
  };
  
  /**
   * Synchronously lease a Component.
   */
  lease = function (comp) {
    var batch = new baja.comm.Batch();
    comp.lease({
      batch: batch,
      fail: function (err) {
        baja.error(err);
        
        // This failed so mark this as an error
        verify(false);
      }
    });
    batch.commitSync();
    
    return comp;
  };
  
  /**
   * Add a Property to a Component.
   */
  add = function (propName, value, newPropName) { 
    // Argument for add
    var addCallbacks = callbackify({
      slot: propName,
      value: value,
      ok: function (prop) {
        if (newPropName !== undefined) {        
          // Check we've got back what we expect through BajaScript
          expect(prop.getName()).toEqual(newPropName);
          
          // Now check what's been added to the Server
          verifyServerCall("checkPropertyExists", baja.$("baja:Component", {
            ord: this.getNavOrd(),
            propName: newPropName
          }));
        }
      }
    });
    
    // Run and wait for this async op to complete
    runAndWait(function () {
      testFolder.add(addCallbacks);
    }, addCallbacks);
  };
  
  // Add toEquivalent matcher
  beforeEach(function () {
    this.addMatchers({
      toEquivalent: function(expected) {
        return this.actual.equivalent(expected);
      }
    });
  });
  
  /*
  // Override toEquals matcher
  beforeEach(function () {
    this.addMatchers({
      toEqual: function(expected) {
        // If there's an 'equals' method defined on both objects then use that instead
        if (expected && 
            typeof expected.equals === "function" && 
            this.actual && 
            typeof this.actual === "function") {
                    
          return this.actual.equals(expected);
        }
        
        // Default to standard equals
        return this.actual === expected;
      }
    });
  });
  */
  
}());
