/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * Jasmine Unit Test Execution for a real Web Browser
 *
 * @author Logan Byam
 * @version 1.0.0.0
 */

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, 
eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, 
vars: true, continue: true */

// Globals for JsLint to ignore 
/*global baja, XMLHttpRequest, JSON, window: true, location: true, jasmine, alert, testFolder: true, $, history, dialogs*/

var browserRunJasmine = { version: 1.0 };

(function runJasmine() {
  "use strict";
  
  var warningHtml = "<p>" +
                      "Running this test suite will temporarily populate the " +
                      "running Station with <strong>lots</strong> of Components." +
                    "</p>" +
                    "<p>" +
                      "Running these tests <strong>will</strong> impact Station performance!" +
                    "</p>" +
                    "<p>" +
                      "Are you really sure you wish to proceed?" +
                    "</p>";
  
  /**
   * Called to run the unit tests.
   */
  function runUnitTests() {
  
    // The name of the folder that's created in the Station (station:|slot:/{FolderName})
    var bajaScriptTestFolderName = "BajaScriptTestFolder",
        subscriber = new baja.Subscriber();

    /**
     * Default fail handler
     */
    function fail(err) {
      // Make sure any errors appear in the JavaScript Console
      baja.error(err);
      
      // Alert the user that something's failed
      alert("Cannot run tests! Unable to create " + bajaScriptTestFolderName +" in host Station");
    }
    
    /**
     * Execute Jasmine
     */
    function executeJasmine() {   
      var jasmineEnv = jasmine.getEnv(),
          reporter = new jasmine.TrivialReporter();
  
      jasmineEnv.addReporter(reporter);
  
      jasmineEnv.specFilter = function(spec) {
        return reporter.specFilter(spec);
      };
  
      jasmineEnv.execute();
    }
  
    // Resolve the route of the Station
    baja.Ord.make("station:|slot:/").get({
      ok: function (station) {        
        // Add the BajaScriptTestFolder Component to the route of the Station
        function add() {
          station.add({
            slot: bajaScriptTestFolderName,
            value: baja.$("testBajaScript:TestFolder"),
            flags: baja.Flags.TRANSIENT,
            ok: function (prop) {
              // Get a reference to the folder so it can be removed later on
              testFolder = this.get(prop);
              
              // Subscribe to this test folder and then run the unit tests
              subscriber.subscribe({
                comps: testFolder,
                ok: executeJasmine,
                fail: fail
              });
            },
            fail: fail
          });
        }
        
        // If the folder already exists then remove it
        if (station.has(bajaScriptTestFolderName)) {
          // Remove the folder from the Station and then add it again
          station.remove({
            slot: bajaScriptTestFolderName,
            ok: add,
            fail: fail
          });
        }
        else {
          // If the folder doesn't exist then add it
          add();
        }
      },
      subscriber: subscriber
    });
    
    /**
     * Called just before BajaScript is stopped
     */
    baja.preStop(function bajaScriptPreStop() {
      // If we have a BajaScriptTestFolder on the Station then attempt to remove it
      if (testFolder) {
        // Synchronously remove this folder
        var batch = new baja.comm.Batch();
        testFolder.getParent().remove({
          slot: testFolder.getName(),
          batch: batch
        });
        batch.commitSync();
      }    
    });
  }

  // Tweak the Jasmine UI when the document loads
  function tweakJasmineUi() {
    $('div.suite').live('click', function (event) {
      var $this = $(this);

      if ($this.hasClass('collapsed')) {
        $this.children('div.suite, div.spec').show();
        $this.removeClass('collapsed');
      } else {
        $this.find('div.suite, div.spec').addClass('collapsed').hide();
        $this.addClass('collapsed');
      }
      
      event.stopPropagation();
      event.stopImmediatePropagation();
    });
    
    $('div.spec').live('click', function (event) {
      event.stopPropagation();
      event.stopImmediatePropagation();
    });
  }
  
  // Warning dialog before we start the unit tests
  (function showWarningDialog() {
    // Only display warning when BajaScript has fully started  
    baja.started(function () {
      tweakJasmineUi();
    
      dialogs.yesNo({
        title: "BajaScript Test Suite",
        content: warningHtml,
        yes: function () {
          dialogs.close();
          runUnitTests();
        },
        no: function () {
          history.back();
        }
      });
    });
  }());
  
}());


