//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

// Globals for JsLint to ignore 
/*global baja, XMLHttpRequest, JSON, errTest, verify, verifyEq, describe, it*/

var commTest = { version: 1.0 };

(function testComms() { 

  "use strict";
  
  describe("comms", function testCommuncations() {
  
    describe("callback", function testCallbacks() {
      
      it("basic", function testBasic() {        
        // Test basic callbacks
        var res = false;
        var cb = new baja.comm.Callback(function (arg1) {
          res = arg1;
        });
        cb.ok(true);
        verify(res);
        
        res = false;
        cb = new baja.comm.Callback(function () {
        },
        function (err) {
          res = true;
        });
        cb.fail();
        verify(res);
      });
      
      it("intermediate", function testCallbackIntermediateOk() {
        
        // Test intermediate callbacks
        var counter = 0;
        var cb = new baja.comm.Callback(function () {
          counter++;
        });
        cb.addOk(function (ok, fail) {
          counter++;
          ok();
        });
        cb.addOk(function (ok, fail) {
          counter++;
          ok();
        });
        cb.ok();
        verifyEq(counter, 3);
        
        counter = 0;
        cb = new baja.comm.Callback(function (arg1) {
          counter = arg1;
        });
        cb.addOk(function (ok, fail, arg1) {
          ok(arg1 * 2);
        });
        cb.addOk(function (ok, fail, arg1) {
          ok(arg1 * 2);
        });
        cb.ok(32);
        verifyEq(counter, 128);
      });
      
      it("fail", function testCallbackIntermediateFail() {
        
        function okCb() {}
        
        // Test intermediate callbacks
        var counter = 0;
        var cb = new baja.comm.Callback(okCb, function () {
          counter++;
        });
        cb.addFail(function (ok, fail) {
          counter++;
          fail();
        });
        cb.addFail(function (ok, fail) {
          counter++;
          fail();
        });
        cb.fail();
        verifyEq(counter, 3);
        
        counter = 0;
        cb = new baja.comm.Callback(okCb, function (arg1) {
          counter = arg1;
        });
        cb.addFail(function (ok, fail, arg1) {
          fail(arg1 * 2);
        });
        cb.addFail(function (ok, fail, arg1) {
          fail(arg1 * 2);
        });
        cb.fail(32);
        verifyEq(counter, 128);
      });
    });
  });
 
  
  
  //
  // Communications Framework Tests
  // 
  
// TODO: Reintroduce tests once protocol has been progressed more!  
  /*
  commTest.testAsyncComms = function () {
    
    baja.comm.$rid = 0;
    
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:SineWave"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
    
    // In the test rig, the asynchronous callback will actually be called synchronously
    var okay = false;
    baja.comm.loadTypes("kitControl:SineWave", {
      ok: function (resp) { 
        verifyEq(JSON.stringify(resp), '{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]}');
        okay = true;  
      },
      
      fail: function (err) {
        print("Error: commTest.testAsyncComms: " + err);
        verify(false);
      }
    });
    
    verify(okay);
  };
   
  commTest.testSyncComms = function () {
  
    baja.comm.$rid = 0;
  
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:SineWave"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
      
    var resp = baja.comm.loadTypes("kitControl:SineWave");
    
    verifyEq(JSON.stringify(resp), '{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]}');
  };
  
  
  commTest.testAsyncBatchComms = function () {
  
    baja.comm.$rid = 0;
                         
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:NumericLatch"]},{"r":1,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:NumericSelect"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatus"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"kitControl:Latch","s":[{"t":"kitControl:NumericLatch","i":["baja:IStatus","baja:INumeric"]}],"a":true}]}]},"r":0,"c":"reg","k":"loadTypes"},{"t":"rp","b":{"it":[{"t":"baja:IStatus"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"kitControl:Switch","s":[{"t":"kitControl:MuxSwitch","s":[{"t":"kitControl:NumericSelect","i":["baja:IStatus","baja:INumeric"]}],"a":true}],"a":true}]}]},"r":1,"c":"reg","k":"loadTypes"}]}';
            
    var i = 0;
    var cb1 = {
      ok: function (resp) {
        verifyEq(JSON.stringify(resp), '{"it":[{"t":"baja:IStatus"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"kitControl:Latch","s":[{"t":"kitControl:NumericLatch","i":["baja:IStatus","baja:INumeric"]}],"a":true}]}]}');
        i++; 
      },
      
      fail: function (err) {
        verify(false);
        print("Error: commTest.testAsyncBatchComms: " + err);
      }
    };
    
    var cb2 = {
      ok: function (resp) {
        verifyEq(JSON.stringify(resp), '{"it":[{"t":"baja:IStatus"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"kitControl:Switch","s":[{"t":"kitControl:MuxSwitch","s":[{"t":"kitControl:NumericSelect","i":["baja:IStatus","baja:INumeric"]}],"a":true}],"a":true}]}]}');
        i++; 
      },
      
      fail: function (err) {
        verify(false);
        print("Error: commTest.testAsyncBatchComms: " + err);
      }
    };
    
    // Create a network batch
    var b = new baja.comm.Batch();
    
    // Please note, you wouldn't normally do this. Instead you'd just pass in multiple TypeSpecs to the 'loadTypes' call
    baja.comm.loadTypes(["kitControl:NumericLatch"], cb1, b);
    baja.comm.loadTypes(["kitControl:NumericSelect"], cb2, b);
       
    // Make the batch network call
    b.commit();
    
    verifyEq(i, 2);
  };
  
  
  //
  // Registry Communications Tests
  //  
  
  commTest.testAsyncLoadTypes = function () {
    
    baja.comm.$rid = 0;
    
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:SineWave"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
    
    // In the test rig, the asynchronous callback will actually be called synchronously
    var okay = false;
    baja.registry.loadTypes(["kitControl:SineWave"], {
      ok: function (resp) { 
        verifyEq("kitControl:SineWave", resp[0].getTypeSpec());
        okay = true;  
      },
      
      fail: function (err) {
        verify(false);
        print("Error: commTest.testAsyncLoadTypes: " + err);
      }
    });
    
    verify(okay);
  };
   
  commTest.testSyncLoadTypes = function () {
  
    baja.comm.$rid = 0;
    
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:SineWave"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:SineWave"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
    
    // In the test rig, the asynchronous callback will actually be called synchronously
    var resp = baja.registry.loadTypes(["kitControl:SineWave"]);    
    verifyEq("kitControl:SineWave", resp[0].getTypeSpec());
  };
  
  commTest.testAsyncLoadType = function () {
    
    baja.comm.$rid = 0;
    
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:Ramp"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:Ramp"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
    
    // In the test rig, the asynchronous callback will actually be called synchronously
    var okay = false;
    baja.registry.loadType("kitControl:Ramp", {
      ok: function (resp) { 
        verifyEq("kitControl:Ramp", resp.getTypeSpec());
        okay = true;  
      },
      
      fail: function (err) {
        verify(false);
        print("Error: commTest.testAsyncLoadType: " + err);
      }
    });
    
    verify(okay);
  };
   
  commTest.testSyncLoadType = function () {
  
    baja.comm.$rid = 0;
    
    XMLHttpRequest.testRequest = '{"p":"box","v":1,"m":[{"r":0,"t":"rt","c":"reg","k":"loadTypes","b":["kitControl:LoopPoint"]}]}';
    XMLHttpRequest.testResponse = '{"v":"1","p":"box","m":[{"t":"rp","b":{"it":[{"t":"baja:IStatusValue"},{"t":"baja:INumeric"}],"ct":[{"t":"baja:Component","s":[{"t":"control:ControlPoint","s":[{"t":"control:NumericPoint","s":[{"t":"kitControl:LoopPoint"}],"i":["baja:INumeric"]}],"a":true,"i":["baja:IStatusValue"]}]}]},"r":0,"c":"reg","k":"loadTypes"}]}';
    
    // In the test rig, the asynchronous callback will actually be called synchronously
    var resp = baja.registry.loadTypes(["kitControl:LoopPoint"]);    
    verifyEq("kitControl:LoopPoint", resp[0].getTypeSpec());
  }; 
*/   
}());