//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

// Globals for JsLint to ignore 
/*global baja, XMLHttpRequest, errTest, describe, it, verify, verifyEq,
  runs, callbackify, expect, runAndWait, waitsFor, testFolder*/

var collTest = { version: 1.0 };

(function testColl() { 

  "use strict";
  
  describe("mounted", function testMounted() {
  
    describe("table", function testTable() {
      var table;
          
      it("add query data", function addQueryData() {
        runs(function () {
          var batch = new baja.comm.Batch(),
              added = false;
          
          // Add a number of Components on the Server that we're going to query
          baja.iterate(10, function() {
            testFolder.add({
              slot: "collQueryComp?",
              value: baja.$("control:NumericPoint"),
              batch: batch
            });
          });
          
          batch.addCallback(function () {
            added = true;
          });
          
          batch.commit();
          
          waitsFor(function () {
            return added;
          });
        });
      });
  
      it("query", function bqlTableQuery() {
        runs(function () {
          var queryCb = callbackify({ 
            ok: function () {
              expect(this.getType().is("baja:ITable")).toBeTruthy();
              table = this;
            }
          });
          
          runAndWait(function () {     
            // Resolve a BQL query to the resultset
            baja.Ord.make("station:|slot:/|bql:select name as 'nm', toPathString as 'path', navOrd as 'navvy' from baja:Component where name like 'collQueryComp%'").get(queryCb);
          }, queryCb);
        });
      });
      
      it("getColumns", function testGetColumns() {
        var columns = table.getColumns();
        expect(columns.length).toEqual(3);
        
        expect(columns[0].getName()).toEqual("name");
        expect(columns[0].getDisplayName()).toEqual("nm");
        expect(columns[0].getType().is("baja:String")).toBeTruthy();
        expect(columns[0].getFlags()).toEqual(0);
        expect(columns[0].getFacets().equals(baja.Facets.DEFAULT));
        
        expect(columns[1].getName()).toEqual("toPathString");
        expect(columns[1].getDisplayName()).toEqual("path");
        expect(columns[1].getType().is("baja:String")).toBeTruthy();
        expect(columns[1].getFlags()).toEqual(0);
        expect(columns[1].getFacets().equals(baja.Facets.DEFAULT));
        
        expect(columns[2].getName()).toEqual("navOrd");
        expect(columns[2].getDisplayName()).toEqual("navvy");
        expect(columns[2].getType().is("baja:Ord")).toBeTruthy();
        expect(columns[2].getFlags()).toEqual(0);
        expect(columns[2].getFacets().equals(baja.Facets.DEFAULT));
      });
      
      it("getCol with incorrect arguments", function testGetColDumArg() {
        expect(table.getCol(null)).toBeNull();
        expect(table.getCol(-5)).toBeNull();
        expect(table.getCol("sdfsdfsdf")).toBeNull();
      });
      
      it("getCol", function testGetCol() {
        expect(table.getCol(0).getName()).toEqual("name");
        expect(table.getCol("name").getName()).toEqual("name");
        
        expect(table.getCol(1).getName()).toEqual("toPathString");
        expect(table.getCol("toPathString").getName()).toEqual("toPathString");
        
        expect(table.getCol(2).getName()).toEqual("navOrd");
        expect(table.getCol("navOrd").getName()).toEqual("navOrd");
      });
      
      it("cursor", function testCursor() {
        var count = 0,
            cursor,
            cursorCb = callbackify({
          before: function () {
            count++;
            expect(this instanceof baja.AsyncCursor).toBeTruthy();
            expect(count).toEqual(1);
          },
          after: function () {
            count++;
            expect(this instanceof baja.AsyncCursor).toBeTruthy();
            expect(count).toEqual(12);
          },
          each: function (row, index) {
            count++;
            expect(this instanceof baja.AsyncCursor).toBeTruthy();
          }
        });
      
        runAndWait(function () {
          table.cursor(cursorCb);
        }, cursorCb);
        
        waitsFor(function () {
          return count === 12;
        });
      });
    });
  });
}());