//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

// JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: false, white: true, undef: true, nomen: true, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2 */

// Globals for JsLint to ignore 
/*global test*/

/**
 * Invokes the function to ensure it DOES through an exception
 *
 * @param {Function} func  the function to invoke. The test will pass
 *                         if the function throws an exception
 */
function errTest(func) {  
  if (typeof func !== "function") {
    throw "Must pass in function for error testing: " + func;
  }

  var b = false;
  try {
    func();
    bajaJsPrint("Error test failed: " + func);
  }
  catch (err) {
    b = true;
  }
  finally {
    test.verify(b);
  }
}

/**
 * Run all test methods on an object
 *
 * @param {Object} obj  the object to be scanned for test methods.
 *                      A test method should start with the name 'test' in lower case
 */
function runAllTests(obj) {
  var prop;
  for (prop in obj) {
    if (obj.hasOwnProperty(prop) && 
        typeof obj[prop] === 'function' && 
        prop.search("test") === 0) {
      bajaJsPrint("*** Testing JavaScript Function: " + prop + " ***");
      obj[prop]();
    }
  }
}  
