/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */

/**
 * Keypad.
 *
 * @author    JJ Frankovich
 * @creation  22 May 09
 * @version   $Revision$ $Date$
 * @since     Baja 3.4
 */

////////////////////////////////////////////////////////////////
// Keypad
////////////////////////////////////////////////////////////////

var selectKeypad = new SelectKeypad(); // global instance
function SelectKeypad()
{ 
  this.open = false;
  this.isDebug = false;  
  
  this.show = function(elem, debug, text)
  {
    //one debug menu at a time
    selectKeypad.isDebug=debug != null && debug == true;    
    if(selectKeypad.isDebug)
    {
      if(selectKeypad.open)
        return;
      else
        selectKeypad.open=true;
    }
    
    if(hx.dynamic && !selectKeypad.isDebug)
    {
      //stop polling
      hx.failure = true;
    }
    
    selectKeypad.commitElem = elem;
    
    if(elem != null)
      selectKeypad.commitValue=elem.value;      
    else
      selectKeypad.commitValue="";
      
    
    var body = "";
    body += "<table><tr><td style='white-space:nowrap;' id='selectKeypadDescription'>";
    if(text != null)
      body += "<b>" + text + "</b>";
    body += this.makeInput();
    body += "</td><td> </td><td>";
    
    body +="<div id='keyboard_select_left' class='keyboard_button keyboard_button_A' style='display:none;' ";
    body += "onmouseout ='selectKeypad.stopUpdate(this);'";
    body += "onmouseup  ='selectKeypad.stopUpdate(this);'";
    body += "onmousedown='selectKeypad.scrollLeft(this);'";
    if(hx.ie)
      body += "ondblclick='selectKeypad.scrollLeft(this);'";
    body +="><div class='keyboard_arrowleft'></div></div>";
    body += "</td><td>";
    body +="<div id='keyboard_select_right' class='keyboard_button keyboard_button_A' style='display:none;' ";
    body += "onmouseout ='selectKeypad.stopUpdate(this);'";
    body += "onmouseup  ='selectKeypad.stopUpdate(this);'";
    body += "onmousedown='selectKeypad.scrollRight(this);'";
    if(hx.ie)
      body += "ondblclick='selectKeypad.scrollRight(this);'";
    body +="><div class='keyboard_arrowright'></div></div>";      
    
    body += "</td></tr><tr><td colspan=5>";
    
    body += "<div id='keyboard' align='center'>";
    body += this.makeSelectPalette(debug);
    
    body += "</div>";    
    body += "</td></tr></table>";
    
    var title = null;
    if(debug)
      title = "Navigation Menu";
    else
      title = keypad.getDescription(selectKeypad.commitElem)
    hx.showDialog(keypad.chrome(body, title, false));
    
//    if(hx.ie)
//      hx.$( hx.dialogId + hx.dialogCounter).firstChild.nextSibling.style.width="800px";
    
    try
    {
      hx.$("selectKeypadCommit").style.display='';
      hx.$("selectKeypadCommit").focus();
    }
    catch(err)
    {}
    
    var keyboard = hx.$("keyboard");
    if(keyboard.offsetWidth > 770)
    {
      keyboard.className = "keyboard_select_input";        
      hx.$("keyboard_select_right").style.display="";
      hx.$("keyboard_select_left").style.display="";
    }    
  }
  
  this.commit = function(refocus)
  {
    if (selectKeypad.commitElem != null)
    {
      selectKeypad.commitElem.value=selectKeypad.commitValue;
      if(refocus)
      {
        try
        {
          selectKeypad.commitElem.focus();        
          if(save != null)
            save.modified();
          
        }
        catch(err)
        {        
        }
      }      
      
      touchscreen.fireOnChange(selectKeypad.commitElem);
    }
  }
  
  /**
   * Create palette for a select.
   */
  this.makeSelectPalette = function(debug)
  {         
    var p = "";
    var options = null;
    if(debug != null && debug == true)
    {
      var options = new Array();
      for(var i=0; i<this.def.length; i++)
      {
        options[i]=document.createElement('option');
        options[i].innerHTML=this.def[i][0];
        options[i].value=this.def[i][1];
      }
    }
    else
      options = selectKeypad.commitElem.options;
    p += "<table class='keyboard_row' style='border-collapse:collapse;' ><tr><td valign='top'><table>";  
    
    if(options.length == 0)    
    {
      p += "<tr><td class='keyboard_button keyboard_select'"; 
      p += "oncontextmenu  ='return touchscreen.endEvent(window.event);'";
      p += "onclick=\"selectKeypad.selectButton(this, null);\"";
      p += ">";  
      p += "Cancel";
      p += "</td></tr>";  
      return p;
    }
    
    var rows = 7;
    var oneSlice = parseInt(options.length/rows);     
    if(options.length%rows != 0)
      oneSlice++;
    
    for (var r=0; r<rows; r++)
    {
      
      for (var c=0; c<oneSlice; c++)
      {
        var total = (r*oneSlice) + c;

        if(total >= options.length)
          continue;
          
        var option = options[total];
        var val = option.value;
        var text = option.innerHTML;
        
        p += "<tr><td class='keyboard_button keyboard_select";
        if(selectKeypad.commitElem != null && total == selectKeypad.commitElem.selectedIndex)
          p += " keyboard_button_selected";
        p += "'";  
        
        p += "oncontextmenu  ='return touchscreen.endEvent(window.event);'";
        p += "onclick=\"selectKeypad.selectButton(this, '" + val+ "');\"";


        p += ">";  
        p += text;
        p += "</td></tr>";  
        
        if(total%7 == 6)
          p += "</table></td><td valign='top'><table >";
      }      
    }            
    return p;
  }
  
  this.makeInput = function()
  {
    var s = "";
    //try to get a description
    s += "<input ";
    s +="noKeyboard='true'"; 
    s +="type='hidden'"; 
    s +="readOnly='readOnly' ";
    s +="id='selectKeypadCommit' ";
    s += "value='"+ selectKeypad.commitValue + "'";
    s += " />";
    return s;    
  }
  
  this.enableButton = function(elem)
  {
    selectKeypad.removeClass(elem, "keyboard_disabled");    
  }
  
  this.disableButton = function(elem)
  {
    selectKeypad.addClass(elem, "keyboard_disabled");        
  }

  this.setCommit = function(elem)
  {
    selectKeypad.commitElem=elem;
    selectKeypad.commitValue=selectKeypad.commitElem.value;
    hx.$('selectKeypadDescription').innerHTML=selectKeypad.makeInput();
    hx.$("selectKeypadCommit").style.display='';
    return elem;
  }
  
  this.scrollRight = function(elem)
  {
    selectKeypad.scrollHorizontal(elem, 250);    
  }
  
  this.scrollLeft = function(elem)
  {
    selectKeypad.scrollHorizontal(elem, -250);    
  }
  
  //positioing  
  this.scrollHorizontal = function(elem, amount)
  {
    if(elem != null)
      selectKeypad.setLastButton(elem);
    
    if(selectKeypad.timeout != null)
      clearTimeout(selectKeypad.timeout);
    
    var table = hx.$("keyboard");
    table.scrollLeft=table.scrollLeft + amount;
    
    selectKeypad.timeout = setTimeout("selectKeypad.timedScrollHorizontal(" + amount + ");", 750);
    
    return true;
  }
  
  //positioing  
  this.timedScrollHorizontal = function(amount)
  {
    if(selectKeypad.lastButton == null)
      return;
    
    if(selectKeypad.timeout != null)
      clearTimeout(selectKeypad.timeout);      
    
    var table = hx.$("keyboard");
    table.scrollLeft=table.scrollLeft + amount;
    
    selectKeypad.timeout = setTimeout("selectKeypad.timedScrollHorizontal(" + amount + ");", 100);
    
    return true;
  }


  this.stopUpdate = function(elem)
  {
    
    if(selectKeypad.lastButton != null)
    {
      if(selectKeypad.removeStyleElem != null)
        selectKeypad.removeStyle();
      selectKeypad.removeStyleElem=selectKeypad.lastButton;
      setTimeout("selectKeypad.removeStyle();", 150);      
    }
    
    selectKeypad.lastButton=null;
    if(selectKeypad.timeout != null)
    {
      clearTimeout(selectKeypad.timeout);
      selectKeypad.timeout=null;      
    }    
  }
  
  this.removeStyle = function()
  {
    if(selectKeypad.removeStyleElem != null)
    {
      selectKeypad.removeClass(selectKeypad.removeStyleElem, "keyboard_button_pressed");
      selectKeypad.removeStyleElem=null;
    }
  }
  
  this.removeClass = function(elem, className)
  {
    var split = elem.className.split(" ");
    var newClassNames = "";
    for(var i=0; i<split.length; i++)
    {
      if(split[i] != className)
        newClassNames+=split[i] + " ";
    }
    elem.className=newClassNames;
  }
  
  this.addClass = function(elem, className)
  {
    
    var elemClassName = elem.className;
    var index = elemClassName.indexOf(className);
    if( index == -1)
    {
      elemClassName=elemClassName + " " + className;
      elem.className=elemClassName;
    }
  }
  
  this.setLastButton = function(elem)
  {
    if(elem != null)
      selectKeypad.addClass(elem, "keyboard_button_pressed");      
    
    selectKeypad.lastButton=elem;
  }
  
  this.selectButton = function(elem, value)
  {
    hx.closeDialog(null, null); 
    if(value != null)
    {
      if(selectKeypad.commitElem != null)
      {
        selectKeypad.commitElem.value=value;
        selectKeypad.commitElem.previousSibling.innerHTML=elem.innerHTML;
        
        touchscreen.fireOnChange(selectKeypad.commitElem);
        try
        {
          if(save != null)
            save.modified();
        }
        catch(err)
        {        
        }
      }      
      else
      {
        //debug
        selectKeypad.open=false;
        selectKeypad.isDebug=false;
        eval(value);
      }
    }
    
    
    if(hx.dynamic && !selectKeypad.isDebug)
    {
      //restart polling
      hx.failure = false;
      setTimeout("hx.poller()", hx.pollTimeout);        
    }
  }
  
  



////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  

  this.removeStyleElem  = null;
  this.timeout          = null;
  this.lastButton       = null;
  this.commitElem       = null;
  this.commitValue      = "";  
  
  this.def              = new Array();  
  this.def.push(['Refresh', 'window.location.reload(true);']);
  this.def.push(['Home',    'window.location=&quot;/&quot;;']);  
  this.def.push(['Login',   'window.location=&quot;/login&quot;;']);
  this.def.push(['Config',  'window.location=&quot;http://localhost/index.html&quot;;']);  
  this.def.push(['Back',    'history.go(-1);']);
  this.def.push(['Forward', 'history.go(1);']);
  this.def.push(['Cancel',  '']);
}

