/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bajascript.test;

import com.tridium.bajascript.test.BTestFolder;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

public final class BTestBajaScriptServerSideHandler
extends BSingleton
implements BIServerSideCallHandler {
    public static final BTestBajaScriptServerSideHandler INSTANCE = new BTestBajaScriptServerSideHandler();
    public static final Type TYPE = Sys.loadType(BTestBajaScriptServerSideHandler.class);
    private static final Log log = Log.getLog((String)"testBajaScript.serverSideHandler");

    public Type getType() {
        return TYPE;
    }

    public BValue checkPropertyExists(BComponent bComponent, BValue bValue, Context context) {
        Property property;
        BComponent bComponent2 = (BComponent)bValue;
        BOrd bOrd = (BOrd)bComponent2.get("ord");
        if (log.isTraceOn()) {
            log.trace("checkPropertyExists: " + bOrd);
        }
        BComplex bComplex = null;
        try {
            bComplex = (BComplex)bOrd.get((BObject)bComponent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bComplex == null) {
            if (log.isTraceOn()) {
                log.trace("Could not resolve ORD: " + bOrd);
            }
            return BBoolean.FALSE;
        }
        String string = bComponent2.get("propName").toString();
        if (log.isTraceOn()) {
            log.trace("Finding Property: " + string);
        }
        if ((property = bComplex.getProperty(string)) == null) {
            if (log.isTraceOn()) {
                log.trace("Could not find Property: " + string);
            }
            return BBoolean.FALSE;
        }
        BValue bValue2 = bComponent2.get("value");
        BFacets bFacets = (BFacets)bComponent2.get("facets");
        BDouble bDouble = (BDouble)bComponent2.get("flags");
        BString bString = (BString)bComponent2.get("typeSpec");
        BFacets bFacets2 = bComplex.getSlotFacets((Slot)property);
        if (bFacets != null && !bFacets2.equals((Object)bFacets)) {
            if (log.isTraceOn()) {
                log.trace("Unequal Facets: " + bFacets2 + " != " + bFacets);
            }
            return BBoolean.FALSE;
        }
        int n = bComplex.getFlags((Slot)property);
        if (bDouble != null && n != bDouble.getInt()) {
            if (log.isTraceOn()) {
                log.trace("Unequal Flags: " + Flags.encodeToString((int)n) + " != " + Flags.encodeToString((int)bDouble.getInt()));
            }
            return BBoolean.FALSE;
        }
        Type type = bComplex.get(property).getType();
        if (bString != null && !type.toString().equals(bString.toString())) {
            if (log.isTraceOn()) {
                log.trace("TypeSpec mismatch: " + type + " != " + bString);
            }
            return BBoolean.FALSE;
        }
        if (bValue2 == null) {
            if (log.isTraceOn()) {
                log.trace("No value Specified. Test passed!");
            }
            return BBoolean.TRUE;
        }
        BValue bValue3 = bComplex.get(string);
        BBoolean bBoolean = BBoolean.make((boolean)bValue3.equivalent((Object)bValue2));
        if (bBoolean.getBoolean()) {
            if (log.isTraceOn()) {
                log.trace("Value matched ok. Test passed!");
            } else if (log.isTraceOn()) {
                log.trace("Property value mismatch: " + bValue3 + " != " + bValue2);
            }
        }
        return bBoolean;
    }

    public BBoolean checkOrder(BComponent bComponent, BValue bValue, Context context) {
        Property property;
        BComponent bComponent2 = (BComponent)bValue;
        BOrd bOrd = (BOrd)bComponent2.get("ord");
        if (log.isTraceOn()) {
            log.trace("checkOrder: " + bOrd);
        }
        BComplex bComplex = null;
        try {
            bComplex = (BComplex)bOrd.get((BObject)bComponent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bComplex == null) {
            if (log.isTraceOn()) {
                log.trace("Could not resolve ORD: " + bOrd);
            }
            return BBoolean.FALSE;
        }
        String string = bComponent2.get("propName").toString();
        if (log.isTraceOn()) {
            log.trace("Finding Property: " + string);
        }
        if ((property = bComplex.getProperty(string)) == null) {
            if (log.isTraceOn()) {
                log.trace("Could not find Property: " + string);
            }
            return BBoolean.FALSE;
        }
        BComplex bComplex2 = (BComplex)bComplex.get(property);
        String string2 = bComponent2.get("order").toString();
        if (log.isTraceOn()) {
            log.trace("Order: " + string2);
        }
        String[] stringArray = TextUtil.split((String)string2, (char)',');
        Property[] propertyArray = bComplex2.getDynamicPropertiesArray();
        if (propertyArray.length != stringArray.length) {
            if (log.isTraceOn()) {
                log.trace("Invalid order: " + propertyArray.length + " != " + stringArray.length);
            }
            return BBoolean.FALSE;
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            if (stringArray[i].equals(propertyArray[i].getName()) || !log.isTraceOn()) continue;
            log.trace("Invalid order: " + propertyArray[i].getName() + " != " + stringArray[i]);
        }
        if (log.isTraceOn()) {
            log.trace("Order ok");
        }
        return BBoolean.TRUE;
    }

    public void createLoadSlotsComponents(BComponent bComponent, Context context) {
        BComponent bComponent2 = (BComponent)BOrd.make((String)"station:|slot:/BajaScriptTestFolder").get((BObject)bComponent);
        BComponent bComponent3 = new BComponent();
        bComponent2.add("testLoadSlots", (BValue)bComponent3);
        BComponent bComponent4 = new BComponent();
        bComponent3.add("test", (BValue)bComponent4);
        BComponent bComponent5 = new BComponent();
        bComponent4.add("test", (BValue)bComponent5);
        BComponent bComponent6 = new BComponent();
        bComponent5.add("test", (BValue)bComponent6);
        bComponent6.add("slot1", (BValue)BString.make((String)"Some text!"));
        bComponent6.add("slot2", (BValue)BWeekday.wednesday);
    }

    public void createTestFolders(BComponent bComponent, BValue bValue, Context context) {
        int n = ((BNumber)bValue).getInt();
        for (int i = 0; i < n; ++i) {
            BTestFolder bTestFolder = new BTestFolder();
            bComponent.add("testFolder?", (BValue)bTestFolder);
        }
    }

    public void addProgram(BComponent bComponent, Context context) throws Exception {
        BOrd bOrd = BOrd.make((String)"module://testBajaScript/com/tridium/bajascript/test/rc/Program.xml");
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder(bOrd);
        Mark mark = new Mark((BObject)valueDocDecoder.decodeDocument(), "program");
        mark.copyTo((BObject)bComponent, null);
    }
}

