/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flr;

import com.tridium.sys.license.FlrException;
import com.tridium.sys.license.XFlrMsg;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class Pack {
    private final String name;
    private final int limit;
    private final XElem licenses;
    private int free;
    private final HashMap clients;

    public final int getLimit() {
        return this.limit;
    }

    public final synchronized int getFree() {
        return this.free;
    }

    public final synchronized int getLeased() {
        return this.limit - this.free;
    }

    public synchronized XElem lease(XFlrMsg xFlrMsg) {
        if (this.free < 0) {
            throw new IllegalStateException("Cannot lease [" + this.name + "]. Negative free: " + this.free);
        }
        if (this.clients.size() != this.limit - this.free) {
            throw new IllegalStateException("Client/free mismatch. Clients: " + this.clients.size() + ", free: " + this.free);
        }
        if (this.free == 0 && !this.autoFree()) {
            throw new FlrException("The license limit has been reached for pack [" + this.name + "]. limit = {" + this.limit + "}.");
        }
        String string = xFlrMsg.getChallenge().getCksum();
        if (this.clients.containsKey(string)) {
            throw new IllegalStateException("Duplicate cksum during lease(): " + string);
        }
        long l = xFlrMsg.getMetadata().getl("autofree", (long)-1);
        if (l < 0L) {
            throw new FlrException("The lease message does not have a valid 'autofree' metadata value");
        }
        xFlrMsg.setMetadata("hb", (BIDataValue)BLong.make((long)Clock.millis()));
        this.clients.put(string, xFlrMsg);
        --this.free;
        return this.licenses;
    }

    private final synchronized boolean autoFree() {
        boolean bl = false;
        Object[] objectArray = this.clients.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            XFlrMsg xFlrMsg = (XFlrMsg)this.clients.get(objectArray[n]);
            BFacets bFacets = xFlrMsg.getMetadata();
            long l = bFacets.getl("hb", (long)-1);
            long l2 = bFacets.getl("autofree", (long)-1);
            if (l < 0L) {
                throw new IllegalStateException("autoFree() lastHeartbeat = " + bFacets.get("hb"));
            }
            if (l2 < 0L) {
                throw new IllegalStateException("autoFree() autofree = " + bFacets.get("autofree"));
            }
            if (Clock.millis() - (l + l2) > 0L) {
                this.clients.remove(objectArray[n]);
                ++this.free;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public synchronized XElem heartbeat(XFlrMsg xFlrMsg) {
        XElem xElem = null;
        String string = xFlrMsg.getChallenge().getCksum();
        XFlrMsg xFlrMsg2 = (XFlrMsg)this.clients.get(string);
        if (xFlrMsg2 == null) {
            try {
                xElem = this.lease(xFlrMsg);
            }
            catch (Exception exception) {
                xElem = new XElem("reject");
                xElem.addText(exception.toString());
            }
        } else {
            xFlrMsg2.setMetadata("hb", (BIDataValue)BLong.make((long)Clock.millis()));
            xElem = new XElem("success");
        }
        return xElem;
    }

    public synchronized void checkin(XFlrMsg xFlrMsg) {
        String string = xFlrMsg.getChallenge().getCksum();
        if (this.clients.remove(string) != null) {
            ++this.free;
        }
    }

    public synchronized String getClientsHtml() {
        BFacets bFacets = BFacets.make((String)"showSeconds", (boolean)true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border=\"1\" cellpadding=\"5\"\n").append("<tr><th>Client ID</th><th>Address</th><th>Last Heartbeat</th></tr>\n");
        Object[] objectArray = this.clients.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            XFlrMsg xFlrMsg = (XFlrMsg)this.clients.get(objectArray[n]);
            BFacets bFacets2 = xFlrMsg.getMetadata();
            stringBuffer.append("<tr>").append("<td>").append(objectArray[n]).append("</td>").append("<td>").append(bFacets2.get("addr")).append("</td>").append("<td>").append(BAbsTime.make((long)bFacets2.getl("hb", 0L)).toString((Context)bFacets)).append("</td>").append("</tr>\n");
            ++n;
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    public Pack(XElem xElem) throws XException {
        this.name = xElem.get("name");
        this.limit = xElem.geti("limit");
        if (this.limit < 0) {
            throw new XException("Pack '" + this.name + "' has negative limit: " + this.limit);
        }
        this.free = this.limit;
        this.licenses = xElem.elem("licenses");
        this.clients = new HashMap();
    }
}

