/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flr;

import com.tridium.flr.FlrOp;
import com.tridium.flr.FlrServlet;
import com.tridium.flr.Pack;
import com.tridium.net.HttpUtil;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NLicenseManager;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.io.Base64;
import javax.baja.io.HtmlWriter;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lpf {
    public static final String PACKS_URI = "/flr/packs";
    private static final String LIST_PACKS_TEMPLATE = "module://flr/templates/listPacksTemplate.html";
    private static final String PACK_STATUS_TEMPLATE = "module://flr/templates/packStatusTemplate.html";
    private String err;
    private BOrd lpf;
    private String hostId;
    private int port;
    private long expiration;
    private HashMap packs;
    private final PatternCompiler compiler;
    private final PatternMatcher matcher;

    private final void load() {
        try {
            XElem xElem = XParser.make((InputStream)((BIFile)this.lpf.get()).getInputStream()).parse();
            if (!xElem.qname().equals("lpf")) {
                throw new XException("Root name must be 'lpf'", xElem);
            }
            XElem xElem2 = xElem.elem("flr");
            this.hostId = xElem2.get("hostId");
            this.port = Integer.parseInt(xElem2.get("port"));
            if (!Sys.getHostId().equals(this.hostId)) {
                throw new LicenseException("LPF hostId '" + this.hostId + " does not match: " + Sys.getHostId());
            }
            long l = System.currentTimeMillis();
            this.expiration = LicenseUtil.parseDate((String)xElem.get("expiration"));
            if (l > this.expiration) {
                throw new LicenseException("Expired");
            }
            CertificateFile certificateFile = ((NLicenseManager)Sys.getLicenseManager()).getCertificate("Tridium");
            XElem xElem3 = xElem.elem("signature");
            byte[] byArray = Base64.decode((String)xElem3.string());
            xElem.removeContent((XContent)xElem3);
            byte[] byArray2 = LicenseUtil.encode((XElem)xElem);
            if (!LicenseUtil.verify((byte[])byArray2, (byte[])byArray, (PublicKey)certificateFile.getPublicKey())) {
                throw new LicenseException("Invalid signature.");
            }
            this.loadPacks(xElem.elem("packs").elems("pack"));
        }
        catch (LicenseException licenseException) {
            this.err = licenseException.getMessage();
        }
        catch (XException xException) {
            this.err = "Invalid XML: " + xException.getMessage();
        }
        catch (Exception exception) {
            this.err = exception.toString();
        }
    }

    private final void loadPacks(XElem[] xElemArray) {
        this.packs = new HashMap();
        int n = 0;
        while (n < xElemArray.length) {
            this.packs.put(xElemArray[n].get("name"), new Pack(xElemArray[n]));
            ++n;
        }
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.err == null) {
            bl = true;
        }
        return bl;
    }

    public void reload() {
        this.load();
    }

    public int getPort() {
        return this.port;
    }

    public boolean definesPack(String string) {
        return this.packs.containsKey(string);
    }

    public Pack getPack(String string) {
        return (Pack)this.packs.get(string);
    }

    public String toString() {
        if (!this.isValid()) {
            return "{LPF invalid: " + this.err + '}';
        }
        return this.lpf.toString();
    }

    public final void doGet(FlrOp flrOp) throws Exception {
        if (flrOp.uri().equals(PACKS_URI)) {
            this.doGet_ListPacks(flrOp);
        } else {
            String string = HttpUtil.decodeUrl((String)flrOp.uri().substring(PACKS_URI.length() + 1));
            if (!this.definesPack(string)) {
                flrOp.resp().sendRedirect(PACKS_URI);
            } else {
                this.doGet_Pack(flrOp, string);
            }
        }
    }

    private final void doGet_ListPacks(FlrOp flrOp) throws Exception {
        String string;
        StringWriter stringWriter = new StringWriter();
        HtmlWriter htmlWriter = new HtmlWriter((Writer)stringWriter);
        htmlWriter.w((Object)"<ul>").nl();
        Object[] objectArray = this.packs.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = (String)objectArray[n];
            Pack pack = this.getPack(string);
            htmlWriter.w((Object)"<li>").a("/flr/packs/" + HttpUtil.encodeUrl((String)string), string).nbsp().w('(').w(pack.getLeased()).w('/').w(pack.getLimit()).w(')').w((Object)"</li>").nl();
            ++n;
        }
        htmlWriter.w((Object)"</ul>").nl().close();
        String string2 = FlrServlet.getTemplate(LIST_PACKS_TEMPLATE);
        string = this.compiler.compile("packs:listPacks");
        string2 = Util.substitute((PatternMatcher)this.matcher, (Pattern)string, (Substitution)new Perl5Substitution(stringWriter.toString()), (String)string2);
        flrOp.setResponseHeaders();
        flrOp.op().getHtmlWriter().w((Object)string2).close();
    }

    private final void doGet_Pack(FlrOp flrOp, String string) throws Exception {
        Pack pack = this.getPack(string);
        String string2 = FlrServlet.getTemplate(PACK_STATUS_TEMPLATE);
        Pattern pattern = this.compiler.compile("pack:packName");
        Perl5Substitution perl5Substitution = new Perl5Substitution(string);
        string2 = Util.substitute((PatternMatcher)this.matcher, (Pattern)pattern, (Substitution)perl5Substitution, (String)string2, (int)-1);
        pattern = this.compiler.compile("pack:clientsTable");
        perl5Substitution.setSubstitution(pack.getClientsHtml());
        string2 = Util.substitute((PatternMatcher)this.matcher, (Pattern)pattern, (Substitution)perl5Substitution, (String)string2);
        flrOp.setResponseHeaders();
        flrOp.op().getHtmlWriter().w((Object)string2).close();
    }

    private final /* synthetic */ void this() {
        this.compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
    }

    public Lpf(BOrd bOrd) {
        this.this();
        this.lpf = bOrd;
        this.load();
    }
}

