/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flr;

import com.tridium.flr.BFlrService;
import com.tridium.flr.FlrOp;
import com.tridium.flr.Lpf;
import com.tridium.sys.license.FloatingLicenseManager;
import com.tridium.sys.license.FlrException;
import com.tridium.sys.license.XFlrMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.DigestException;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.web.WebOp;
import javax.baja.xml.XElem;

public class FlrServlet {
    public static final String ADDR_MD = "addr";
    public static final String HB_MD = "hb";
    public static final String AUTOFREE_MD = "autofree";
    private final BFlrService flr;
    private final Log log;
    private final Lpf lpf;
    private FloatingLicenseManager.FlrCksum flrCksum;
    private WebOp curOp;

    private final void resolveCksum() {
        try {
            Class clazz = Sys.getBajaModule().loadClass("com.tridium.sys.license.FloatingLicenseManager$CksumMagic");
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            constructorArray[0].setAccessible(true);
            this.flrCksum = (FloatingLicenseManager.FlrCksum)constructorArray[0].newInstance(null);
        }
        catch (Exception exception) {
            this.flr.configFatal("baja module is not FLR compatible.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(WebOp webOp) throws Exception {
        this.curOp = webOp;
        String string = webOp.getRequest().getRequestURI();
        XFlrMsg xFlrMsg = null;
        if (string.equals("/flr/") || string.equals("/flr")) {
            try {
                xFlrMsg = XFlrMsg.make((InputStream)webOp.getRequest().getInputStream());
                if (this.log.isTraceOn()) {
                    this.log.trace("message received\n");
                    xFlrMsg.dump();
                }
                this.flrCksum.validate(xFlrMsg, BRelTime.makeMinutes((int)1));
                xFlrMsg.setMetadata(ADDR_MD, (BIDataValue)BString.make((String)webOp.getRequest().getRemoteAddr()));
                String string2 = xFlrMsg.getType();
                if (string2.equals("heartbeat")) {
                    this.respond(xFlrMsg, this.doHeartbeat(xFlrMsg));
                    return;
                }
                if (string2.equals("lease")) {
                    this.respond(xFlrMsg, this.doLease(xFlrMsg));
                    return;
                }
                if (!string2.equals("checkin")) return;
                this.respond(xFlrMsg, this.doCheckin(xFlrMsg));
                return;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                this.respond(XFlrMsg.error((Exception)exception));
                return;
            }
        } else {
            webOp.getResponse().sendError(400);
        }
    }

    private final XElem doLease(XFlrMsg xFlrMsg) {
        XElem xElem = xFlrMsg.getPayload();
        if (!xElem.name().equals("lease")) {
            throw new FlrException("'lease' message does not have correct payload.");
        }
        String string = xElem.get("pack");
        if (!this.lpf.definesPack(string)) {
            throw new FlrException("Pack '" + string + "' is not defined in this FLR.");
        }
        return this.lpf.getPack(string).lease(xFlrMsg);
    }

    private final XElem doHeartbeat(XFlrMsg xFlrMsg) {
        XElem xElem = xFlrMsg.getPayload();
        if (!xElem.name().equals("msg")) {
            throw new FlrException("'heartbeat' message does not have correct payload.");
        }
        XFlrMsg xFlrMsg2 = new XFlrMsg(xElem);
        String string = xFlrMsg2.getPayload().get("pack");
        if (!this.lpf.definesPack(string)) {
            throw new FlrException("Pack '" + string + "' is not defined in this FLR.");
        }
        return this.lpf.getPack(string).heartbeat(xFlrMsg2.setMetadata(ADDR_MD, (BIDataValue)BString.make((String)this.curOp.getRequest().getRemoteAddr())));
    }

    private final XElem doCheckin(XFlrMsg xFlrMsg) {
        try {
            XFlrMsg xFlrMsg2 = new XFlrMsg(xFlrMsg.getPayload());
            String string = xFlrMsg2.getPayload().get("pack");
            this.lpf.getPack(string).checkin(xFlrMsg2);
        }
        catch (Exception exception) {}
        return new XElem("success");
    }

    private final void respond(XFlrMsg xFlrMsg, XElem xElem) throws IOException {
        XFlrMsg xFlrMsg2 = new XFlrMsg(xFlrMsg.getType() + "-reply");
        xFlrMsg2.setPayload(xElem);
        XFlrMsg.XChallenge xChallenge = xFlrMsg.getChallenge();
        try {
            xChallenge.setCksum(this.flrCksum.calcCksum(xFlrMsg, false));
        }
        catch (DigestException digestException) {
            throw new FlrException("FLR challenge response failed.", (Throwable)digestException);
        }
        xFlrMsg2.setChallenge(xChallenge);
        this.respond(xFlrMsg2);
    }

    private final void respond(XFlrMsg xFlrMsg) throws IOException {
        this.curOp.getResponse().setContentType("text/xml; charset=\"UTF-8\"");
        xFlrMsg.write((OutputStream)this.curOp.getResponse().getOutputStream(), true);
    }

    public void doGet(WebOp webOp) throws Exception {
        String string = webOp.getRequest().getRequestURI();
        if (string.startsWith("/flr/packs")) {
            this.lpf.doGet(new FlrOp(webOp, this.flr));
        } else {
            webOp.getResponse().sendError(400);
        }
    }

    public static String getTemplate(String string) throws IOException {
        return FileUtil.readString((BIFile)((BIFile)BOrd.make((String)string).get()));
    }

    public FlrServlet(BFlrService bFlrService) {
        this.flr = bFlrService;
        this.log = BFlrService.log;
        this.lpf = bFlrService.lpf();
        this.resolveCksum();
    }
}

