/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nd.virtual.DefaultNiagaraVirtualStationAdapter;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.IProxyActionParent;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.Version;

public final class FoxNiagaraVirtualCommsAdapter
implements INiagaraVirtualCommsAdapter {
    private static final BNiagaraVirtualGateway.PartialSlotInfo[] nullPartialSlotInfo = new BNiagaraVirtualGateway.PartialSlotInfo[0];
    private static final BVirtualAction[] nullProxyActions = new BVirtualAction[0];
    static final Version VERSION_START = new Version("3.4");
    static final Version VERSION_WRITABLE_START = new Version("3.5");
    static final Version VERSION_PARTIAL_DISCOVERY_START = new Version("3.7");
    private static final FoxLog log = FoxLog.make((String)"fox.niagaraVirtual");
    private BFoxClientConnection connection;
    private DefaultNiagaraVirtualStationAdapter stationAdapter;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BSlotInfo[] loadSlots(BOrd ord, String connectionDescription) throws Exception {
        BNiagaraVirtualChannel channel = this.getVirtualChannel();
        BSlotInfo[] infos = new BSlotInfo[]{};
        boolean supportsWritable = false;
        if (this.stationAdapter.getStationVersion(VERSION_START).compareTo((Object)VERSION_START) < 0) {
            throw new Exception("Remote Station version incorrect (must be 3.4 or greater) (" + Sys.getStation().getStationName() + ") ->" + this.stationAdapter.getStationName());
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                if (this.connection.getRemoteVersion().compareTo((Object)VERSION_WRITABLE_START) >= 0) {
                    supportsWritable = true;
                }
                infos = channel.discover(ord);
            }
            catch (Exception e) {
                throw new Exception("Component removed (" + Sys.getStation().getStationName() + ')');
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        this.connection.disengage((BFoxClientConnection.Interest)interest);
        int i = 0;
        while (i < infos.length) {
            if (!supportsWritable && !infos[i].getIsComponent()) {
                infos[i].setIsWritable(false);
            }
            ++i;
        }
        return infos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BNiagaraVirtualGateway.PartialSlotInfo[] loadPartial(BOrd rootOrd, BOrd[] vOrds, String connectionDescription) throws Exception {
        FoxConnectInterest interest;
        block3: {
            BNiagaraVirtualGateway.PartialSlotInfo[] partialSlotInfoArray;
            Version v = this.stationAdapter.getStationVersion(VERSION_PARTIAL_DISCOVERY_START);
            if (v.compareTo((Object)VERSION_PARTIAL_DISCOVERY_START) < 0) return nullPartialSlotInfo;
            BNiagaraVirtualChannel channel = this.getVirtualChannel();
            interest = new FoxConnectInterest(connectionDescription + ": " + this.stationAdapter.getStationName());
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                if (this.connection.getRemoteVersion().compareTo((Object)VERSION_PARTIAL_DISCOVERY_START) < 0) break block3;
                partialSlotInfoArray = channel.discoverPartial(rootOrd, vOrds);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.connection.disengage((BFoxClientConnection.Interest)interest);
                throw throwable;
            }
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            return partialSlotInfoArray;
        }
        Object var8_10 = null;
        this.connection.disengage((BFoxClientConnection.Interest)interest);
        return nullPartialSlotInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(BOrd ord, String name, BValue val, String connectionDescription) throws Exception {
        Version v = this.stationAdapter.getStationVersion(VERSION_WRITABLE_START);
        if (v.compareTo((Object)VERSION_WRITABLE_START) < 0) {
            throw new Exception("Can only write Properties to Stations with version 3.5 and greater (" + this.stationAdapter.getStationName() + ") Version: " + v);
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            if (this.connection.getRemoteVersion().compareTo((Object)VERSION_WRITABLE_START) < 0) throw new Exception("Can only write Properties to Stations with version 3.5 and greater (" + this.stationAdapter.getStationName() + ") Version: " + this.connection.getRemoteVersion());
            try {
                this.getPointChannel().write(ord, name, val);
            }
            catch (Exception e) {
                throw new Exception("Cannot perform write (" + Sys.getStation().getStationName() + " -> " + this.stationAdapter.getStationName() + ')');
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.connection.disengage((BFoxClientConnection.Interest)interest);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BValue getActionDefault(IProxyActionParent ext, BVirtualAction action, String connectionDescription) throws Exception {
        BPointChannel pointChannel = this.getPointChannel();
        if (pointChannel == null) {
            return null;
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        BValue val = null;
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            val = pointChannel.getActionDefault(ext, action);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        this.connection.disengage((BFoxClientConnection.Interest)interest);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BVirtualAction[] loadActions(IProxyActionParent ext, String connectionDescription) throws Exception {
        FoxConnectInterest interest;
        BPointChannel pointChannel;
        block4: {
            BVirtualAction[] bVirtualActionArray;
            pointChannel = this.getPointChannel();
            if (pointChannel == null) {
                return nullProxyActions;
            }
            interest = new FoxConnectInterest(connectionDescription);
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                if (this.connection.getRemoteVersion().compareTo((Object)VERSION_START) >= 0) break block4;
                bVirtualActionArray = nullProxyActions;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.connection.disengage((BFoxClientConnection.Interest)interest);
                throw throwable;
            }
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            return bVirtualActionArray;
        }
        BVirtualAction[] bVirtualActionArray = pointChannel.getActions(ext);
        Object var6_8 = null;
        this.connection.disengage((BFoxClientConnection.Interest)interest);
        return bVirtualActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BValue invokeAction(IProxyActionParent ext, BVirtualAction action, BValue arg, String connectionDescription) throws Exception {
        BValue bValue;
        BPointChannel pointChannel = this.getPointChannel();
        if (pointChannel == null) {
            return null;
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            bValue = pointChannel.invoke(ext, action, arg);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.connection.disengage((BFoxClientConnection.Interest)interest);
            throw throwable;
        }
        this.connection.disengage((BFoxClientConnection.Interest)interest);
        return bValue;
    }

    private final BNiagaraVirtualChannel getVirtualChannel() {
        return (BNiagaraVirtualChannel)this.connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE);
    }

    private final BPointChannel getPointChannel() {
        return (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
    }

    public final boolean isTraceOn() {
        return log.isTraceOn();
    }

    public final void trace(String msg) {
        log.trace(msg);
    }

    public final void message(String msg) {
        log.message(msg);
    }

    public final void error(String msg, Exception e) {
        log.error(msg, (Throwable)e);
    }

    public FoxNiagaraVirtualCommsAdapter(BFoxClientConnection connection, DefaultNiagaraVirtualStationAdapter stationAdapter) {
        this.connection = connection;
        this.stationAdapter = stationAdapter;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FoxConnectInterest
    implements BFoxClientConnection.Interest {
        private String name;

        public final String toString() {
            return this.name;
        }

        final void setName(String name) {
            this.name = name;
        }

        private final /* synthetic */ void this() {
            this.name = "";
        }

        FoxConnectInterest(String name) {
            this.this();
            this.name = name;
        }
    }
}

