/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.util;

import com.tridium.nd.util.Lock;
import com.tridium.nd.util.ReadWriteLock;
import java.util.HashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReentrantReadWriteLock
implements ReadWriteLock {
    final Sync sync;
    final ReadLock readerLock;
    final WriteLock writerLock;

    public Lock writeLock() {
        return this.writerLock;
    }

    public Lock readLock() {
        return this.readerLock;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    private final /* synthetic */ void this() {
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    public ReentrantReadWriteLock() {
        this.this();
        this.sync = new NonfairSync();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static abstract class Sync {
        private static final int NONE = 0;
        private static final int READER = 1;
        private static final int WRITER = 2;
        static final Integer IONE = new Integer(1);
        transient int activeReaders;
        transient Thread activeWriter;
        transient int waitingReaders;
        transient int waitingWriters;
        transient int writeHolds;
        transient HashMap readers;

        synchronized boolean startReadFromNewReader() {
            boolean pass = this.startRead();
            if (!pass) {
                ++this.waitingReaders;
            }
            return pass;
        }

        synchronized boolean startWriteFromNewWriter() {
            boolean pass = this.startWrite();
            if (!pass) {
                ++this.waitingWriters;
            }
            return pass;
        }

        synchronized boolean startReadFromWaitingReader() {
            boolean pass = this.startRead();
            if (pass) {
                --this.waitingReaders;
            }
            return pass;
        }

        synchronized boolean startWriteFromWaitingWriter() {
            boolean pass = this.startWrite();
            if (pass) {
                --this.waitingWriters;
            }
            return pass;
        }

        synchronized void cancelledWaitingReader() {
            --this.waitingReaders;
        }

        synchronized void cancelledWaitingWriter() {
            --this.waitingWriters;
        }

        boolean allowReader() {
            boolean bl = false;
            if (this.activeWriter == null && this.waitingWriters == 0 || this.activeWriter == Thread.currentThread()) {
                bl = true;
            }
            return bl;
        }

        synchronized boolean startRead() {
            Thread t = Thread.currentThread();
            Object c = this.readers.get(t);
            if (c != null) {
                this.readers.put(t, new Integer((Integer)c + 1));
                ++this.activeReaders;
                return true;
            }
            if (this.allowReader()) {
                this.readers.put(t, IONE);
                ++this.activeReaders;
                return true;
            }
            return false;
        }

        synchronized boolean startWrite() {
            if (this.activeWriter == Thread.currentThread()) {
                ++this.writeHolds;
                return true;
            }
            if (this.writeHolds == 0) {
                if (this.activeReaders == 0 || this.readers.size() == 1 && this.readers.get(Thread.currentThread()) != null) {
                    this.activeWriter = Thread.currentThread();
                    this.writeHolds = 1;
                    return true;
                }
                return false;
            }
            return false;
        }

        synchronized int endRead() {
            Thread t = Thread.currentThread();
            Object c = this.readers.get(t);
            if (c == null) {
                throw new IllegalMonitorStateException();
            }
            --this.activeReaders;
            if (c != IONE) {
                int h = (Integer)c - 1;
                Integer ih = h == 1 ? IONE : new Integer(h);
                this.readers.put(t, ih);
                return 0;
            }
            this.readers.remove(t);
            if (this.writeHolds > 0) {
                return 0;
            }
            if (this.activeReaders == 0 && this.waitingWriters > 0) {
                return 2;
            }
            return 0;
        }

        synchronized int endWrite() {
            if (this.activeWriter != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            --this.writeHolds;
            if (this.writeHolds > 0) {
                return 0;
            }
            this.activeWriter = null;
            if (this.waitingReaders > 0 && this.allowReader()) {
                return 1;
            }
            if (this.waitingWriters > 0) {
                return 2;
            }
            return 0;
        }

        synchronized Thread getOwner() {
            return this.activeWriter;
        }

        synchronized int getReadLockCount() {
            return this.activeReaders;
        }

        synchronized boolean isWriteLocked() {
            boolean bl = false;
            if (this.activeWriter != null) {
                bl = true;
            }
            return bl;
        }

        synchronized boolean isWriteLockedByCurrentThread() {
            boolean bl = false;
            if (this.activeWriter == Thread.currentThread()) {
                bl = true;
            }
            return bl;
        }

        synchronized int getWriteHoldCount() {
            int n = 0;
            if (this.isWriteLockedByCurrentThread()) {
                n = this.writeHolds;
            }
            return n;
        }

        synchronized int getReadHoldCount() {
            if (this.activeReaders == 0) {
                return 0;
            }
            Thread t = Thread.currentThread();
            Integer i = (Integer)this.readers.get(t);
            int n = 0;
            if (i != null) {
                n = i;
            }
            return n;
        }

        final synchronized boolean hasQueuedThreads() {
            boolean bl = false;
            if (this.waitingWriters > 0 || this.waitingReaders > 0) {
                bl = true;
            }
            return bl;
        }

        final synchronized int getQueueLength() {
            return this.waitingWriters + this.waitingReaders;
        }

        private final /* synthetic */ void this() {
            this.activeReaders = 0;
            this.activeWriter = null;
            this.waitingReaders = 0;
            this.waitingWriters = 0;
            this.writeHolds = 0;
            this.readers = new HashMap();
        }

        Sync() {
            this.this();
        }
    }

    public static class ReadLock
    implements Lock {
        final ReentrantReadWriteLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lock() {
            ReadLock readLock = this;
            synchronized (readLock) {
                if (this.lock.sync.startReadFromNewReader()) {
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                        if (this.lock.sync.startReadFromWaitingReader()) {
                            Object var5_4 = null;
                            if (!wasInterrupted) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!wasInterrupted) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startRead();
        }

        public void unlock() {
            switch (this.lock.sync.endRead()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock.signalWaiters();
                    return;
                }
            }
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        protected ReadLock(ReentrantReadWriteLock lock) {
            if (lock == null) {
                throw new NullPointerException();
            }
            this.lock = lock;
        }
    }

    public static class WriteLock
    implements Lock {
        final ReentrantReadWriteLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lock() {
            WriteLock writeLock = this;
            synchronized (writeLock) {
                if (this.lock.sync.startWriteFromNewWriter()) {
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                        if (this.lock.sync.startWriteFromWaitingWriter()) {
                            Object var5_4 = null;
                            if (!wasInterrupted) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!wasInterrupted) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startWrite();
        }

        public void unlock() {
            switch (this.lock.sync.endWrite()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock.signalWaiters();
                    return;
                }
            }
        }

        synchronized void signalWaiters() {
            this.notify();
        }

        public boolean isHeldByCurrentThread() {
            return this.lock.sync.isWriteLockedByCurrentThread();
        }

        public int getHoldCount() {
            return this.lock.sync.getWriteHoldCount();
        }

        protected WriteLock(ReentrantReadWriteLock lock) {
            if (lock == null) {
                throw new NullPointerException();
            }
            this.lock = lock;
        }
    }

    private static class NonfairSync
    extends Sync {
    }
}

