/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import java.io.IOException;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUserSyncChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static Log log;
    static /* synthetic */ Class class$com$tridium$nd$user$BUserSyncChannel;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "startSync") {
            return this.startSync(request);
        }
        if (command == "endSync") {
            return this.endSync(request);
        }
        if (command == "getUserStatus") {
            return this.getUserStatus(request);
        }
        if (command == "getOutOfSync") {
            return this.getOutOfSync(request);
        }
        if (command == "updateUsers") {
            return this.updateUsers(request);
        }
        if (command == "updateUsersFromServer") {
            return this.updateUsersFromServer(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        throw new InvalidCommandException(command);
    }

    private final boolean supportsPasswordHashing(Version v) {
        if (v == null) {
            log.warning("Could not determine remote baja version (app.hello)");
            return false;
        }
        int major = v.major();
        int minor = v.minor();
        int build = v.build();
        if (major < 3) {
            return false;
        }
        if (major == 3) {
            if (minor <= 4) {
                return false;
            }
            if (minor == 5) {
                boolean bl = false;
                if (build >= 400) {
                    bl = true;
                }
                return bl;
            }
            if (minor == 6) {
                boolean bl = false;
                if (build >= 400) {
                    bl = true;
                }
                return bl;
            }
            if (minor == 7) {
                boolean bl = false;
                if (build >= 100) {
                    bl = true;
                }
                return bl;
            }
            if (minor >= 8) {
                return true;
            }
        }
        return major > 3;
    }

    private final Version getServerBajaVersion() throws Exception {
        Version v = this.getServerConnection().getRemoteVersion();
        return v;
    }

    private final Version getClientBajaVersion() throws Exception {
        Version v = this.getClientConnection().getRemoteVersion();
        return v;
    }

    private final boolean serverSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getServerBajaVersion());
    }

    private final boolean clientSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getClientBajaVersion());
    }

    public BNiagaraUserDeviceExt getUserDeviceExt() {
        BFoxConnection conn = this.getConnection();
        NiagaraStation station = conn.getParentStation();
        if (station == null) {
            return null;
        }
        return ((BNiagaraStation)station).getUsers();
    }

    public void checkStatus(FoxResponse resp) throws Exception {
        String rc = resp.getString("status");
        if (!rc.equals("ok")) {
            throw new UserSyncException(resp.getString("msg"));
        }
    }

    public void startSync(boolean outgoing) throws Exception {
        if (log.isTraceOn()) {
            log.trace("client.startSync: outgoing=" + outgoing);
        }
        FoxRequest req = this.makeRequest("startSync");
        if (outgoing && !this.clientSupportsPasswordHashing()) {
            throw new Exception("one-way password hashing support mismatch");
        }
        req.add("outgoing", outgoing);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse startSync(FoxRequest req) throws Exception {
        boolean outgoing = req.getBoolean("outgoing");
        if (log.isTraceOn()) {
            log.trace("server.startSync: outgoing=" + outgoing);
        }
        FoxResponse resp = new FoxResponse(req);
        BNiagaraUserDeviceExt ext = this.getUserDeviceExt();
        if (!outgoing && !this.serverSupportsPasswordHashing()) {
            resp.add("status", "error");
            resp.add("msg", "one-way password hashing support mismatch");
        } else if (outgoing && !ext.getSyncInEnabled()) {
            resp.add("status", "error");
            resp.add("msg", "syncOut is disabled.");
        } else if (!outgoing && !ext.getSyncOutEnabled()) {
            resp.add("status", "error");
            resp.add("msg", "syncIn is disabled.");
        } else if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", "User synchronization is disabled.");
        } else {
            resp.add("status", "ok");
        }
        return resp;
    }

    public void endSync() throws Exception {
        FoxRequest req = this.makeRequest("endSync");
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse endSync(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BNiagaraUserDeviceExt ext = this.getUserDeviceExt();
        if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", "User synchronization is disabled.");
        } else {
            ext.syncComplete();
            resp.add("status", "ok");
        }
        return resp;
    }

    public UserStatus[] getUserStatus(String[] protoNames) throws Exception {
        FoxRequest req = this.makeRequest("getUserStatus");
        int i = 0;
        while (i < protoNames.length) {
            req.add("p", protoNames[i]);
            ++i;
        }
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        FoxTuple[] result = resp.list("u");
        if (result == null) {
            return new UserStatus[0];
        }
        UserStatus[] users = new UserStatus[result.length];
        int i2 = 0;
        while (i2 < users.length) {
            FoxMessage msg = (FoxMessage)result[i2];
            users[i2] = new UserStatus(msg.getString("n"), msg.getString("p"), msg.getString("v"));
            ++i2;
        }
        return users;
    }

    public FoxResponse getUserStatus(FoxRequest req) throws IOException {
        FoxTuple[] inProtos = req.list("p");
        String[] protoNames = new String[inProtos.length];
        int i = 0;
        while (i < inProtos.length) {
            protoNames[i] = ((FoxString)inProtos[i]).value;
            ++i;
        }
        BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
        UserStatus[] users = deviceExt.getUserStatus(protoNames);
        FoxResponse resp = new FoxResponse(req);
        resp.add("status", "ok");
        int i2 = 0;
        while (i2 < users.length) {
            FoxMessage user = new FoxMessage("u");
            user.add("n", users[i2].getUserName());
            user.add("p", users[i2].getPrototypeName());
            user.add("v", users[i2].getVersion());
            resp.add((FoxTuple)user);
            ++i2;
        }
        return resp;
    }

    public UserStatus[] getOutOfSync(UserStatus[] localUsers) throws Exception {
        FoxRequest req = this.makeRequest("getOutOfSync");
        int i = 0;
        while (i < localUsers.length) {
            FoxMessage user = new FoxMessage("u");
            user.add("n", localUsers[i].getUserName());
            user.add("p", localUsers[i].getPrototypeName());
            user.add("v", localUsers[i].getVersion());
            req.add((FoxTuple)user);
            ++i;
        }
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        FoxTuple[] result = resp.list("u");
        if (result == null) {
            return new UserStatus[0];
        }
        UserStatus[] outOfDate = new UserStatus[result.length];
        int i2 = 0;
        while (i2 < outOfDate.length) {
            FoxMessage msg = (FoxMessage)result[i2];
            outOfDate[i2] = new UserStatus(msg.getString("n"), msg.getString("p"), msg.getString("v"));
            ++i2;
        }
        return outOfDate;
    }

    public FoxResponse getOutOfSync(FoxRequest req) throws IOException {
        try {
            FoxTuple[] remoteStatus = req.list("u");
            UserStatus[] remoteUsers = new UserStatus[remoteStatus.length];
            int i = 0;
            while (i < remoteStatus.length) {
                FoxMessage status = (FoxMessage)remoteStatus[i];
                String userName = status.getString("n");
                String prototypeName = status.getString("p");
                String version = status.getString("v");
                remoteUsers[i] = new UserStatus(userName, prototypeName, version);
                ++i;
            }
            BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
            UserStatus[] outOfSync = deviceExt.getOutOfSync(remoteUsers);
            FoxResponse resp = new FoxResponse(req);
            resp.add("status", "ok");
            int i2 = 0;
            while (i2 < outOfSync.length) {
                FoxMessage user = new FoxMessage("u");
                user.add("n", outOfSync[i2].getUserName());
                user.add("p", outOfSync[i2].getPrototypeName());
                user.add("v", outOfSync[i2].getVersion());
                resp.add((FoxTuple)user);
                ++i2;
            }
            return resp;
        }
        catch (UserSyncException ex) {
            log.error("Error", (Throwable)((Object)ex));
            FoxResponse resp = new FoxResponse(req);
            resp.add("status", "error");
            resp.add("msg", ex.getMessage());
            return resp;
        }
    }

    public void updateUsers(BUser[] users) throws Exception {
        BComponent batch = new BComponent();
        int i = 0;
        while (i < users.length) {
            batch.add(users[i].getName(), users[i].newCopy());
            ++i;
        }
        if (log.isTraceOn()) {
            i = 0;
            while (i < users.length) {
                log.trace("sending update for: " + users[i].getName());
                ++i;
            }
        }
        FoxRequest req = this.makeRequest("updateUsers");
        req.add("bog", ValueDocEncoder.marshal((BValue)batch));
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        if (!resp.getString("status").equals("ok")) {
            throw new UserSyncException(resp.getString("msg"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public FoxResponse updateUsers(FoxRequest req) throws Exception {
        BUserSyncChannel.log.trace("update users");
        userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        deviceExt = this.getUserDeviceExt();
        bog = req.getString("bog");
        if (BUserSyncChannel.log.isTraceOn()) {
            BUserSyncChannel.log.trace("users to update:\n" + bog);
        }
        batch = (BComponent)ValueDocDecoder.unmarshal((String)bog);
        v0 = BUserSyncChannel.class$javax$baja$user$BUser;
        if (v0 == null) {
            v0 = BUserSyncChannel.class$javax$baja$user$BUser = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        }
        users = new Array(v0);
        c = batch.getProperties();
        if (true) ** GOTO lbl17
        do {
            users.add((Object)c.get());
lbl17:
            // 2 sources

            if ((v1 = BUserSyncChannel.class$javax$baja$user$BUser) != null) continue;
            v1 = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        } while (c.next(v1));
        i = 0;
        while (i < users.size()) {
            syncUser = (BUser)users.get(i);
            userName = syncUser.getName();
            batch.remove(userName);
            deviceExt.syncUser(userName, syncUser);
            ++i;
        }
        resp = new FoxResponse(req);
        resp.add("status", "ok");
        return resp;
    }

    /*
     * Unable to fully structure code
     */
    public void updateUsersFromServer(UserStatus[] outOfSync) throws Exception {
        deviceExt = this.getUserDeviceExt();
        req = this.makeRequest("updateUsersFromServer");
        i = 0;
        while (i < outOfSync.length) {
            user = new FoxMessage("u");
            user.add("n", outOfSync[i].getUserName());
            user.add("p", outOfSync[i].getPrototypeName());
            user.add("v", outOfSync[i].getVersion());
            req.add((FoxTuple)user);
            ++i;
        }
        resp = this.sendSync(req);
        this.checkStatus(resp);
        bog = resp.getString("bog");
        if (BUserSyncChannel.log.isTraceOn()) {
            BUserSyncChannel.log.trace("users to update:\n" + bog);
        }
        batch = (BComponent)ValueDocDecoder.unmarshal((String)bog);
        v0 = BUserSyncChannel.class$javax$baja$user$BUser;
        if (v0 == null) {
            v0 = BUserSyncChannel.class$javax$baja$user$BUser = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        }
        users = new Array(v0);
        c = batch.getProperties();
        if (true) ** GOTO lbl27
        do {
            users.add((Object)c.get());
lbl27:
            // 2 sources

            if ((v1 = BUserSyncChannel.class$javax$baja$user$BUser) != null) continue;
            v1 = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        } while (c.next(v1));
        i = 0;
        while (i < users.size()) {
            syncUser = (BUser)users.get(i);
            userName = syncUser.getName();
            batch.remove(userName);
            deviceExt.syncUser(userName, syncUser);
            ++i;
        }
    }

    public FoxResponse updateUsersFromServer(FoxRequest req) throws Exception {
        log.trace("update request");
        FoxTuple[] tuples = req.list("u");
        UserStatus[] users = new UserStatus[tuples.length];
        int i = 0;
        while (i < tuples.length) {
            FoxMessage status = (FoxMessage)tuples[i];
            String userName = status.getString("n");
            String prototypeName = status.getString("p");
            String version = status.getString("v");
            users[i] = new UserStatus(userName, prototypeName, version);
            ++i;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
        BComponent batch = new BComponent();
        int i2 = 0;
        while (i2 < users.length) {
            BUser user = (BUser)userService.get(users[i2].getUserName());
            if (user != null) {
                batch.add(user.getName(), user.newCopy());
            }
            ++i2;
        }
        FoxResponse resp = new FoxResponse(req);
        resp.add("status", "ok");
        resp.add("bog", ValueDocEncoder.marshal((BValue)batch));
        return resp;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BUserSyncChannel() {
        super("usersync");
    }

    static {
        Class clazz = class$com$tridium$nd$user$BUserSyncChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BUserSyncChannel = BUserSyncChannel.class("[Lcom.tridium.nd.user.BUserSyncChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"niagara.users");
    }
}

