/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.user.BUserSyncExt;
import com.tridium.nd.user.BUserSyncStrategy;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraUserDeviceExt
extends BDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BFoxClientConnection.Interest {
    public static final Property syncInEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property syncOutEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property status = BNiagaraUserDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraUserDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property syncStrategy = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BUserSyncStrategy.prototypeRequired, null);
    public static final Property syncRequired = BNiagaraUserDeviceExt.newProperty((int)1, (boolean)true, null);
    public static final Property syncDelay = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property syncRetry = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)15)));
    public static final Property lastSyncAttempt = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property lastSyncSuccess = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Action handleUserEvent = BNiagaraUserDeviceExt.newAction((int)4, (BValue)new BUserEvent(), null);
    public static final Action sync = BNiagaraUserDeviceExt.newAction((int)16, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    public static final int LOCAL_OVERRIDE = 0x10000000;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$nd$user$BNiagaraUserDeviceExt;
    static /* synthetic */ Class class$com$tridium$nd$user$UserStatus;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public boolean getSyncInEnabled() {
        return this.getBoolean(syncInEnabled);
    }

    public void setSyncInEnabled(boolean v) {
        this.setBoolean(syncInEnabled, v, null);
    }

    public boolean getSyncOutEnabled() {
        return this.getBoolean(syncOutEnabled);
    }

    public void setSyncOutEnabled(boolean v) {
        this.setBoolean(syncOutEnabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BUserSyncStrategy getSyncStrategy() {
        return (BUserSyncStrategy)this.get(syncStrategy);
    }

    public void setSyncStrategy(BUserSyncStrategy v) {
        this.set(syncStrategy, (BValue)v, null);
    }

    public boolean getSyncRequired() {
        return this.getBoolean(syncRequired);
    }

    public void setSyncRequired(boolean v) {
        this.setBoolean(syncRequired, v, null);
    }

    public BRelTime getSyncDelay() {
        return (BRelTime)this.get(syncDelay);
    }

    public void setSyncDelay(BRelTime v) {
        this.set(syncDelay, (BValue)v, null);
    }

    public BRelTime getSyncRetry() {
        return (BRelTime)this.get(syncRetry);
    }

    public void setSyncRetry(BRelTime v) {
        this.set(syncRetry, (BValue)v, null);
    }

    public BAbsTime getLastSyncAttempt() {
        return (BAbsTime)this.get(lastSyncAttempt);
    }

    public void setLastSyncAttempt(BAbsTime v) {
        this.set(lastSyncAttempt, (BValue)v, null);
    }

    public BAbsTime getLastSyncSuccess() {
        return (BAbsTime)this.get(lastSyncSuccess);
    }

    public void setLastSyncSuccess(BAbsTime v) {
        this.set(lastSyncSuccess, (BValue)v, null);
    }

    public void handleUserEvent(BUserEvent event) {
        this.invoke(handleUserEvent, (BValue)event, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BNiagaraUserDeviceExt getForStation(BNiagaraStation station) {
        SlotCursor c = station.getProperties();
        Class clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.BNiagaraUserDeviceExt;", false);
        }
        if (c.next(clazz)) {
            return (BNiagaraUserDeviceExt)c.get();
        }
        return null;
    }

    public static void setReadonly(BComplex root) {
        Property p;
        int flags;
        BComplex parent = root.getParent();
        if (parent != null && ((flags = parent.getFlags((Slot)(p = root.getPropertyInParent()))) & 1) != 0) {
            parent.setFlags((Slot)p, flags | 1);
        }
        BNiagaraUserDeviceExt.setChildrenReadonly(root);
    }

    private static final void setChildrenReadonly(BComplex root) {
        SlotCursor c = root.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!Flags.isReadonly((BComplex)root, (Slot)p)) {
                root.setFlags((Slot)p, root.getFlags((Slot)p) | 1);
            }
            if (!p.getType().is(BComponent.TYPE)) continue;
            BNiagaraUserDeviceExt.setChildrenReadonly((BComplex)c.get());
        }
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void updateStatus() {
        this.checkConfig();
        if (!(this.getNiagaraStation().getStatus().isDown() || this.getNiagaraStation().getStatus().isDisabled() || this.getStatus().isDisabled())) {
            this.setSyncRequired(true);
        }
        if (this.isRunning() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public final BFoxClientConnection getClientConnection() {
        return this.getNiagaraStation().getClientConnection();
    }

    public final BUserSyncChannel getClientUserChannel() {
        return (BUserSyncChannel)this.getNiagaraStation().getClientConnection().getChannels().get("usersync", BUserSyncChannel.TYPE);
    }

    public final BSysChannel getSysChannel() {
        return (BSysChannel)this.getNiagaraStation().getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    public void checkConfig() {
        BNiagaraStation station;
        BUserService userService = null;
        try {
            userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        if (userService == null) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("UserService not found.");
            return;
        }
        if (!userService.isDistributable()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(userService.getType().getTypeName() + " does not support distribution of user accounts.");
            return;
        }
        boolean fault = false;
        BStatus bStatus = this.getStatus();
        boolean bl = false;
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            bl = true;
        }
        this.setStatus(BStatus.makeDisabled((BStatus)bStatus, (boolean)bl));
        if (this.getSyncInEnabled() && this.getSyncOutEnabled()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("syncIn and syncOut cannot be enabled for the same station.");
            fault = true;
        }
        if (!fault) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setFaultCause("");
        }
        if ((station = this.getNiagaraStation()) != null) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)station.isDown()));
        }
    }

    public BUser getPrototype(String prototypeName) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        if (prototypeName.length() == 0 && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            return userService.getUserPrototypes().getDefaultPrototype();
        }
        BUser proto = (BUser)userService.getUserPrototypes().get(prototypeName);
        if (proto == null && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            proto = userService.getUserPrototypes().getDefaultPrototype();
        }
        return proto;
    }

    /*
     * Unable to fully structure code
     */
    public UserStatus[] getUserStatus(String[] protoNames) {
        allNetUsers = false;
        i = 0;
        while (i < protoNames.length) {
            if (protoNames[i].equals("*")) {
                allNetUsers = true;
                break;
            }
            ++i;
        }
        if ((v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus) == null) {
            v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        users = new Array(v0);
        userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        c = userService.getProperties();
        if (true) ** GOTO lbl31
        do {
            if ((user = (BUser)c.get()).getNetworkUser()) {
                if (allNetUsers) {
                    users.add((Object)new UserStatus(user));
                } else {
                    userProto = user.getPrototypeName();
                    if (userProto.length() != 0) {
                        i = 0;
                        while (i < protoNames.length) {
                            if (protoNames[i].equals(userProto)) {
                                users.add((Object)new UserStatus(user));
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
lbl31:
            // 8 sources

            if ((v1 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v1 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (c.next(v1));
        return (UserStatus[])users.trim();
    }

    /*
     * Unable to fully structure code
     */
    public UserStatus[] getOutOfSync(UserStatus[] remoteStatus) {
        if (!this.getSyncInEnabled()) {
            throw new UserSyncException("User synchronization is disabled. (syncIn)");
        }
        userMap = new HashMap<String, UserStatus>();
        i = 0;
        while (i < remoteStatus.length) {
            userMap.put(remoteStatus[i].getUserName(), remoteStatus[i]);
            ++i;
        }
        toRemove = new ArrayList<Property>(16);
        userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        c = userService.getProperties();
        if (true) ** GOTO lbl28
        do {
            if (!c.property().isFrozen() && (localUser = (BUser)c.get()).getNetworkUser()) {
                remoteUser = (UserStatus)userMap.get(localUser.getName());
                if (remoteUser == null) {
                    toRemove.add(c.property());
                } else if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && (proto = this.getPrototype(remoteUser.getPrototypeName())) == null) {
                    toRemove.add(c.property());
                } else if (!remoteUser.getPrototypeName().equals(localUser.getPrototypeName())) {
                    toRemove.add(c.property());
                }
            }
lbl28:
            // 8 sources

            if ((v0 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v0 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (c.next(v0));
        i = toRemove.iterator();
        while (i.hasNext()) {
            userService.remove((Property)i.next());
        }
        v1 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus;
        if (v1 == null) {
            v1 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        outOfSync = new Array(v1);
        i = userMap.values().iterator();
        while (i.hasNext()) {
            status = (UserStatus)i.next();
            existing = (BUser)userService.get(status.getUserName());
            proto = this.getPrototype(status.getPrototypeName());
            if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && proto == null || existing != null && existing.getVersion().equals(status.getVersion()) && (proto == null || existing.getPrototypeVersion().equals(proto.getVersion()))) continue;
            outOfSync.add((Object)status);
        }
        return (UserStatus[])outOfSync.trim();
    }

    public void syncUser(String userName, BUser incomingUser) {
        if (!this.getSyncInEnabled()) {
            return;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser localUser = (BUser)userService.get(userName);
        if (localUser == null) {
            this.addUser(userName, incomingUser);
        } else {
            this.updateUser(localUser, incomingUser);
        }
    }

    private final void addUser(String userName, BUser newUser) {
        this.applyPrototype(newUser);
        BUserSyncExt ext = new BUserSyncExt();
        ext.setSourceStation(this.getDevice().getSlotPathOrd());
        Property extProp = newUser.getProperty("syncExt");
        if (extProp == null) {
            newUser.add("syncExt", (BValue)ext, 1);
        } else {
            newUser.set(extProp, (BValue)ext);
        }
        BNiagaraUserDeviceExt.setReadonly((BComplex)newUser);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        userService.add(userName, (BValue)newUser, 1);
    }

    private final void updateUser(BUser existing, BUser sync) {
        this.applyPrototype(sync);
        BUserSyncExt ext = new BUserSyncExt();
        ext.setSourceStation(this.getDevice().getSlotPathOrd());
        Property extProp = sync.getProperty("syncExt");
        if (extProp == null) {
            sync.add("syncExt", (BValue)ext, 1);
        } else {
            sync.set(extProp, (BValue)ext);
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Property prop = userService.getProperty(existing.getName());
        if (!prop.isFrozen()) {
            BNiagaraUserDeviceExt.setReadonly((BComplex)sync);
        }
        userService.set(prop, (BValue)sync);
    }

    public void applyPrototype(BUser user) {
        BUser proto = this.getPrototype(user.getPrototypeName());
        if (proto == null) {
            return;
        }
        SlotCursor c = proto.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!this.isLocalOverride((BComponent)proto, (Slot)p)) continue;
            this.setFrom(proto, user, p);
        }
        c = user.getProperties();
        Array delMixIns = new Array();
        while (c.next()) {
            Property fromProto;
            Property p = c.property();
            if (p.isFrozen() || !p.getType().is(BIMixIn.TYPE) || (fromProto = proto.getProperty(p.getName())) != null) continue;
            delMixIns.add((Object)p);
        }
        int i = 0;
        while (i < delMixIns.size()) {
            user.remove((Property)delMixIns.get(i));
            ++i;
        }
        user.setPrototypeVersion(proto.getVersion());
    }

    private final boolean isLocalOverride(BComponent parent, Slot slot) {
        boolean bl = false;
        if ((parent.getFlags(slot) & 0x10000000) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void setFrom(BUser fromUser, BUser toUser, Property p) {
        Property fp = p;
        Property tp = p;
        if (!fp.isFrozen()) {
            tp = toUser.getProperty(fp.getName());
        }
        switch (p.getTypeAccess()) {
            case 0: {
                toUser.setBoolean(tp, fromUser.getBoolean(fp));
                break;
            }
            case 2: {
                toUser.setInt(tp, fromUser.getInt(fp));
                break;
            }
            case 3: {
                toUser.setLong(tp, fromUser.getLong(fp));
                break;
            }
            case 4: {
                toUser.setFloat(tp, fromUser.getFloat(fp));
                break;
            }
            case 5: {
                toUser.setDouble(tp, fromUser.getDouble(fp));
                break;
            }
            case 6: {
                toUser.setString(tp, fromUser.getString(fp));
                break;
            }
            case 7: {
                BValue fv = fromUser.get(fp);
                BValue tv = toUser.get(tp);
                if (tv.getClass() == fv.getClass() && !tv.isSimple()) {
                    tv.asComplex().copyFrom(fv.asComplex());
                    break;
                }
                toUser.set(tp, fv.newCopy());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        toUser.setFlags((Slot)tp, toUser.getFlags((Slot)p) & 0xEFFFFFFF);
    }

    public void started() {
        this.checkConfig();
        if (!this.getStatus().isDisabled()) {
            this.linkToService();
        }
        if (this.getSyncOutEnabled() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public void atSteadyState() {
        if (this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (!Flags.isReadonly((BComplex)this, (Slot)p)) {
            this.checkConfig();
        }
        if (p == status) {
            if (this.getStatus().isDisabled()) {
                this.unlinkFromService();
            } else {
                this.linkToService();
            }
        }
        if (this.getStatus().isFault()) {
            return;
        }
        if (p == syncRequired) {
            if (this.getSyncRequired()) {
                this.scheduleSync(false);
            } else {
                this.cancelSync();
            }
        } else if (p == syncOutEnabled && this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncInEnabled && this.getSyncInEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncDelay) {
            if (this.ticket != null) {
                this.scheduleSync(false);
            }
        } else if (p == syncStrategy) {
            this.setSyncRequired(true);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == sync) {
            BNiagaraStation station = (BNiagaraStation)this.getDevice();
            if (station != null) {
                station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
            }
            return null;
        }
        return super.post(action, arg, cx);
    }

    public void doHandleUserEvent(BUserEvent event) {
        this.setSyncRequired(true);
    }

    private final void linkToService() {
        if (this.get("serviceLink") != null) {
            return;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUserPrototypes prototypes = userService.getUserPrototypes();
        this.linkTo("serviceLink", (BComponent)userService, (Slot)BUserService.userEvent, (Slot)handleUserEvent);
        this.linkTo("serviceProtoLink", (BComponent)prototypes, (Slot)BUserPrototypes.userEvent, (Slot)handleUserEvent);
    }

    private final void unlinkFromService() {
        Property p = this.getProperty("serviceLink");
        if (p != null) {
            this.remove(p);
        }
    }

    public void doSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            return;
        }
        BNiagaraStation station = this.getNiagaraStation();
        if (station.getStatus().isDisabled()) {
            return;
        }
        if (station.getStatus().isDown()) {
            return;
        }
        this.setLastSyncAttempt(BAbsTime.now());
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            if (this.getSyncOutEnabled()) {
                this.syncToRemote();
            } else if (this.getSyncInEnabled()) {
                this.syncFromRemote();
            }
            this.syncComplete();
        }
        catch (Exception ex) {
            log.error("Cannot sync users with remote station.", (Throwable)ex);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            String message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
            this.setFaultCause(message);
            this.scheduleSync(true);
        }
        if (conn.isEngaged((BFoxClientConnection.Interest)this)) {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public void scheduleSync(boolean retry) {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)(retry ? this.getSyncRetry() : this.getSyncDelay()), (Action)sync, null);
        if (log.isTraceOn()) {
            log.trace("sync scheduled for " + this.getDevice().getName());
        }
    }

    public void cancelSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            if (log.isTraceOn()) {
                log.trace("sync cancelled for " + this.getDevice().getName());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void syncToRemote() throws Exception {
        if (BNiagaraUserDeviceExt.log.isTraceOn()) {
            BNiagaraUserDeviceExt.log.trace("sync users to " + this.getDevice().getName());
        }
        channel = this.getClientUserChannel();
        channel.startSync(true);
        userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus;
        if (v0 == null) {
            v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        temp = new Array(v0, userService.getSlotCount());
        c = userService.getProperties();
        if (true) ** GOTO lbl16
        do {
            if ((user = (BUser)c.get()).getNetworkUser()) {
                temp.add((Object)new UserStatus((BUser)c.get()));
            }
lbl16:
            // 4 sources

            if ((v1 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v1 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (c.next(v1));
        outOfSync = channel.getOutOfSync((UserStatus[])temp.trim());
        i = 0;
        while (i < outOfSync.length) {
            v2 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser;
            if (v2 == null) {
                v2 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
            }
            batch = new Array(v2);
            j = 0;
            while (j < 10 && i < outOfSync.length) {
                user = (BUser)userService.get(outOfSync[i].getUserName());
                if (user != null) {
                    batch.add((Object)user);
                    if (j + 1 < 10) {
                        ++i;
                    }
                }
                ++j;
            }
            channel.updateUsers((BUser[])batch.trim());
            ++i;
        }
        channel.endSync();
    }

    private final void syncFromRemote() throws Exception {
        if (log.isTraceOn()) {
            log.trace("sync users from " + this.getDevice().getName());
        }
        BUserSyncChannel channel = this.getClientUserChannel();
        channel.startSync(false);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        String[] protoNames = null;
        if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired) {
            protoNames = userService.getUserPrototypes().getPrototypeNames();
        } else if (this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            protoNames = new String[]{"*"};
        } else {
            throw new UserSyncException("Unsupported sync strategy: " + (Object)((Object)this.getSyncStrategy()));
        }
        UserStatus[] remoteUsers = channel.getUserStatus(protoNames);
        UserStatus[] outOfSync = this.getOutOfSync(remoteUsers);
        if (outOfSync.length != 0) {
            int i = 0;
            while (i < outOfSync.length) {
                Class clazz = class$com$tridium$nd$user$UserStatus;
                if (clazz == null) {
                    clazz = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
                }
                Array batch = new Array(clazz);
                int j = 0;
                while (j < 10 && i < outOfSync.length) {
                    batch.add((Object)outOfSync[i]);
                    if (j + 1 < 10) {
                        ++i;
                    }
                    ++j;
                }
                channel.updateUsersFromServer((UserStatus[])batch.trim());
                ++i;
            }
        }
        channel.endSync();
    }

    public void syncComplete() {
        this.setSyncRequired(false);
        this.setLastSyncSuccess(BAbsTime.now());
        this.checkConfig();
    }

    private final BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getParent();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.BNiagaraUserDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"user.png");
        log = Log.getLog((String)"niagara.users");
    }
}

