/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.nd.ui.sysdef.BBox;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.nd.ui.sysdef.ICancelHint;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.sys.BValue;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TaskDetailPane
implements Runnable,
ICancelHint {
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    private static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    private static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    private static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    private static final String unknownLabel = lex.getText("TaskDetailPane.status.notStarted");
    private BTextOutputPane log;
    private BLabel[] stateMessageLabels;
    private BLabel[] stateIconLabels;
    private TaskItem[] items;
    private TaskItem currentItem;
    private boolean canceled;
    private BWidget taskDetailPane;
    private boolean cancelEnabled;
    private BLabel bottomLabel;

    public abstract String getItemListHeading();

    public abstract TaskItem[] makeTaskItems();

    public final BWidget getPane() {
        if (this.taskDetailPane == null) {
            throw new IllegalStateException("must call init() before getPane()");
        }
        return this.taskDetailPane;
    }

    public void reset() {
        this.log.clear();
        int i = 0;
        while (i < this.items.length) {
            this.items[i].state = BJobState.unknown;
            this.stateMessageLabels[i].setText(TaskDetailPane.stateToLabel(BJobState.unknown));
            this.stateIconLabels[i].setImage(TaskDetailPane.stateToIcon(BJobState.unknown));
            ++i;
        }
        this.canceled = false;
        this.currentItem = null;
        this.setBottomLabelText("");
        this.setCancelEnabled(true);
        this.update();
    }

    public final BTextOutputPane getLog() {
        return this.log;
    }

    public final void setBottomLabelText(String text) {
        this.bottomLabel.setText(text);
    }

    public void init() {
        this.items = this.makeTaskItems();
        this.stateMessageLabels = new BLabel[this.items.length];
        this.stateIconLabels = new BLabel[this.items.length];
        BGridPane listPane = new BGridPane(1);
        listPane.setHalign(BHalign.left);
        listPane.setValign(BValign.top);
        listPane.add(null, (BValue)new BLabel(this.getItemListHeading()));
        BGridPane innerGrid = new BGridPane(4);
        innerGrid.setHalign(BHalign.left);
        innerGrid.setValign(BValign.top);
        innerGrid.add(null, (BValue)new BBox(16.0, 0.0));
        innerGrid.add(null, (BValue)new BNullWidget());
        innerGrid.add(null, (BValue)new BBox(10.0, 0.0));
        innerGrid.add(null, (BValue)new BNullWidget());
        int i = 0;
        while (i < this.items.length) {
            this.stateIconLabels[i] = new BLabel(TaskDetailPane.stateToIcon(BJobState.unknown));
            innerGrid.add(null, (BValue)this.stateIconLabels[i]);
            innerGrid.add(null, (BValue)new BLabel(this.items[i].description));
            innerGrid.add(null, (BValue)new BBox(0.0, 16.0));
            this.stateMessageLabels[i] = new BLabel(TaskDetailPane.stateToLabel(BJobState.unknown));
            innerGrid.add(null, (BValue)this.stateMessageLabels[i]);
            ++i;
        }
        listPane.add(null, (BValue)innerGrid);
        this.bottomLabel = new BLabel();
        listPane.add(null, (BValue)this.bottomLabel);
        this.log = new BTextOutputPane();
        this.taskDetailPane = new BEdgePane((BWidget)new BBorderPane((BWidget)listPane, 0.0, 0.0, 10.0, 0.0), null, null, null, (BWidget)this.log);
        this.log.setUseAutoScroll(true);
        this.update();
    }

    protected void setCurrentItem(TaskItem value, BJobState state) {
        this.setCurrentItem(value);
        this.updateCurrentItemState(state);
    }

    protected synchronized void setCurrentItem(TaskItem value) {
        this.currentItem = value;
    }

    protected final synchronized TaskItem getCurrentItem() {
        return this.currentItem;
    }

    protected final synchronized void updateCurrentItemState(BJobState state) {
        if (this.currentItem == null) {
            this.currentItem = this.items[0];
        }
        if (this.currentItem.state != state) {
            this.currentItem.state = this.stateTransition(this.currentItem.state, state);
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] == this.currentItem) {
                    this.stateMessageLabels[i].setText(TaskDetailPane.stateToLabel(this.currentItem.state));
                    this.stateIconLabels[i].setImage(TaskDetailPane.stateToIcon(this.currentItem.state));
                    break;
                }
                ++i;
            }
            this.update();
        }
    }

    protected synchronized BJobState update() {
        BJobState result = BJobState.unknown;
        int i = 0;
        while (i < this.items.length) {
            BJobState s = this.stateTransition(result, this.items[i].state);
            if (s == BJobState.success) {
                if (i == this.items.length - 1) {
                    return s;
                }
            } else {
                result = s;
            }
            ++i;
        }
        return result;
    }

    private final BJobState stateTransition(BJobState from, BJobState to) {
        if (from == to) {
            return from;
        }
        switch (from.getOrdinal()) {
            case 5: {
                return from;
            }
            case 3: {
                return to == BJobState.failed ? to : from;
            }
            case 0: {
                return to;
            }
            case 1: {
                return to == BJobState.unknown ? from : to;
            }
            case 4: {
                if (to == BJobState.failed || to == BJobState.canceled) {
                    return to;
                }
                return from;
            }
        }
        if (to == BJobState.failed || to == BJobState.canceled) {
            return to;
        }
        return from;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCancelEnabled(boolean value) {
        this.cancelEnabled = value;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void cancel() {
        this.cancel(true);
    }

    public void checkCanceled() throws ICancelHint.CanceledException {
        if (this.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    public void cancel(boolean pending) {
        if (this.isCancelEnabled()) {
            if (pending) {
                this.updateCurrentItemState(BJobState.canceling);
            } else {
                this.updateCurrentItemState(BJobState.canceled);
            }
            this.setCancelEnabled(false);
            this.canceled = true;
        } else if (!pending) {
            this.updateCurrentItemState(BJobState.canceled);
        }
    }

    protected static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return BImage.NULL;
    }

    protected static String stateToLabel(BJobState state) {
        if (state == BJobState.unknown) {
            return unknownLabel;
        }
        return state.toString();
    }

    private final /* synthetic */ void this() {
        this.currentItem = null;
        this.canceled = false;
        this.cancelEnabled = true;
    }

    public TaskDetailPane() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static class TaskItem {
        public BJobState state;
        public String description;

        private final /* synthetic */ void this() {
            this.state = BJobState.unknown;
        }

        public TaskItem(String description) {
            this.this();
            this.description = description;
        }
    }
}

