/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BLocalSysDefStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSysDefNetwork
extends BWbView
implements Runnable {
    public static final Action updateDetails = BSysDefNetwork.newAction((int)0, null);
    public static final Type TYPE;
    static Lexicon lex;
    static BImage foxTunnelIcon;
    BTextField startStation;
    BTextField targetStation;
    BTextEditorPane stationServices;
    private BNiagaraNetwork network = null;
    private ProviderSession sysdef = null;
    BTree tree = new BTree();
    Model model;
    Node localNode;
    static /* synthetic */ Class class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
    static /* synthetic */ Class class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node;

    public void updateDetails() {
        this.invoke(updateDetails, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.network = (BNiagaraNetwork)value;
        this.sysdef = this.network.getSysDefProvider().createSession("SysDefNetwork", context);
        BEdgePane view = new BEdgePane();
        this.loadTree();
        view.setCenter((BWidget)new BBorderPane((BWidget)this.tree, BBorder.inset, BInsets.DEFAULT));
        BGridPane temp = new BGridPane(4);
        this.startStation = new BTextField("Start");
        this.targetStation = new BTextField("Target");
        temp.add(null, (BValue)new BButton((Command)new ConnectCommand()));
        temp.add(null, (BValue)this.startStation);
        temp.add(null, (BValue)this.targetStation);
        temp.add(null, (BValue)new BButton((Command)new FindCommand()));
        temp.add(null, (BValue)new BButton((Command)new EngageTestCommand()));
        BEdgePane bottom = new BEdgePane();
        bottom.setTop((BWidget)temp);
        this.stationServices = new BTextEditorPane("", 5, 80, false);
        bottom.setBottom((BWidget)this.stationServices);
        view.setBottom((BWidget)bottom);
        this.setContent((BWidget)view);
        this.network.getWorkers().register(this, 1000L);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        return super.doSaveValue(value, cx);
    }

    public void deactivated() {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        super.deactivated();
    }

    public void stopped() throws Exception {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        super.stopped();
    }

    public void run() {
        this.tree.repaint();
        this.updateServices();
    }

    void updateServices() {
        Node selected = (Node)this.tree.getSelection().getNode();
        StringBuffer sb = new StringBuffer();
        if (selected != null) {
            BProviderStation ps = (BProviderStation)this.sysdef.getStation(selected.station);
            Object[] serviceTypes = ps.getServiceTypes().trim();
            SortUtil.sort((Object[])serviceTypes);
            int n = 0;
            if (serviceTypes != null) {
                n = serviceTypes.length;
            }
            int len = n;
            int i = 0;
            while (i < len) {
                sb.append(((BTypeSpec)serviceTypes[i]).getTypeName()).append("; ");
                if (i > 0 && i % 4 == 0) {
                    sb.append("\n");
                }
                ++i;
            }
        }
        this.stationServices.setText(sb.toString());
    }

    private final void loadTree() {
        BProviderStation local = (BProviderStation)this.sysdef.getLocalStation();
        BINiagaraStation[] supervisors = this.sysdef.getSupervisors(local);
        int i = 0;
        while (i < supervisors.length) {
            this.model.addRoot(new SupervisorNode((TreeModel)this.model, null, (BProviderStation)supervisors[i]));
            ++i;
        }
        this.localNode = new Node(this.model, null, local.getStationName());
        this.model.addRoot(this.localNode);
    }

    public void doUpdateDetails() {
        Node selected = (Node)this.tree.getSelection().getNode();
        if (selected == null) {
            System.out.println("None selected.");
        } else {
            System.out.println("Selected: " + selected.station);
            this.updateServices();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSysDefNetwork() {
        this.tree.setMultipleSelection(false);
        this.tree.setController((TreeController)new Controller());
        this.model = new Model();
        this.tree.setModel((TreeModel)this.model);
        this.linkTo((BComponent)this.tree, (Slot)BTree.actionPerformed, (Slot)updateDetails);
    }

    static {
        Class clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nd$ui$sysdef$BSysDefNetwork = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        foxTunnelIcon = BImage.make((BIcon)BIcon.std((String)"foxTunnel.png"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConnectCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            Node selected = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (selected != null) {
                BFoxSession sourceSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(selected.station));
                BOrd ord = sourceSession.getNavOrd();
                BNiagaraWbShell shell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
                if (!(shell.isApplet() || shell.isWebStart() || sourceSession.isConnected())) {
                    try {
                        BISession session = BSysDefNetwork.this.network.getSession();
                        BICredentials credentials = (BICredentials)((BComplex)((BFoxSession)session).getCredentials()).newCopy(true);
                        shell.resolve(ord, credentials);
                    }
                    catch (Throwable e) {
                        if (e instanceof UnresolvedException) {
                            e = e.getCause();
                        }
                        String msg = lex.getText("mgr.connect.cannotConnect", new Object[]{selected.station, ord});
                        BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                        return null;
                    }
                    if (!sourceSession.isConnected()) {
                        throw new IllegalStateException();
                    }
                }
                if (sourceSession != null) {
                    shell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)ord, (String)"station:|slot:/")));
                }
            }
            return null;
        }

        public ConnectCommand() {
            super((BWidget)BSysDefNetwork.this, "Connect");
            this.icon = foxTunnelIcon;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FindCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            String start = BSysDefNetwork.this.startStation.getText().length() == 0 ? ((Node)BSysDefNetwork.this.model.getRoot((int)(BSysDefNetwork.this.model.getRootCount() - 1))).station : BSysDefNetwork.this.startStation.getText();
            String[][] routes = BSysDefNetwork.this.sysdef.getRoutes(start, BSysDefNetwork.this.targetStation.getText());
            System.out.println("Routes from: " + start + " to " + BSysDefNetwork.this.targetStation.getText());
            int i = 0;
            while (i < routes.length) {
                System.out.println("  Route " + i + ": " + TextUtil.join((String[])routes[i], (char)','));
                ++i;
            }
            return null;
        }

        public FindCommand() {
            super((BWidget)BSysDefNetwork.this, "Find");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EngageTestCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            Node selected = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (selected != null) {
                BINiagaraStation nStation = BSysDefNetwork.this.sysdef.getStation(selected.station);
                nStation.engageNoRetry("test");
                System.out.println(nStation.getStationName() + " engaged " + nStation.isEngaged("test"));
                nStation.disengage("test");
            }
            return null;
        }

        public EngageTestCommand() {
            super((BWidget)BSysDefNetwork.this, "Engage/Disengage");
            this.icon = foxTunnelIcon;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Node
    extends TreeNode {
        String station;
        TreeNode[] subordinates;

        public TreeNode getChild(int index) {
            this.load();
            return this.subordinates[index];
        }

        public int getChildCount() {
            this.load();
            return this.subordinates.length;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"device.png"));
        }

        public String getText() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.station);
            BProviderStation ps = (BProviderStation)BSysDefNetwork.this.sysdef.getStation(this.station);
            sb.append("    -    foxTunnel: ").append((Object)ps.getFoxTunneling());
            if (ps.getOnlyTunnelKnownStations().getOrdinal() == 0) {
                sb.append("*");
            }
            sb.append(", httpTunnel: ").append((Object)ps.getHttpTunneling());
            if (ps.getProxyAuthenticationWhenTunneling().getOrdinal() == 0) {
                sb.append("*");
            }
            return sb.toString();
        }

        public boolean hasChildren() {
            return true;
        }

        protected void load() {
            if (this.subordinates == null) {
                System.out.println("Load: " + this.station);
                BINiagaraStation[] subs = BSysDefNetwork.this.sysdef.getSubordinates(BSysDefNetwork.this.sysdef.getStation(this.station));
                this.subordinates = new TreeNode[subs.length];
                int i = 0;
                while (i < subs.length) {
                    this.subordinates[i] = new Node(this.getModel(), this, subs[i].getStationName());
                    ++i;
                }
            }
        }

        public Node(TreeModel model, TreeNode parent, String station) {
            super(model, parent);
            this.station = station;
            this.subordinates = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SupervisorNode
    extends Node {
        public boolean hasChildren() {
            return false;
        }

        public SupervisorNode(TreeModel model, TreeNode parent, BProviderStation station) {
            super(model, parent, station.getStationName());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TreeModel {
        Array roots;

        public TreeNode getRoot(int index) {
            return (TreeNode)this.roots.get(index);
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public void addRoot(Node root) {
            this.roots.add((Object)root);
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node;
            if (clazz == null) {
                clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork$Node;", false);
            }
            this.roots = new Array(clazz);
        }

        Model() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TreeController {
        protected BMenu makePopup(TreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            if (menu == null) {
                menu = new BMenu();
            }
            menu.add(null, (Command)new LocalStationCommand(subject.getActiveNode(), BLocalSysDefStation.changeAllTunneling));
            menu.add(null, (Command)new LocalStationCommand(subject.getActiveNode(), BLocalSysDefStation.changeFoxTunneling));
            menu.add(null, (Command)new LocalStationCommand(subject.getActiveNode(), BLocalSysDefStation.changeHttpTunneling));
            menu.add(null, (Command)new LocalStationCommand(subject.getActiveNode(), BLocalSysDefStation.changeOnlyTunnelKnownStations));
            menu.add(null, (Command)new LocalStationCommand(subject.getActiveNode(), BLocalSysDefStation.changeProxyAuthenticationWhenTunneling));
            menu.add(null, (Command)new ConnectCommand());
            return menu;
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LocalStationCommand
    extends Command {
        Action action;
        Node selection;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            CommandArtifact commandArtifact;
            block8: {
                Object var6_9;
                BFoxSession sourceSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(this.selection.station));
                BFoxClientConnection.StringInterest interest = null;
                BOrd ord = sourceSession.getNavOrd();
                BNiagaraWbShell shell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
                if (!sourceSession.isConnected()) {
                    try {
                        if (shell.isApplet() || shell.isWebStart()) {
                            sourceSession.getConnection().setCheckBrandCompatibility(false);
                        }
                        BISession session = BSysDefNetwork.this.network.getSession();
                        BICredentials credentials = (BICredentials)((BComplex)((BFoxSession)session).getCredentials()).newCopy(true);
                        shell.resolve(ord, credentials);
                    }
                    catch (Throwable e) {
                        if (e instanceof UnresolvedException) {
                            e = e.getCause();
                        }
                        String msg = lex.getText("mgr.connect.cannotConnect", new Object[]{this.selection.station, ord});
                        BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                        return null;
                    }
                    if (!sourceSession.isConnected()) {
                        throw new IllegalStateException();
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("SysDefAction_").append(this.action.getName()).append("_");
                    sb.append(this.selection.station).append("_");
                    sb.append(BAbsTime.now().encodeToString());
                    interest = new BFoxClientConnection.StringInterest(sb.toString());
                    sourceSession.getConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
                }
                try {
                    BOrd networkOrd = BOrd.make((String)"service:niagaraDriver:NiagaraNetwork");
                    BNiagaraNetwork network = (BNiagaraNetwork)networkOrd.get((BObject)sourceSession);
                    BOrd compOrd = BOrd.make((BOrd)network.getSlotPathOrd(), (String)"slot:localStation");
                    BComponent comp = (BComponent)compOrd.get((BObject)network);
                    comp.lease();
                    InvokeActionCommand cmd = new InvokeActionCommand((BWidget)BSysDefNetwork.this, comp, this.action);
                    commandArtifact = cmd.doInvoke();
                    var6_9 = null;
                    if (interest == null) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        var6_9 = null;
                        if (interest == null) break block9;
                        sourceSession.getConnection().disengage(interest);
                    }
                    throw throwable;
                }
                sourceSession.getConnection().disengage(interest);
            }
            return commandArtifact;
        }

        public LocalStationCommand(TreeNode selection, Action action) {
            super((BWidget)BSysDefNetwork.this, action.getDefaultDisplayName(null));
            this.action = action;
            this.selection = (Node)selection;
        }
    }
}

