/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.history;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryImport;
import com.tridium.nd.history.BNiagaraSystemHistoryImport;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.nd.ui.history.BNiagaraHistoryImportManager;
import java.util.ArrayList;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.HistoryLearn;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NiagaraImportLearn
extends HistoryLearn {
    static Lexicon lex;
    static String lexRemote;
    FoxSessionSupport sessionSupport;
    String deviceName;
    static /* synthetic */ Class class$com$tridium$nd$ui$history$BNiagaraHistoryImportManager;

    static BNiagaraStation getStation(BComponent target) {
        BComponent parent = target;
        while (parent != null) {
            if (parent instanceof BNiagaraStation) {
                return (BNiagaraStation)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void load(BComponent target) {
        super.load(target);
        this.deviceName = NiagaraImportLearn.getStation(target).getName();
        BISession session = target.getSession();
        this.sessionSupport = session instanceof BFoxSession ? new FoxSessionSupport(this.getManager(), (BFoxSession)session) : new FoxSessionSupport(this.getManager(), null);
    }

    public Object[] getDiscovery(BComponent target) {
        BHistorySpace space = null;
        BNiagaraStation station = NiagaraImportLearn.getStation(target);
        BFoxSession session = ((BNiagaraHistoryImportManager)this.getManager()).openFoxSession(this.sessionSupport, station);
        if (session == null) {
            return null;
        }
        BOrd spaceOrd = BOrd.make((String)"history:");
        try {
            space = (BHistorySpace)spaceOrd.resolve((BObject)session).get();
        }
        catch (UnresolvedException e) {
            // empty catch block
        }
        if (space == null) {
            return new Object[0];
        }
        Object[] devs = space.listDevices();
        if (devs != null) {
            Object[] devNames = new String[devs.length];
            int i = 0;
            while (i < devNames.length) {
                devNames[i] = devs[i].getDeviceName();
                ++i;
            }
            SortUtil.sort((Object[])devNames, (Object[])devs);
        }
        Object[] d = devs;
        String targetStationName = ((BFoxSession)target.getSession()).getStationName();
        boolean needFilter = false;
        int i = 0;
        while (i < d.length) {
            BIHistory history;
            if (d[i] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i];
                if (dev.getDeviceName().equals(targetStationName)) {
                    needFilter = true;
                    break;
                }
            } else if (d[i] instanceof BIHistory && (history = (BIHistory)d[i]).getId().getDeviceName().equals(targetStationName)) {
                needFilter = true;
                break;
            }
            ++i;
        }
        if (!needFilter) {
            return d;
        }
        ArrayList<Object> result = new ArrayList<Object>(d.length);
        int i2 = 0;
        while (i2 < d.length) {
            BIHistory history;
            if (d[i2] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i2];
                if (!dev.getDeviceName().equals(targetStationName)) {
                    result.add(dev);
                }
            } else if (d[i2] instanceof BIHistory && !(history = (BIHistory)d[i2]).getId().getDeviceName().equals(targetStationName)) {
                result.add(history);
            }
            ++i2;
        }
        return result.toArray();
    }

    public MgrTypeInfo[] toTypes(Object discovery) {
        if (discovery instanceof BIHistory) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNiagaraHistoryImport.TYPE)};
        }
        return super.toTypes(discovery);
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (!(discovery instanceof BIHistory)) {
            return false;
        }
        if (!(component instanceof BHistoryImport)) {
            return false;
        }
        BIHistory h = (BIHistory)discovery;
        if (component instanceof BNiagaraSystemHistoryImport) {
            BHistoryConfig config = h.getConfig();
            if (config == null) {
                return false;
            }
            String list = ((BNiagaraSystemHistoryImport)component).getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                return false;
            }
            PatternFilter[] patterns = PatternFilter.parseList((String)list);
            boolean bl = false;
            if (patterns.length > 0 && BLocalHistoryDatabase.acceptSystemTags((BHistoryConfig)config, (PatternFilter[])patterns)) {
                bl = true;
            }
            return bl;
        }
        BHistoryImport imp = (BHistoryImport)component;
        BHistoryId id = h.getId();
        BHistoryId impId = imp.getHistoryId();
        boolean bl = false;
        if (id.equals((Object)impId) || impId.equals((Object)id.toShorthand(this.deviceName))) {
            bl = true;
        }
        return bl;
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        int n = 0;
        if (cols != null) {
            n = cols.length;
        }
        int size = n;
        MgrColumn[] newCols = new MgrColumn[size + 1];
        int i = 0;
        while (i < size) {
            newCols[i] = cols[i];
            ++i;
        }
        newCols[size] = new SystemTagColumn();
        return newCols;
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BIHistory history = (BIHistory)discovery;
        BHistoryId shorthandId = history.getId().toShorthand(this.deviceName);
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexRemote + '_' + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public NiagaraImportLearn(BHistoryImportManager manager) {
        super((BArchiveManager)manager);
    }

    static {
        Class clazz = class$com$tridium$nd$ui$history$BNiagaraHistoryImportManager;
        if (clazz == null) {
            clazz = class$com$tridium$nd$ui$history$BNiagaraHistoryImportManager = NiagaraImportLearn.class("[Lcom.tridium.nd.ui.history.BNiagaraHistoryImportManager;", false);
        }
        lex = Lexicon.make((Class)clazz);
        lexRemote = lex.getText("historyImportManager.remote");
    }

    static class SystemTagColumn
    extends MgrColumn {
        public Object get(Object row) {
            BHistoryConfig config;
            if (row instanceof BIHistory && (config = ((BIHistory)row).getConfig()) != null) {
                return config.getSystemTags();
            }
            return "";
        }

        SystemTagColumn(String name) {
            super(name, 1);
        }

        SystemTagColumn() {
            this(histLex.getText("historyExtManager.systemTags"));
        }
    }
}

