/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.history;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraSystemHistoryExport;
import com.tridium.nd.ui.history.NiagaraImportLearn;
import java.util.ArrayList;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BHistoryExportManager;
import javax.baja.driver.ui.history.ExportLearn;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NiagaraExportLearn
extends ExportLearn {
    static Lexicon lex;
    static String lexLocal;
    String parentStationName;
    static /* synthetic */ Class class$com$tridium$nd$ui$history$BNiagaraHistoryExportManager;

    public Object[] getDiscovery(BComponent target) {
        Object[] d = super.getDiscovery(target);
        BNiagaraStation station = NiagaraImportLearn.getStation(target);
        String targetStationName = station.getName();
        this.parentStationName = null;
        if (station != null) {
            BComplex parent = station.getParent();
            while (parent != null) {
                if (parent instanceof BStation) {
                    this.parentStationName = ((BStation)parent).getStationName();
                    break;
                }
                parent = parent.getParent();
            }
        }
        boolean needFilter = false;
        int i = 0;
        while (i < d.length) {
            BIHistory history;
            if (d[i] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i];
                if (dev.getDeviceName().equals(targetStationName)) {
                    needFilter = true;
                    break;
                }
            } else if (d[i] instanceof BIHistory && (history = (BIHistory)d[i]).getId().getDeviceName().equals(targetStationName)) {
                needFilter = true;
                break;
            }
            ++i;
        }
        if (!needFilter) {
            return d;
        }
        ArrayList<Object> result = new ArrayList<Object>(d.length);
        int i2 = 0;
        while (i2 < d.length) {
            BIHistory history;
            if (d[i2] instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)d[i2];
                if (!dev.getDeviceName().equals(targetStationName)) {
                    result.add(dev);
                }
            } else if (d[i2] instanceof BIHistory && !(history = (BIHistory)d[i2]).getId().getDeviceName().equals(targetStationName)) {
                result.add(history);
            }
            ++i2;
        }
        return result.toArray();
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (!(discovery instanceof BIHistory)) {
            return false;
        }
        if (!(component instanceof BHistoryExport)) {
            return false;
        }
        BIHistory h = (BIHistory)discovery;
        if (component instanceof BNiagaraSystemHistoryExport) {
            BHistoryConfig config = h.getConfig();
            if (config == null) {
                return false;
            }
            String list = ((BNiagaraSystemHistoryExport)component).getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                return false;
            }
            PatternFilter[] patterns = PatternFilter.parseList((String)list);
            boolean bl = false;
            if (patterns.length > 0 && BLocalHistoryDatabase.acceptSystemTags((BHistoryConfig)config, (PatternFilter[])patterns)) {
                bl = true;
            }
            return bl;
        }
        BHistoryExport exp = (BHistoryExport)component;
        BHistoryId id = h.getId();
        BHistoryId expId = exp.getHistoryId();
        boolean bl = false;
        if (id.equals((Object)expId) || expId.equals((Object)id.toShorthand(this.parentStationName))) {
            bl = true;
        }
        return bl;
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        int n = 0;
        if (cols != null) {
            n = cols.length;
        }
        int size = n;
        MgrColumn[] newCols = new MgrColumn[size + 1];
        int i = 0;
        while (i < size) {
            newCols[i] = cols[i];
            ++i;
        }
        newCols[size] = new NiagaraImportLearn.SystemTagColumn();
        return newCols;
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BIHistory history = (BIHistory)discovery;
        BHistoryId shorthandId = history.getId().toShorthand(this.parentStationName);
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexLocal + '_' + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public NiagaraExportLearn(BHistoryExportManager manager) {
        super(manager);
    }

    static {
        Class clazz = class$com$tridium$nd$ui$history$BNiagaraHistoryExportManager;
        if (clazz == null) {
            clazz = class$com$tridium$nd$ui$history$BNiagaraHistoryExportManager = NiagaraExportLearn.class("[Lcom.tridium.nd.ui.history.BNiagaraHistoryExportManager;", false);
        }
        lex = Lexicon.make((Class)clazz);
        lexLocal = lex.getText("historyExportManager.local");
    }
}

