/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BImage;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public abstract class NiagaraLearn
extends MgrLearn {
    public static final int UNESCAPE = 1;
    BComponent target;
    FoxSessionSupport sessionSupport;
    BOrd bqlQuery;
    BITable lastLearn;

    public NiagaraLearn(BAbstractManager manager) {
        super(manager);
    }

    public BComponent getTarget() {
        return this.target;
    }

    public BFoxSession getTargetSession() {
        return this.sessionSupport == null ? null : this.sessionSupport.getTargetSession();
    }

    protected BWidget makeJobBar() {
        return null;
    }

    public void load(BComponent target) {
        super.load(target);
        this.target = target;
        BISession session = target.getSession();
        this.sessionSupport = session instanceof BFoxSession ? new FoxSessionSupport(this.getManager(), (BFoxSession)session) : new FoxSessionSupport(this.getManager(), null);
    }

    public BFoxSession connect(BNiagaraStation s) {
        s.lease(1);
        return this.sessionSupport.connect(s.getStationName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BNiagaraStation s, boolean tunnel) {
        s.lease(1);
        return this.connect(s.getStationName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs(), s.getNiagaraNetwork(), tunnel);
    }

    public BFoxSession connect(BLearnStation s, boolean useHostName) {
        String host = useHostName ? s.getHostName() : s.getHostAddress();
        boolean useFoxs = false;
        if (s.getScheme().equalsIgnoreCase("foxs")) {
            useFoxs = true;
        }
        return this.sessionSupport.connect(s.getStationName(), BOrd.make((String)("ip:" + host)), s.getFoxPort(), useFoxs);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs) {
        return this.sessionSupport.connect(stationName, host, foxPort, useFoxs);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs, String[] tunnelAuthorities) {
        return this.sessionSupport.connect(stationName, host, foxPort, useFoxs, tunnelAuthorities);
    }

    BFoxSession connect(String stationName, BOrd host, int port, boolean useFoxs, BNiagaraNetwork net, boolean tunnel) {
        if (!tunnel) {
            return this.connect(stationName, host, port, useFoxs);
        }
        BFoxSession networkSession = (BFoxSession)net.getSession();
        String[] tunnelAuthorities = networkSession.getTunnelAuthorities();
        StringBuffer tunnelHost = new StringBuffer();
        net.getFoxService().lease();
        if (net.getFoxService().getOnlyTunnelKnownStations()) {
            tunnelHost.append(stationName);
        } else {
            String ipAddr = ((BHost)host.get()).getHostname();
            if (ipAddr.indexOf(58) != ipAddr.lastIndexOf(58) && !ipAddr.startsWith("[") && !ipAddr.endsWith("]")) {
                tunnelHost.append("[").append(ipAddr).append("]");
            } else {
                tunnelHost.append(ipAddr);
            }
        }
        tunnelHost.append(":" + port);
        String authority = tunnelHost.toString();
        if (tunnelAuthorities == null) {
            tunnelAuthorities = new String[]{authority};
        } else {
            int len = tunnelAuthorities.length;
            String[] temp = new String[len + 1];
            System.arraycopy(tunnelAuthorities, 0, temp, 0, len);
            temp[len] = authority;
            tunnelAuthorities = temp;
        }
        BOrd proxyHost = networkSession.getHost().getNavOrd();
        int proxyPort = networkSession.getPort();
        return this.connect(stationName, proxyHost, proxyPort, networkSession.getUseFoxs(), tunnelAuthorities);
    }

    public void bqlDiscover(BFoxSession session, BTypeSpec filterType) throws Exception {
        BComponentSpace space;
        BStation station;
        BBqlQueryBuilder builder;
        BOrd bql;
        if (this.bqlQuery == null) {
            String projection = this.getBqlProjection();
            this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType));
        }
        if ((bql = (builder = new BBqlQueryBuilder((BObject)(station = (BStation)(space = (BComponentSpace)session.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager())) == null) {
            return;
        }
        this.bqlQuery = bql.relativizeToSession();
        BITable table = (BITable)this.bqlQuery.get((BObject)session);
        this.updateTable(session, table);
    }

    public String getBqlProjection() {
        StringBuffer s = new StringBuffer();
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            Column col = (Column)cols[i];
            s.append(col.projection);
        }
        s.append(",icon");
        return s.toString();
    }

    public BImage getIcon(Object node) {
        return ((Node)node).getIcon();
    }

    public boolean hasChildren(Object node) {
        return ((Node)node).hasChildren();
    }

    public Object[] getChildren(Object node) {
        return ((Node)node).getChildren();
    }

    public void updateTable(BFoxSession session, BITable table) {
        this.lastLearn = table;
        Object[] roots = new Node[table.size()];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = this.makeNode(session);
            ((Node)roots[i]).update(table, i);
        }
        this.updateRoots(roots);
    }

    protected Node makeNode(BFoxSession session) {
        return new Node(session);
    }

    public static class Node {
        public BFoxSession session;
        public BImage icon;
        public BObject[] cells;

        public Node(BFoxSession session) {
            this.session = session;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return ((Column)col).get(this);
        }

        public boolean hasChildren() {
            return false;
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public void update(BITable table, int rowIndex) {
            ColumnList cols = table.getColumns();
            this.cells = new BObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = table.get(rowIndex, cols.get(c));
            }
            this.icon = BImage.make((String)table.get(rowIndex, cols.get(cols.size() - 1)).toString());
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;
        int special;

        public Column(String displayName, String projection) {
            this(displayName, projection, 0, 0);
        }

        public Column(String displayName, String projection, int flags) {
            this(displayName, projection, flags, 0);
        }

        public Column(String displayName, String projection, int flags, int special) {
            super(displayName, flags);
            this.projection = projection;
            this.special = special;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            BObject x = ((Node)discovery).cells[this.getColumnIndex()];
            if ((this.special & 1) != 0) {
                return SlotPath.unescape((String)x.toString());
            }
            return x;
        }
    }
}

