/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.Arrays;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.sys.BComplex;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;

public class FoxSessionSupport {
    static Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$FoxSessionSupport == null ? (class$com$tridium$nd$ui$FoxSessionSupport = FoxSessionSupport.class$("com.tridium.nd.ui.FoxSessionSupport")) : class$com$tridium$nd$ui$FoxSessionSupport));
    BAbstractManager manager;
    BFoxSession targetSession;
    static /* synthetic */ Class class$com$tridium$nd$ui$FoxSessionSupport;

    public FoxSessionSupport(BAbstractManager manager, BFoxSession targetSession) {
        this.manager = manager;
        this.targetSession = targetSession;
    }

    public BFoxSession getTargetSession() {
        return this.targetSession;
    }

    public BFoxSession connect(BNiagaraStation s) {
        s.lease(1);
        return this.connect(s.getName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BLearnStation s) {
        boolean useFoxs = false;
        if (s.getScheme().equalsIgnoreCase("foxs")) {
            useFoxs = true;
        }
        return this.connect(s.getStationName(), BOrd.make((String)("ip:" + s.getHostAddress())), s.getFoxPort(), useFoxs);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs) {
        return this.connect(stationName, host, foxPort, useFoxs, null);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs, String[] tunnelAuthorities) {
        if (this.targetSession == null) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.noTargetSession"));
            return null;
        }
        BFoxSession sourceSession = null;
        BFoxSession[] sessions = BFoxSession.list();
        for (int i = 0; i < sessions.length; ++i) {
            if (!stationName.equals(sessions[i].getStationName()) || !Arrays.equals(tunnelAuthorities, sessions[i].getTunnelAuthorities())) continue;
            sourceSession = sessions[i];
            break;
        }
        if (sourceSession == null) {
            BHost hostInstance = (BHost)host.get();
            sourceSession = BFoxSession.make((String)stationName, (BHost)hostInstance, (int)foxPort, (boolean)useFoxs, (String[])tunnelAuthorities);
        }
        if (!sourceSession.isConnected()) {
            BOrd ord = sourceSession.getNavOrd();
            BNiagaraWbShell shell = (BNiagaraWbShell)this.manager.getWbShell();
            try {
                BICredentials credentials = (BICredentials)((BComplex)this.targetSession.getCredentials()).newCopy(true);
                shell.resolve(ord, credentials);
            }
            catch (Throwable e) {
                if (e instanceof UnresolvedException) {
                    e = e.getCause();
                }
                String msg = shell.isApplet() || shell.isWebStart() ? lex.getText("mgr.connect.cannotConnect.applet") : lex.getText("mgr.connect.cannotConnect", new Object[]{stationName, ord});
                BDialog.error((BWidget)this.manager, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                return null;
            }
        }
        if (!sourceSession.isConnected()) {
            throw new IllegalStateException();
        }
        if (!stationName.equals(sourceSession.getStationName())) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.mismatchStationName", new Object[]{host, sourceSession.getStationName(), stationName}));
            return null;
        }
        return sourceSession;
    }

    public BFoxSession fwConnect(BNiagaraStation s) throws Exception {
        s.lease(1);
        String stationName = s.getStationName();
        BNiagaraNetwork net = s.getNiagaraNetwork();
        BFoxSession networkSession = (BFoxSession)net.getSession();
        String[] tunnelAuthorities = networkSession.getTunnelAuthorities();
        StringBuffer tunnelHost = new StringBuffer();
        tunnelHost.append(stationName);
        tunnelHost.append(":" + s.getClientConnection().getPort());
        String authority = tunnelHost.toString();
        if (tunnelAuthorities == null) {
            tunnelAuthorities = new String[]{authority};
        } else {
            int len = tunnelAuthorities.length;
            String[] temp = new String[len + 1];
            System.arraycopy(tunnelAuthorities, 0, temp, 0, len);
            temp[len] = authority;
            tunnelAuthorities = temp;
        }
        BOrd proxyHost = networkSession.getHost().getNavOrd();
        int proxyPort = networkSession.getPort();
        return this.fwConnect(stationName, proxyHost, proxyPort, networkSession.getUseFoxs(), tunnelAuthorities);
    }

    BFoxSession fwConnect(String stationName, BOrd host, int foxPort, boolean useFoxs, String[] tunnelAuthorities) throws Exception {
        if (this.targetSession == null) {
            throw new IllegalStateException(lex.getText("mgr.connect.noTargetSession"));
        }
        BHost hostInstance = (BHost)host.get();
        BFoxSession sourceSession = useFoxs ? (BFoxSession)this.targetSession.fw(806, (Object)stationName, (Object)hostInstance, (Object)new Integer(foxPort), (Object)tunnelAuthorities) : (BFoxSession)this.targetSession.fw(802, (Object)stationName, (Object)hostInstance, (Object)new Integer(foxPort), (Object)tunnelAuthorities);
        BNiagaraWbShell shell = (BNiagaraWbShell)this.manager.getWbShell();
        if (shell.isApplet() || shell.isWebStart()) {
            sourceSession.getConnection().setCheckBrandCompatibility(false);
        }
        BICredentials credentials = (BICredentials)((BComplex)this.targetSession.getCredentials()).newCopy(true);
        sourceSession.setCredentials(credentials);
        boolean connected = false;
        Exception e = null;
        boolean loginFailure = false;
        while (!connected) {
            try {
                sourceSession.connect();
            }
            catch (AuthenticationException ex) {
                if (AuthUtil.challenge((BWidget)shell, (AuthenticationException)ex, (boolean)loginFailure)) {
                    loginFailure = true;
                    continue;
                }
                return null;
            }
            catch (Exception ex2) {
                e = ex2;
            }
            connected = true;
        }
        if (e != null) {
            try {
                sourceSession.disconnect();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw e;
        }
        if (!sourceSession.isConnected()) {
            throw new IllegalStateException();
        }
        if (!stationName.equals(sourceSession.getStationName())) {
            try {
                sourceSession.disconnect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new IllegalStateException(lex.getText("mgr.connect.mismatchStationName", new Object[]{host, sourceSession.getStationName(), stationName}));
        }
        return sourceSession;
    }

    public static int getFwConnectionType(BFoxSession session) {
        int fwConnType = -1;
        try {
            Object val;
            if (session != null && (val = session.getConnection().fw(803, null, null, null, null)) instanceof Integer) {
                fwConnType = (Integer)val;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fwConnType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

