/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.BStationMgrCommand;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.nd.ui.StationModel;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BStationManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nd$ui$BStationManager == null ? (class$com$tridium$nd$ui$BStationManager = BStationManager.class$("com.tridium.nd.ui.BStationManager")) : class$com$tridium$nd$ui$BStationManager));
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    static BImage secureStationIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/lock.png")));
    static boolean lastUseHostName = false;
    final Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$BStationManager == null ? (class$com$tridium$nd$ui$BStationManager = BStationManager.class$("com.tridium.nd.ui.BStationManager")) : class$com$tridium$nd$ui$BStationManager));
    final String lexFoxPort = this.lex.getText("stationManager.foxPort");
    final String lexUseFoxs = this.lex.getText("stationManager.useFoxs");
    final String lexClientConn = this.lex.getText("stationManager.clientConn");
    final String lexServerConn = this.lex.getText("stationManager.serverConn");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(2);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BNiagaraStation());
    MgrColumn colAddress = new MgrColumn.Prop(BNiagaraStation.address, 1);
    MgrColumn colFoxPort = new MgrColumn.PropPath(this.lexFoxPort, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.port}, 3);
    MgrColumn colUseFoxs = new MgrColumn.PropPath(this.lexUseFoxs, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.useFoxs}, 3);
    MgrColumn colHostModel = new MgrColumn.Prop(BNiagaraStation.hostModel);
    MgrColumn colVersion = new MgrColumn.Prop(BNiagaraStation.version);
    MgrColumn colUser = new MgrColumn.PropPath(new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.username}, 3);
    MgrColumn colPass = new MgrColumn.PropPath(new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.password}, 3);
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colFatalCause = new MgrColumn.Prop(BDevice.faultCause, 2);
    MgrColumn colClientConn = new MgrColumn.PropPath(this.lexClientConn, new Property[]{BNiagaraStation.clientConnection, BFoxConnection.state}, 0);
    MgrColumn colServerConn = new MgrColumn.PropPath(this.lexServerConn, new Property[]{BNiagaraStation.serverConnection, BFoxConnection.state}, 0);
    MgrColumn colVirtualsEnabled = new MgrColumn.Prop(BNiagaraStation.virtualsEnabled, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colDeviceExts, this.colAddress, this.colFoxPort, this.colUseFoxs, this.colHostModel, this.colVersion, this.colUser, this.colPass, this.colStatus, this.colEnabled, this.colHealth, this.colFatalCause, this.colClientConn, this.colServerConn, this.colVirtualsEnabled};
    BIDeviceFolder folder;
    BNiagaraNetwork network;
    BLearnStation[] lastLearn;
    ToggleCommand useHostName = new ToggleCommand((BWidget)this, "Use Host Name");
    ToggleCommand useHostAddress = new ToggleCommand((BWidget)this, "Use Host Address");
    static /* synthetic */ Class class$com$tridium$nd$ui$BStationManager;
    static /* synthetic */ Class class$com$tridium$fox$sys$BLearnStation;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController$IMgrCommand;

    public Type getType() {
        return TYPE;
    }

    public BStationManager() {
        boolean lastUseHostName = BStationManager.lastUseHostName;
        HostToggle toggleGroup = new HostToggle();
        toggleGroup.add(this.useHostName);
        toggleGroup.add(this.useHostAddress);
        if (lastUseHostName) {
            this.useHostName.setSelected(true);
        } else {
            this.useHostAddress.setSelected(true);
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getCurrentValue();
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.folder = (BIDeviceFolder)value;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BLearnStation[])event.getChildren(class$com$tridium$fox$sys$BLearnStation == null ? (class$com$tridium$fox$sys$BLearnStation = BStationManager.class$("com.tridium.fox.sys.BLearnStation")) : class$com$tridium$fox$sys$BLearnStation);
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (BLearnStation)rows[i].newCopy();
        }
        this.learnRowsInvariant(rows);
        this.lastLearn = rows;
        this.getLearn().updateRoots(rows);
    }

    public void learnRowsInvariant(Object[] rows) {
        boolean useHostName = this.useHostName.isSelected();
        for (int i = 0; i < rows.length; ++i) {
            BLearnStation row = (BLearnStation)rows[i];
            row.invariant(useHostName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OpenStationCommand
    extends Command {
        String stationName;
        BOrd host;
        int port;
        boolean useFoxs;
        boolean tunnel;
        BMouseEvent event;

        OpenStationCommand(BWidget owner, BNiagaraStation station, BMouseEvent event, boolean tunnel) {
            super(owner, BStationManager.this.lex.module, tunnel ? "stationManager.openStationTunnel" : "stationManager.openStation");
            this.stationName = station.getName();
            this.host = station.getAddress();
            this.port = station.getClientConnection().getPort();
            this.useFoxs = station.getClientConnection().getUseFoxs();
            this.event = event;
            this.tunnel = tunnel;
        }

        OpenStationCommand(BWidget owner, BLearnStation station, BMouseEvent event, boolean tunnel) {
            super(owner, BStationManager.this.lex.module, tunnel ? "stationManager.openStationTunnel" : "stationManager.openStation");
            String host = BStationManager.this.useHostName.isSelected() ? station.getHostName() : station.getHostAddress();
            this.stationName = station.getStationName();
            this.host = BOrd.make((String)("ip:" + host));
            this.port = station.getFoxPort();
            this.useFoxs = false;
            if (station.getScheme().equalsIgnoreCase("foxs")) {
                this.useFoxs = true;
            }
            this.event = event;
            this.tunnel = tunnel;
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraNetwork net;
            Learn learn = (Learn)BStationManager.this.getLearn();
            BFoxSession session = learn.connect(this.stationName, this.host, this.port, this.useFoxs, net = BStationManager.this.network != null ? BStationManager.this.network : BStationManager.this.getNetwork(), this.tunnel);
            if (session != null) {
                BStationManager.this.getWbShell().hyperlink(new HyperlinkInfo(session.getNavOrd(), (BInputEvent)this.event));
            }
            return null;
        }
    }

    class Controller
    extends DeviceController {
        Controller(BStationManager mgr) {
            super((BDeviceManager)mgr);
            this.allDescendants.setFlags(this.allDescendants.getFlags() | 8);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BStationManager.this.getLearn().setJob(BStationManager.this.network.submitStationDiscoveryJob());
            return null;
        }

        public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1) {
                BLearnStation station = (BLearnStation)subject.get(0);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null, false));
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null, true));
            }
            return menu;
        }

        public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu) {
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1 && subject.get(0) instanceof BNiagaraStation) {
                BNiagaraStation station = (BNiagaraStation)subject.get(0);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null, false));
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null, true));
            }
            return menu;
        }

        public BMenu makeOptionsMenu(BLearnTable table, BMenu menu) {
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)BStationManager.this.useHostName);
            menu.add(null, (Command)BStationManager.this.useHostAddress);
            return menu;
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            try {
                Mark data = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
                BObject[] objects = data.getValues();
                boolean allSessions = objects.length > 0;
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] instanceof BFoxSession) continue;
                    allSessions = false;
                    break;
                }
                if (allSessions) {
                    MgrEdit edit = new MgrEdit(this.getManager(), this.add.getLabel());
                    for (int i = 0; i < objects.length; ++i) {
                        BFoxSession session = (BFoxSession)objects[i];
                        BNiagaraStation station = new BNiagaraStation();
                        station.setAddress(session.getHost().getAbsoluteOrd());
                        station.getClientConnection().setPort(session.getPort());
                        MgrEditRow row = new MgrEditRow((BComponent)station, null, null);
                        edit.addRow(row);
                        if (session.getStationName() == null) continue;
                        row.setName(session.getStationName());
                    }
                    return edit.invoke(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.drop(table, cx);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            TypeInfo[] infos = Sys.getRegistry().getConcreteTypes(BStationMgrCommand.TYPE.getTypeInfo());
            Array cmdArray = new Array(class$javax$baja$workbench$mgr$MgrController$IMgrCommand == null ? (class$javax$baja$workbench$mgr$MgrController$IMgrCommand = BStationManager.class$("javax.baja.workbench.mgr.MgrController$IMgrCommand")) : class$javax$baja$workbench$mgr$MgrController$IMgrCommand);
            for (int i = 0; i < infos.length; ++i) {
                BStationMgrCommand stationCmd = (BStationMgrCommand)infos[i].getInstance();
                if (!stationCmd.isCommandActive(BStationManager.this)) continue;
                cmdArray.add((Object)stationCmd.makeCommand(BStationManager.this));
            }
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])cmdArray.trim()));
        }

        public void updateCommands() {
            MgrController.IMgrCommand[] cmds = this.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                if (!(cmds[i] instanceof BStationMgrCommand.Cmd)) continue;
                BStationMgrCommand.Cmd stationCmd = (BStationMgrCommand.Cmd)cmds[i];
                stationCmd.updateCommand();
            }
            super.updateCommands();
        }
    }

    static class State
    extends DeviceState {
        BLearnStation[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BStationManager manager = (BStationManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BStationManager manager = (BStationManager)m;
            if (this.lastLearn != null) {
                manager.lastLearn = this.lastLearn;
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class HostToggle
    extends ToggleCommandGroup {
        HostToggle() {
        }

        protected void selected(ToggleCommand command) {
            lastUseHostName = command == BStationManager.this.useHostName;
            MgrLearn learn = BStationManager.this.getLearn();
            if (learn == null) {
                return;
            }
            Object[] rows = BStationManager.this.getLearn().getRoots();
            if (rows == null) {
                return;
            }
            BStationManager.this.learnRowsInvariant(rows);
            learn.getTable().repaint();
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BStationManager mgr) {
            super((BAbstractManager)mgr);
        }

        public BWidget makeJobBar() {
            return new BJobBar();
        }

        protected MgrColumn[] makeColumns() {
            Property[] props = new BLearnStation().getPropertiesArray();
            MgrColumn[] cols = new MgrColumn[props.length];
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                int propFlags = prop.getDefaultFlags();
                int colFlags = 0;
                if ((propFlags & 8) == 0) {
                    colFlags |= 2;
                }
                cols[i] = new MgrColumn.Prop(props[i], colFlags);
            }
            return cols;
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }

        public BImage getIcon(Object dis) {
            BLearnStation learn = (BLearnStation)dis;
            if (learn.getScheme().equalsIgnoreCase("foxs")) {
                return secureStationIcon;
            }
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return BStationManager.this.getModel().getNewTypes();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BLearnStation learn = (BLearnStation)dis;
            String host = BStationManager.this.useHostName.isSelected() ? learn.getHostName() : learn.getHostAddress();
            row.setName(learn.getStationName());
            row.setCell(BStationManager.this.colAddress, (BValue)BOrd.make((String)("ip:" + host)));
            row.setCell(BStationManager.this.colFoxPort, (BValue)BInteger.make((int)learn.getFoxPort()));
            row.setCell(BStationManager.this.colUseFoxs, (BValue)(learn.getScheme().equalsIgnoreCase("foxs") ? BBoolean.TRUE : BBoolean.FALSE));
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BLearnStation learn = (BLearnStation)dis;
            if (comp instanceof BNiagaraStation) {
                BNiagaraStation station = (BNiagaraStation)comp;
                return learn.getStationName().equals(station.getName());
            }
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BStationManager.this.updateDiscoveryRows((BComponent)job);
        }
    }

    class Model
    extends StationModel {
        Model(BStationManager manager) {
            super(manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BNiagaraStation.TYPE);
        }

        public int getSubscribeDepth() {
            return 1;
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BStationManager.this.cols, BNiagaraStation.TYPE);
        }
    }
}

