/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BNiagaraPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nd$ui$BNiagaraPointManager == null ? (class$com$tridium$nd$ui$BNiagaraPointManager = BNiagaraPointManager.class$("com.tridium.nd.ui.BNiagaraPointManager")) : class$com$tridium$nd$ui$BNiagaraPointManager));
    final Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$BNiagaraPointManager == null ? (class$com$tridium$nd$ui$BNiagaraPointManager = BNiagaraPointManager.class$("com.tridium.nd.ui.BNiagaraPointManager")) : class$com$tridium$nd$ui$BNiagaraPointManager));
    final Lexicon driverLex = Lexicon.make((String)"driver");
    final String lexOut = this.driverLex.getText("out");
    final String lexSlotPath = UiLexicon.bajaui.getText("slotPath");
    final String lexHandle = UiLexicon.bajaui.getText("handle");
    final String lexType = UiLexicon.bajaui.getText("type");
    final String lexDisplayNames = UiLexicon.bajaui.getText("displayNames");
    final String lexDisplayName = UiLexicon.bajaui.getText("displayName");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colDisplayName = new DisplayNameColumn(this.lexDisplayName, 3);
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colPointId = new PointIdColumn(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.pointId}, 1);
    MgrColumn colString = new MgrColumn.ToString(this.lexOut, 0);
    MgrColumn colSubStatus = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.subscriptionStatus}, 0);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.enabled}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.tuningPolicyName}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.readValue}, 2);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.conversion}, 3);
    MgrColumn colDisplayNames = new DisplayNamesColumn(this.lexDisplayNames, 6);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colDisplayName, this.colType, this.colPointId, this.colString, this.colEnabled, this.colFacets, this.colTuning, this.colSubStatus, this.colFaultCause, this.colReadValue, this.colDeviceFacets, this.colConversion, this.colDisplayNames};
    MgrColumn dcolPath = new NiagaraLearn.Column(this.lexSlotPath, "toPathString", 0, 1);
    MgrColumn dcolHandle = new NiagaraLearn.Column(this.lexHandle, "handle", 2);
    MgrColumn dcolType = new NiagaraLearn.Column(this.lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    BIPointFolder folder;
    BNiagaraStation station;
    BNiagaraPointDeviceExt points;
    TunnelDiscoveryMode tunnelDiscovery;
    BFoxSession session;
    static /* synthetic */ Class class$com$tridium$nd$ui$BNiagaraPointManager;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void stopped() throws Exception {
        try {
            if (FoxSessionSupport.getFwConnectionType(this.session) != -1) {
                this.session.disconnect();
            }
            this.session = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stopped();
    }

    public void deactivated() {
        try {
            if (FoxSessionSupport.getFwConnectionType(this.session) != -1) {
                this.session.disconnect();
            }
            this.session = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.deactivated();
    }

    BFoxSession openFoxSession() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                return this.session;
            }
            this.session.disconnect();
        }
        Learn learn = (Learn)this.getLearn();
        try {
            this.session = learn.sessionSupport.fwConnect(this.station);
        }
        catch (Exception e) {
            this.session = null;
            this.session = learn.connect(this.station, this.tunnelDiscovery.isSelected());
        }
        return this.session;
    }

    void loadNodes(LearnNode[] nodes) {
        Array acc = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BNiagaraPointManager.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        for (int i = 0; i < nodes.length; ++i) {
            BFormat format;
            BNameMap map;
            LearnNode node = nodes[i];
            if (node.value != null) continue;
            String handle = node.get(this.dcolHandle).toString();
            BComponent c = (BComponent)BOrd.make((String)("station:|h:" + handle)).get((BObject)node.session);
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                node.displayName = format;
            }
            node.value = c;
            node.name = c.getName();
            node.path = c.getSlotPath().getBody();
            acc.add((Object)c);
        }
        BComponent[] toLease = (BComponent[])acc.trim();
        BComponent.lease((BComponent[])toLease, (int)0);
    }

    public void doLoadValue(BObject value, Context cx) {
        this.folder = (BIPointFolder)value;
        try {
            this.points = (BNiagaraPointDeviceExt)this.folder.getDeviceExt();
            this.station = (BNiagaraStation)this.points.getDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doLoadValue(value, cx);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DisplayNameColumn
    extends MgrColumn {
        DisplayNameColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BFormat format;
            BNameMap map;
            if (row instanceof LearnNode) {
                LearnNode node = (LearnNode)row;
                return node.displayName;
            }
            BComplex c = (BComplex)row;
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public BValue load(MgrEditRow row) {
            BFormat format;
            BNameMap map;
            LearnNode node = (LearnNode)row.getDiscovery();
            if (node != null) {
                return node.displayName;
            }
            BComponent c = row.getTarget();
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (value == null) {
                return;
            }
            LearnNode node = (LearnNode)row.getDiscovery();
            if (node != null) {
                node.displayName = (BFormat)value;
            } else {
                BComponent c = row.getTarget();
                BComponent parent = (BComponent)c.getParent();
                if (parent != null) {
                    BNameMap map = (BNameMap)parent.get("displayNames");
                    if (map == null) {
                        if (!value.equals((Object)BFormat.DEFAULT)) {
                            map = BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)c.getName(), (BFormat)((BFormat)value));
                            parent.add("displayNames", (BValue)map);
                        }
                    } else {
                        map = !value.equals((Object)BFormat.DEFAULT) ? BNameMap.make((BNameMap)map, (String)c.getName(), (BFormat)((BFormat)value)) : BNameMap.remove((BNameMap)map, (String)c.getName());
                        parent.set("displayNames", (BValue)map);
                    }
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BFormat displayName = (BFormat)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)displayName);
            }
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            editor.loadValue((BObject)displayName, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BFormat displayName = BFormat.make((String)editor.saveValue().toString());
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)displayName);
                ((LearnNode)rows[i].getDiscovery()).displayName = displayName;
            }
        }
    }

    static class DisplayNamesColumn
    extends MgrColumn {
        DisplayNamesColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BValue val;
            if (row instanceof BComplex && (val = ((BComplex)row).get("displayNames")) instanceof BNameMap) {
                return val;
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            BValue result = row.getTarget().get("displayNames");
            if (result != null) {
                result = result.newCopy();
            }
            return result;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BValue old;
            if (value == null) {
                return;
            }
            BComponent target = row.getTarget();
            BNameMap names = (BNameMap)value;
            String[] propNames = names.list();
            if (propNames != null) {
                for (int i = 0; i < propNames.length; ++i) {
                    if (target.get(propNames[i]) != null) continue;
                    names = BNameMap.remove((BNameMap)names, (String)propNames[i]);
                }
            }
            if ((old = target.get("displayNames")) == null) {
                target.add("displayNames", (BValue)names, 261, cx);
            } else if (!old.equivalent((Object)names)) {
                target.set(target.getProperty("displayNames"), (BValue)names, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            Context cx = rows[0].getManager().getCurrentContext();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)cx);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BWbFieldEditor fe = (BWbFieldEditor)editor;
            BValue val = (BValue)fe.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    static class PointIdColumn
    extends MgrColumn.PropPath {
        PointIdColumn(Property[] path, int flags) {
            super(path, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return SlotPath.unescape((String)value.toString());
        }
    }

    class TunnelDiscoveryMode
    extends MgrController.MgrToggleCommand {
        BWidget tunnelModeIndicator;
        BNullWidget nullWidget = new BNullWidget();

        TunnelDiscoveryMode(BWidget owner) {
            super(owner, BNiagaraPointManager.this.lex, "tunnelDiscovery");
            BLabel label = new BLabel(this.getIcon(), BNiagaraPointManager.this.lex.getText("tunnelDiscovery.label"), Theme.widget().getBoldText());
            label.setHalign(BHalign.left);
            BBorderPane solidPane = new BBorderPane((BWidget)label, BBorder.solid, BInsets.make((double)3.0, (double)3.0, (double)3.0, (double)3.0));
            solidPane.setFill(BBrush.make((String)"#fefec0"));
            this.tunnelModeIndicator = new BBorderPane((BWidget)solidPane, BBorder.inset, BInsets.DEFAULT);
        }

        public CommandArtifact doInvoke() throws Exception {
            this.updateIndicator();
            return super.doInvoke();
        }

        void updateIndicator() {
            BWidget content = BNiagaraPointManager.this.getContent();
            if (content instanceof BEdgePane) {
                BEdgePane pane = (BEdgePane)content;
                if (this.isSelected()) {
                    pane.setTop(this.tunnelModeIndicator);
                } else {
                    pane.setTop((BWidget)this.nullWidget);
                }
            }
        }
    }

    class Controller
    extends PointController {
        Controller(BNiagaraPointManager mgr) {
            super((BPointManager)mgr);
            this.cancel.setFlags(0);
            BNiagaraPointManager.this.tunnelDiscovery = new TunnelDiscoveryMode((BWidget)mgr);
            if (mgr.isLearnable()) {
                BNiagaraPointManager.this.tunnelDiscovery.setFlags(1);
            }
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] cmds = super.makeCommands();
            int count = 0;
            if (cmds != null) {
                count = cmds.length;
            }
            MgrController.IMgrCommand[] retVal = new MgrController.IMgrCommand[count + 1];
            for (int i = 0; i < count; ++i) {
                retVal[i] = cmds[i];
            }
            retVal[count] = BNiagaraPointManager.this.tunnelDiscovery;
            return retVal;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            Learn learn = (Learn)BNiagaraPointManager.this.getLearn();
            BNiagaraPointManager.this.openFoxSession();
            if (BNiagaraPointManager.this.session == null) {
                return null;
            }
            learn.bqlDiscover(BNiagaraPointManager.this.session, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            LearnNode[] nodes = new LearnNode[discovery.length];
            System.arraycopy(discovery, 0, nodes, 0, discovery.length);
            BNiagaraPointManager.this.loadNodes(nodes);
            return super.doAdd(discovery, cx);
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            if (command == this.discover) {
                return new MgrController.IMgrCommand[]{BNiagaraPointManager.this.tunnelDiscovery};
            }
            return super.getDropDownCommands(command);
        }
    }

    class State
    extends PointState {
        BITable lastLearn;
        boolean lastTunnelDiscovery = false;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BNiagaraPointManager manager = (BNiagaraPointManager)m;
            Learn learn = (Learn)manager.getLearn();
            this.lastLearn = learn.lastLearn;
            this.lastTunnelDiscovery = BNiagaraPointManager.this.tunnelDiscovery.isSelected();
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNiagaraPointManager manager = (BNiagaraPointManager)m;
            manager.tunnelDiscovery.setSelected(this.lastTunnelDiscovery);
            manager.tunnelDiscovery.updateIndicator();
            Learn learn = (Learn)manager.getLearn();
            if (this.lastLearn != null) {
                manager.openFoxSession();
                if (manager.session != null) {
                    learn.updateTable(manager.session, this.lastLearn);
                }
            }
        }
    }

    class LearnNode
    extends NiagaraLearn.Node {
        LearnNode parent;
        String name;
        BFormat displayName = BFormat.DEFAULT;
        String path;
        BValue value;
        BFacets facets;

        public LearnNode(BFoxSession session) {
            super(session);
        }

        public LearnNode(LearnNode parent, BComponent component, Property prop, BValue value, BFacets facets) {
            super(parent.session);
            this.parent = parent;
            this.name = prop.getName();
            this.path = parent.path + "/" + this.name;
            this.value = value;
            this.facets = facets;
            String handle = "";
            if (value.isComponent()) {
                handle = "" + value.asComponent().getHandle();
            }
            this.icon = BImage.make((BIcon)value.getIcon());
            this.cells = new BObject[]{BString.make((String)component.getDisplayName((Slot)prop, null)), BString.make((String)handle), value.getType().getTypeSpec()};
        }

        public boolean hasChildren() {
            if (this.value == null) {
                return true;
            }
            return this.value instanceof BComponent;
        }

        public NiagaraLearn.Node[] getChildren() {
            this.loadNode();
            if (!this.value.isComponent()) {
                return new LearnNode[0];
            }
            BComponent component = (BComponent)this.value;
            component.lease();
            Property[] props = component.getPropertiesArray();
            ArrayList<LearnNode> kids = new ArrayList<LearnNode>(props.length);
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                BValue value = component.get(prop);
                if (Flags.isHidden((BComplex)component, (Slot)prop) || value instanceof BLink || value instanceof BWsAnnotation) continue;
                kids.add(new LearnNode(this, component, prop, value, component.getSlotFacets((Slot)prop)));
            }
            return kids.toArray(new LearnNode[kids.size()]);
        }

        BValue loadNode() {
            BNiagaraPointManager.this.loadNodes(new LearnNode[]{this});
            return this.value;
        }

        public String toPointId() {
            if (this.path == null) {
                this.path = this.cells[0].toString();
            }
            return "slot:" + this.path;
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BNiagaraPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.dcols;
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            ArrayList list = new ArrayList();
            String typeSpec = BNiagaraPointManager.this.dcolType.get(dis).toString();
            TypeInfo type = Sys.getRegistry().getType(typeSpec);
            PointModel.addPointTypes((TypeInfo)type, list, (boolean)false);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            LearnNode node = (LearnNode)discovery;
            BValue value = node.loadNode();
            BFacets facets = node.facets;
            if (facets == null) {
                facets = PointModel.mapPointFacets(null, (Object)value);
            }
            row.setDefaultName(node.name);
            row.setCell(BNiagaraPointManager.this.colFacets, (BValue)facets);
            row.setCell(BNiagaraPointManager.this.colDeviceFacets, (BValue)facets);
            row.setCell(BNiagaraPointManager.this.colPointId, (BValue)BString.make((String)node.toPointId()));
        }

        protected NiagaraLearn.Node makeNode(BFoxSession session) {
            return new LearnNode(session);
        }

        public boolean isExisting(Object dis, BComponent comp) {
            LearnNode node = (LearnNode)dis;
            if (comp instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)comp;
                BNiagaraProxyExt ext = (BNiagaraProxyExt)pt.getProxyExt();
                return ext.getPointId().equals(node.toPointId());
            }
            return false;
        }
    }

    class Model
    extends PointModel {
        Model(BNiagaraPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            Model.addBooleanPointTypes(list, (boolean)false);
            Model.addNumericPointTypes(list, (boolean)false);
            Model.addEnumPointTypes(list, (boolean)false);
            Model.addStringPointTypes(list, (boolean)false);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = rows[i].getName();
                values[i] = rows[i].getTarget();
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            BNameMap map = (BNameMap)container.get("displayNames");
            for (int i = 0; i < rows.length; ++i) {
                Object discoveredPoint = rows[i].getDiscovery();
                BFormat displayName = null;
                displayName = discoveredPoint == null ? (BFormat)rows[i].getCell(BNiagaraPointManager.this.colDisplayName) : ((LearnNode)discoveredPoint).displayName;
                if (displayName == null || displayName.equals((Object)BFormat.DEFAULT)) continue;
                if (map == null) {
                    map = BNameMap.NULL;
                    container.add("displayNames", (BValue)map);
                }
                map = BNameMap.make((BNameMap)map, (String)names[i], (BFormat)displayName);
            }
            if (map != null) {
                container.set("displayNames", (BValue)map);
            }
            return null;
        }
    }
}

