/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FoxProviderSession
extends ProviderSession {
    public static final int SESSION_INIT = -1;
    private static final int SESSION_CLOSED = -2;
    private int sessionId;
    BNiagaraNetwork network;
    private BProviderStation local;

    protected BSysDefChannel getChannel() {
        BFoxSession fox = (BFoxSession)this.network.getSession();
        BFoxClientConnection conn = fox.getConnection();
        return (BSysDefChannel)conn.getChannels().get("sysdef", BSysDefChannel.TYPE);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setOpen(int sessionId) {
        this.checkClosed();
        if (this.sessionId != -1) {
            throw new SysDefException("Session id changed from " + this.sessionId + " to " + sessionId);
        }
        this.sessionId = sessionId;
    }

    public void setClosed() {
        this.sessionId = -2;
    }

    public BINiagaraStation getLocalStation() {
        return this.getStation(this.local.getStationName());
    }

    /*
     * WARNING - void declaration
     */
    public BProviderStation doGetStation(String stationName) {
        this.checkClosed();
        try {
            return this.getChannel().getStation(this, stationName);
        }
        catch (SysDefException sde) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    protected void checkClosed() throws SysDefException {
        if (this.sessionId == -2) {
            throw new SysDefException("SysDefSession has been closed.");
        }
    }

    public boolean isOpen() {
        boolean bl = false;
        if (this.sessionId != -2) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void doClose() {
        if (this.sessionId == -1) {
            this.sessionId = -2;
        }
        if (!this.isOpen()) {
            return;
        }
        try {
            this.getChannel().closeSession(this);
        }
        catch (SysDefException sde) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Array getServices(BINiagaraStation station) {
        this.checkClosed();
        try {
            return this.getChannel().getServiceTypes(this, station);
        }
        catch (SysDefException sde) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    public BINiagaraStation[] getSubordinates(BINiagaraStation station) {
        return this.getStations(station, BStationRole.subordinate);
    }

    public BINiagaraStation[] getSupervisors(BINiagaraStation station) {
        return this.getStations(station, BStationRole.supervisor);
    }

    /*
     * WARNING - void declaration
     */
    private final BINiagaraStation[] getStations(BINiagaraStation station, BStationRole role) {
        this.checkClosed();
        try {
            return this.getChannel().getStations(this, station, role);
        }
        catch (SysDefException sde) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    public String[] doGetRoleRefs(BINiagaraStation station, BStationRole role) {
        BINiagaraStation[] stations = null;
        switch (role.getOrdinal()) {
            case 2: {
                stations = this.getSupervisors(station);
                break;
            }
            case 1: {
                stations = this.getSubordinates(station);
                break;
            }
            default: {
                return new String[0];
            }
        }
        String[] names = new String[stations.length];
        int i = 0;
        while (i < stations.length) {
            names[i] = stations[i].getStationName();
            ++i;
        }
        return names;
    }

    public BProviderStation doRead(String stationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void doInsert(BProviderStation station) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected BResolveBits doUpdate(BProviderStation station, BResolveBits toUpdate, boolean commit) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean doDelete(String stationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final /* synthetic */ void this() {
        this.sessionId = -1;
    }

    public FoxProviderSession(BNiagaraNetwork network, BSysDefProvider p, Context cx) {
        super(p, cx);
        this.this();
        this.network = network;
        network.loadSlots();
        this.local = network.getLocalStation();
        this.local.loadSlots();
        this.sessionId = -1;
    }
}

