/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BProviderState;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import com.tridium.nd.util.ReentrantReadWriteLock;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.driver.BDevice;
import javax.baja.driver.BNetworkExt;
import javax.baja.log.Log;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSysDefProvider
extends BNetworkExt {
    public static final Property state = BSysDefProvider.newProperty((int)3, (BValue)BProviderState.stopped, null);
    public static final Property faultCause = BSysDefProvider.newProperty((int)3, (String)"", null);
    public static final Action startup = BSysDefProvider.newAction((int)16, null);
    public static final Action shutdown = BSysDefProvider.newAction((int)16, (BValue)BBoolean.FALSE, null);
    public static final Action purge = BSysDefProvider.newAction((int)16, null);
    public static final Topic providerEvent = BSysDefProvider.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon ICON;
    protected static final Log log;
    private final ReentrantReadWriteLock purgeLock;
    private Object sessionLock;
    private boolean allowSessions;
    private HashSet sessions;
    private Clock.Ticket ticket;
    private Invocation purgeInvoke;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BSysDefProvider;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxServerConnection;

    public BProviderState getState() {
        return (BProviderState)this.get(state);
    }

    public void setState(BProviderState v) {
        this.set(state, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public void startup() {
        this.invoke(startup, null, null);
    }

    public void shutdown(BBoolean immediate) {
        this.invoke(shutdown, (BValue)immediate, null);
    }

    public void purge() {
        this.invoke(purge, null, null);
    }

    public void fireProviderEvent(BProviderEvent event) {
        this.fire(providerEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public boolean isCompatible(Version version) {
        return version.isNull() ^ true;
    }

    private final void cancelTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    public final ProviderSession createSession(String sessionName, Context cx) {
        BasicContext bc = new BasicContext(cx, BFacets.make((String)"sessionName_", (String)sessionName));
        return this.createSession((Context)bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ProviderSession createSession(Context cx) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            this.lease(1);
            if (!this.getState().isRunning()) {
                throw new SysDefException("Provider is not running.");
            }
            return new FoxProviderSession(this.getNiagaraNetwork(), this, cx);
        }
        ProviderSession session = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.allowSessions) {
                throw new SysDefException("Provider is not running.");
            }
            session = this.makeSession(cx);
            this.sessions.add(session);
            return session;
        }
    }

    protected abstract ProviderSession makeSession(Context var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sessionClosed(ProviderSession session) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            return;
        }
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            Object object = this.sessionLock;
            synchronized (object) {
                this.sessions.remove(session);
                if (!this.allowSessions && this.getState().isStopping() && this.sessions.size() == 0) {
                    this.setState(BProviderState.stopped);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doStartup() {
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            if (!this.getState().isStopped()) {
                StringBuffer err = new StringBuffer().append("Cannot startup the provider: ");
                switch (this.getState().getOrdinal()) {
                    case 0: 
                    case 3: {
                        return;
                    }
                    case 1: {
                        err.append("It is in the process of shutting down.");
                        throw new SysDefException(err.toString());
                    }
                    case 4: {
                        err.append("An unrecoverable error has occured.");
                        throw new SysDefException(err.toString());
                    }
                }
                throw new IllegalStateException(this.getState().toString());
            }
            this.setState(BProviderState.starting);
            Object object = this.sessionLock;
            synchronized (object) {
                this.allowSessions = true;
            }
            this.getNiagaraNetwork().getLocalStation().getPersistTask().execute();
            this.setState(BProviderState.running);
            this.purge();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void doShutdown(BBoolean immediate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [6 : 10->379)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPurge() {
        ProviderSession fw = null;
        try {
            block18: {
                try {
                    int i;
                    this.cancelTicket();
                    fw = this.createSession("Purge", null);
                    BProviderStation root = (BProviderStation)fw.getLocalStation();
                    if (root == null) {
                        log.trace("Nothing to purge, the local host is not in the provider yet.");
                        Object var3_4 = null;
                        if (fw != null) {
                            fw.close();
                        }
                        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
                        return;
                    }
                    HashSet unreachable = new HashSet();
                    this.loadStationNames(unreachable);
                    this.purgeLock.writeLock().lock();
                    try {
                        unreachable.remove(root.getStationName());
                        String[] rootSups = fw.getRoleRefs(root, BStationRole.supervisor);
                        i = 0;
                        while (i < rootSups.length) {
                            unreachable.remove(rootSups[i]);
                            ++i;
                        }
                        this.findReachable(root, unreachable, fw);
                        Iterator iter = unreachable.iterator();
                        while (iter.hasNext()) {
                            String toDelete = (String)iter.next();
                            if (log.isTraceOn()) {
                                log.trace("Purging orphan: " + toDelete);
                            }
                            fw.delete(toDelete);
                        }
                        Object var7_14 = null;
                        this.purgeLock.writeLock().unlock();
                        if (unreachable.size() == 0) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        this.purgeLock.writeLock().unlock();
                        throw throwable;
                    }
                    BDevice[] devices = this.getNiagaraNetwork().getDevices();
                    i = 0;
                    while (i < devices.length) {
                        BNiagaraStation station = (BNiagaraStation)devices[i];
                        if (station.getSysDef().getRole().isSupervisor()) {
                            if (log.isTraceOn()) {
                                log.trace("Forcing supervisor " + devices[i].getName() + " to purge.");
                            }
                            station.getSysDef().getSyncTask().setSignalPurge(true);
                        }
                        ++i;
                    }
                }
                catch (Exception x) {
                    if (!log.isTraceOn()) break block18;
                    log.trace("Purge failed: " + x.getMessage());
                }
            }
            Object var3_6 = null;
            if (fw != null) {
                fw.close();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (fw != null) {
                fw.close();
            }
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
            throw throwable;
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
    }

    protected abstract void loadStationNames(HashSet var1);

    private final void findReachable(BINiagaraStation current, HashSet unreachable, ProviderSession fw) {
        if (current == null) {
            return;
        }
        String[] subordinates = fw.getRoleRefs(current, BStationRole.subordinate);
        int i = 0;
        while (i < subordinates.length) {
            unreachable.remove(subordinates[i]);
            this.findReachable(fw.getStation(subordinates[i]), unreachable, fw);
            ++i;
        }
    }

    final void blockPurge() {
        this.purgeLock.readLock().lock();
    }

    final void unblockPurge() {
        this.purgeLock.readLock().unlock();
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.shutdown(BBoolean.TRUE);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == purge || action == startup || action == shutdown) {
            try {
                BNiagaraNetwork nn = (BNiagaraNetwork)this.getNetwork();
                Invocation i = new Invocation((BComponent)this, action, argument, cx);
                try {
                    nn.getWorkers().process(i);
                    return null;
                }
                catch (NotRunningException e) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.post(action, argument, cx);
    }

    public BIcon getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter out) throws Exception {
        BAbsTime now = BAbsTime.now();
        out.startTable(true);
        out.trTitle((Object)"Open Sessions", 3);
        out.w((Object)"<tr>");
        out.thTitle((Object)"Session Name");
        out.thTitle((Object)"Creation Time");
        out.thTitle((Object)"Time Open");
        out.w((Object)"</tr>");
        Object object = this.sessionLock;
        synchronized (object) {
            ProviderSession[] as = this.sessions.toArray(new ProviderSession[this.sessions.size()]);
            int i = 0;
            while (i < as.length) {
                ProviderSession session = as[i];
                BAbsTime creation = session.getCreation();
                out.w((Object)"<tr>");
                out.td((Object)XWriter.safeToString((String)session.getSessionName(), (boolean)false));
                out.td((Object)creation);
                out.td((Object)creation.delta(now));
                out.w((Object)"</tr>");
                ++i;
            }
        }
        out.endTable();
        super.spy(out);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.purgeLock = new ReentrantReadWriteLock();
        this.sessionLock = new Object();
        this.allowSessions = false;
        this.sessions = new HashSet();
        this.ticket = null;
        this.purgeInvoke = new Invocation((BComponent)this, purge, null, null);
    }

    public BSysDefProvider() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BSysDefProvider;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BSysDefProvider = BSysDefProvider.class("[Lcom.tridium.nd.sysdef.BSysDefProvider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ICON = BIcon.std((String)"cloud.png");
        log = Log.getLog((String)"niagara.sysdef");
    }
}

