/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSyncTask;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSysDefChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static final String CHANNEL = "sysdef";
    private static final Log slog;
    private static final String SERVICES = "services";
    private static final String CLOSE_SESSION = "close";
    private static final String CHANGE_ROLE = "role";
    private static final String GET1 = "gs";
    private static final String SYNC_TO_SUB = "toSub";
    private static final String PERSIST = "persist";
    private static final String SYNC_TO_SUP = "toSup";
    private static final String GET_ROLES = "getRoles";
    private IntHashMap sessionReg;
    private int nextId;
    public StringBuffer lastSync;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BSysDefChannel;
    static /* synthetic */ Class class$javax$baja$util$BTypeSpec;
    static /* synthetic */ Class class$javax$baja$nd$BINiagaraStation;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BProviderStation;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        String command = req.command;
        if (command.equals(SERVICES)) {
            return this.getServiceTypes(req);
        }
        if (command.equals(CHANGE_ROLE)) {
            return this.changeRole(req);
        }
        if (command.equals(CLOSE_SESSION)) {
            return this.closeSession(req);
        }
        if (command.equals(GET1)) {
            return this.getStation(req);
        }
        if (command.equals(SYNC_TO_SUB)) {
            return this.syncToSubordinate(req);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        String command = circuit.command;
        if (command.equals(GET_ROLES)) {
            this.getStations(circuit);
            return;
        }
        if (command.equals(SYNC_TO_SUP)) {
            this.syncToSupervisor(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    protected void checkStatus(FoxMessage resp) throws Exception {
        String rc = resp.getString("status");
        if (!rc.equals("ok")) {
            if (rc.equals("error")) {
                throw new SysDefException(resp.getString("msg"));
            }
            slog.warning(resp.getString("msg"));
        }
    }

    protected BProviderStation decodeStation(FoxMessage msg) throws Exception {
        return (BProviderStation)DecoderFactory.decode((FoxMessage)msg, (String)"station", null);
    }

    protected void handleServerException(ProviderSession session, FoxMessage resp, Throwable t) {
        if (session != null && resp.getBoolean("wasCreated", false)) {
            int sessionId;
            try {
                sessionId = resp.getInt("sessionId");
            }
            catch (Exception x) {
                throw new IllegalStateException("should have had sessionId.");
            }
            if (this.isTraceOn()) {
                this.trace("Closing piggy-backed session: " + sessionId);
            }
            this.closeSession(session, sessionId);
        }
        resp.add("status", "error");
        resp.add("msg", "[" + Sys.getStation().getStationName() + "]: " + t.getMessage());
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    protected BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getConnection().getParentStation();
    }

    protected BNiagaraSysDefDeviceExt getSysDefExt() {
        BNiagaraStation s = this.getNiagaraStation();
        return s == null ? null : s.getSysDef();
    }

    private final String sn(String sessionName) {
        return this.getNiagaraStation().getStationName() + ':' + sessionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sessionClosed(Throwable cause) throws Exception {
        sessions = null;
        var3_3 = this.sessionReg;
        synchronized (var3_3) {
            sessions = (SysDefSession[])this.sessionReg.toArray((Object[])new SysDefSession[this.sessionReg.size()]);
            this.sessionReg.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            i = 0;
            if (true) ** GOTO lbl21
        }
        do {
            if (i == 0) {
                BSysDefChannel.slog.warning("SysDefChannel for session " + this.getServerConnection().getName() + " is closing with " + sessions.length + " open SysDef sessions. Closing them.", cause);
            }
            try {
                sessions[i].close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            ++i;
lbl21:
            // 2 sources

        } while (i < sessions.length);
        super.sessionClosed(cause);
    }

    private final void setSession(FoxProviderSession session, FoxMessage req) {
        req.add("sessionId", session.getSessionId());
        req.add("sessionName", session.getSessionName());
    }

    private final void setSession(FoxProviderSession session, FoxCircuit circuit) throws Exception {
        FoxMessage req = new FoxMessage("session");
        this.setSession(session, req);
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        this.assignSessionId(session, resp);
    }

    private final ProviderSession getSession(FoxMessage req, FoxMessage resp, boolean create) throws Exception {
        int sessionId = req.getInt("sessionId");
        String sessionName = req.getString("sessionName");
        if (sessionId == -1) {
            if (create) {
                BNiagaraNetwork network = this.getNiagaraNetwork();
                ProviderSession session = network.getSysDefProvider().createSession("fox_" + sessionName, this.getServerConnection().getSessionContext());
                sessionId = this.registerSession(session);
                resp.add("sessionId", sessionId);
                resp.add("wasCreated", true);
                return session;
            }
            throw new SysDefException("Invalid fox session id. (" + sessionId + ')');
        }
        ProviderSession session = this.getSession(sessionId);
        return session;
    }

    private final ProviderSession getSession(FoxCircuit circuit, boolean create) throws Exception {
        FoxMessage req = circuit.readMessage();
        FoxMessage resp = new FoxMessage();
        ProviderSession session = null;
        try {
            session = this.getSession(req, resp, create);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        catch (Exception x) {
            this.handleServerException(session, resp, x);
            throw x;
        }
        return session;
    }

    private final void assignSessionId(FoxProviderSession session, FoxMessage resp) throws Exception {
        int INIT = -1;
        int sessionId = resp.getInt("sessionId", -1);
        if (sessionId == -1) {
            if (session.getSessionId() == -1) {
                throw new SysDefException("Missing session id.");
            }
        } else {
            session.setOpen(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int registerSession(ProviderSession session) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            int id = this.nextId;
            this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            while (true) {
                if (this.sessionReg.get(id) == null) {
                    this.sessionReg.put(id, (Object)session);
                    return id;
                }
                id = this.nextId;
                this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unregisterSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            this.sessionReg.remove(sessionId);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ProviderSession getSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            return (ProviderSession)this.sessionReg.get(sessionId);
        }
    }

    public void closeSession(FoxProviderSession session) throws Exception {
        FoxRequest req = this.makeRequest(CLOSE_SESSION);
        this.setSession(session, (FoxMessage)req);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        session.setClosed();
    }

    private final FoxResponse closeSession(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try {
            int sessionId = req.getInt("sessionId");
            ProviderSession session = this.getSession((FoxMessage)req, (FoxMessage)resp, false);
            if (session != null) {
                this.closeSession(session, sessionId);
                resp.add("status", "ok");
            } else {
                resp.add("status", "warn");
                resp.add("msg", "Session " + sessionId + " was already closed on remote station " + Sys.getStation().getStationName());
            }
        }
        catch (SysDefException sde) {
            this.handleServerException(null, (FoxMessage)resp, (Throwable)((Object)sde));
        }
        return resp;
    }

    private final void closeSession(ProviderSession session, int sessionId) {
        session.close();
        this.unregisterSession(sessionId);
    }

    public BProviderStation getStation(FoxProviderSession session, String stationName) throws Exception {
        FoxRequest req = this.makeRequest(GET1);
        this.setSession(session, (FoxMessage)req);
        req.add("stationName", stationName);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.assignSessionId(session, (FoxMessage)resp);
        BProviderStation pStation = this.decodeStation((FoxMessage)resp);
        pStation.network = session.network;
        return pStation;
    }

    private final FoxResponse getStation(FoxRequest req) {
        FoxResponse resp = new FoxResponse(req);
        ProviderSession session = null;
        try {
            session = this.getSession((FoxMessage)req, (FoxMessage)resp, true);
            String stationName = req.getString("stationName");
            BProviderStation station = (BProviderStation)session.getStation(stationName);
            BogCodec.add((FoxMessage)resp, (String)"station", (BValue)station, null);
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(session, (FoxMessage)resp, x);
        }
        return resp;
    }

    public Array getServiceTypes(FoxProviderSession session, BINiagaraStation station) throws Exception {
        FoxRequest req = this.makeRequest(SERVICES);
        this.setSession(session, (FoxMessage)req);
        req.add("stationName", station.getStationName());
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.assignSessionId(session, (FoxMessage)resp);
        String[] specs = resp.listStrings("spec");
        Class clazz = class$javax$baja$util$BTypeSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BTypeSpec = BSysDefChannel.class("[Ljavax.baja.util.BTypeSpec;", false);
        }
        Array result = new Array(clazz);
        int i = 0;
        while (i < specs.length) {
            result.add((Object)BTypeSpec.make((String)specs[i]));
            ++i;
        }
        return result;
    }

    private final FoxResponse getServiceTypes(FoxRequest req) {
        FoxResponse resp = new FoxResponse(req);
        ProviderSession session = null;
        try {
            session = this.getSession((FoxMessage)req, (FoxMessage)resp, true);
            String stationName = req.getString("stationName");
            BProviderStation station = new BProviderStation(stationName);
            Array services = session.getServices(station);
            int i = 0;
            while (i < services.size()) {
                resp.add("spec", services.get(i).toString());
                ++i;
            }
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(session, (FoxMessage)resp, x);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraStation[] getStations(FoxProviderSession session, BINiagaraStation station, BStationRole role) throws Exception {
        BINiagaraStation[] bINiagaraStationArray;
        FoxCircuit circuit = this.openCircuit(GET_ROLES);
        try {
            this.setSession(session, circuit);
            FoxMessage req = new FoxMessage("req");
            req.add("stationName", station.getStationName());
            req.add(CHANGE_ROLE, role.getOrdinal());
            circuit.writeMessage(req);
            circuit.flush();
            Class clazz = class$javax$baja$nd$BINiagaraStation;
            if (clazz == null) {
                clazz = class$javax$baja$nd$BINiagaraStation = BSysDefChannel.class("[Ljavax.baja.nd.BINiagaraStation;", false);
            }
            Array stations = new Array(clazz);
            FoxMessage current = circuit.readMessage();
            this.checkStatus(current);
            while (!current.getBoolean("EOF", false)) {
                BProviderStation pStation = this.decodeStation(current);
                stations.add((Object)pStation);
                pStation.network = session.network;
                current = circuit.readMessage();
            }
            if (stations.size() != current.getInt("size")) {
                throw new IllegalStateException("Actual size: " + stations.size() + " <> Expected size: " + current.getInt("size"));
            }
            bINiagaraStationArray = (BINiagaraStation[])stations.trim();
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            circuit.close();
            throw throwable;
        }
        circuit.close();
        return bINiagaraStationArray;
    }

    private final void getStations(FoxCircuit circuit) {
        FoxMessage msg = null;
        FoxMessage resp = new FoxMessage();
        ProviderSession session = null;
        try {
            session = this.getSession(circuit, true);
            msg = circuit.readMessage();
            BProviderStation station = new BProviderStation(msg.getString("stationName"));
            int role = msg.getInt(CHANGE_ROLE);
            BINiagaraStation[] stations = null;
            switch (role) {
                case 1: {
                    stations = session.getSubordinates(station);
                    break;
                }
                case 2: {
                    stations = session.getSupervisors(station);
                    break;
                }
                default: {
                    throw new IllegalStateException("PEER role not supported.");
                }
            }
            int i = 0;
            while (i < stations.length) {
                resp = new FoxMessage();
                resp.add("status", "ok");
                BogCodec.add((FoxMessage)resp, (String)"station", (BValue)((BProviderStation)stations[i]), null);
                circuit.writeMessage(resp);
                ++i;
            }
            resp = new FoxMessage();
            resp.add("status", "ok");
            resp.add("size", stations.length);
            resp.add("EOF", true);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        catch (IOException iox) {
        }
        catch (Exception x) {
            this.handleServerException(null, resp, x);
            try {
                circuit.writeMessage(resp);
                circuit.flush();
            }
            catch (Exception ix) {
                ix.printStackTrace();
            }
        }
    }

    private final FoxRequest makePersistRequest(BProviderStation station, boolean commit) throws Exception {
        FoxRequest req = this.makeRequest(PERSIST);
        req.add(CHANGE_ROLE, this.getSysDefExt().getRole().getOppositeRole().getOrdinal());
        req.add("commit", commit);
        BogCodec.add((FoxMessage)req, (String)"station", (BValue)station, null);
        return req;
    }

    /*
     * Exception decompiling
     */
    private final FoxResponse persist(FoxMessage req, ProviderSession session) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 208->211)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final BResolveBits persist(BProviderStation station, BStationRole role, boolean commit, ProviderSession session) throws Exception {
        BNiagaraStation ns = this.getNiagaraStation();
        BNiagaraNetwork net = this.getNiagaraNetwork();
        BResolveBits outOfDate = null;
        if (ns != null && ns.getStationName().equals(station.getStationName())) {
            this.verifyRole(role);
            net.getLocalStation().addRef(station.getStationName(), this.getSysDefExt().getRole());
            outOfDate = session.persist(station, commit);
            if (commit && this.getSysDefExt().getRole().isSubordinate() && !outOfDate.equals((Object)BResolveBits.NONE)) {
                net.getLocalStation().networkChanged();
            }
        } else {
            outOfDate = session.persist(station, commit);
        }
        return outOfDate;
    }

    private final void verifyRole(BStationRole remoteExpectedRole) throws SysDefException {
        BStationRole remoteCurrentRole = this.getSysDefExt().getRole();
        if (!remoteExpectedRole.equals((Object)remoteCurrentRole)) {
            throw new SysDefException("Expected role for station " + this.getNiagaraStation().getStationName() + " to be " + (Object)((Object)remoteExpectedRole) + ", but current role is: " + (Object)((Object)remoteCurrentRole));
        }
    }

    public void changeRole(BStationRole role) throws Exception {
        FoxRequest req = this.makeRequest(CHANGE_ROLE);
        req.add(CHANGE_ROLE, role.getOppositeRole().getOrdinal());
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.commitRole(role, true);
    }

    private final FoxResponse changeRole(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try {
            BStationRole toRole = BStationRole.make(req.getInt(CHANGE_ROLE));
            BNiagaraSysDefDeviceExt ext = this.getSysDefExt();
            BStationRole prevRole = ext.getRole();
            if (!toRole.equals((Object)prevRole) || !toRole.equals((Object)BStationRole.peer)) {
                this.checkRoleChange();
            }
            this.commitRole(toRole, false);
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(null, (FoxMessage)resp, x);
        }
        return resp;
    }

    private final void checkRoleChange() throws SysDefException {
        if (!this.getSysDefExt().isOperational()) {
            throw new SysDefException("SysDef extension not in a valid state to change roles: " + this.getSysDefExt().getStatus());
        }
        if (!this.getSysDefExt().getRoleManager().isRoleSynced()) {
            throw new SysDefException("Simultaneous role change detected; cannot change role.");
        }
    }

    private final void commitRole(BStationRole role, boolean isClient) {
        BNiagaraSysDefDeviceExt ext = this.getSysDefExt();
        BStationRole prevRole = ext.getRole();
        this.getNiagaraNetwork().getLocalStation().removeRef(this.getNiagaraStation().getStationName(), prevRole);
        ext.getRoleManager().setActualRole(role);
        ext.getRoleManager().setDesiredRole(role);
        if (isClient) {
            ext.getSyncTask().setRequestReciprocatedSync(true);
        }
    }

    public void syncToSubordinate(BSyncTask syncTask) throws Exception {
        BProviderStation me = new BProviderStation();
        me.copyFrom((BComplex)this.getNiagaraNetwork().getLocalStation());
        me.setSubordinates(BNameList.make((String)this.getNiagaraStation().getName()));
        me.setSupervisors(BNameList.DEFAULT);
        FoxRequest req = this.makeRequest(SYNC_TO_SUB);
        req.add("reciprocateSync", syncTask.getRequestReciprocatedSync());
        req.add("persistReq", (FoxMessage)this.makePersistRequest(me, true));
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
    }

    /*
     * Exception decompiling
     */
    private final FoxResponse syncToSubordinate(FoxRequest req) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 121->124)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncToSupervisor(BSyncTask syncTask) throws Exception {
        this.lastSync = new StringBuffer();
        BNiagaraNetwork net = this.getNiagaraNetwork();
        ProviderSession session = null;
        FoxCircuit sync = this.openCircuit(SYNC_TO_SUP);
        try {
            try {
                FoxMessage recip = new FoxMessage();
                recip.add("reciprocateSync", syncTask.getRequestReciprocatedSync());
                recip.add("purge", syncTask.getSignalPurge());
                sync.writeMessage(recip);
                session = net.getSysDefProvider().createSession(this.sn("syncToSupervisor_client"), null);
                this.syncToSupervisor(session.doGetStation(net.getLocalStation().getStationName()), sync, session, this.lastSync);
                FoxMessage EOF = new FoxMessage();
                EOF.add("EOF", true);
                sync.writeMessage(EOF);
                sync.flush();
                FoxMessage msg = sync.readMessage();
                this.checkStatus(msg);
            }
            catch (Exception x) {
                this.lastSync.append("ERROR");
                throw x;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (slog.isTraceOn()) {
                slog.trace("Sync'd Subtree to " + this.getNiagaraStation().getStationName() + ":\n" + this.lastSync.toString());
            }
            sync.close();
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        if (slog.isTraceOn()) {
            slog.trace("Sync'd Subtree to " + this.getNiagaraStation().getStationName() + ":\n" + this.lastSync.toString());
        }
        sync.close();
        if (session == null) return;
        session.close();
    }

    private final void syncToSupervisor(BProviderStation current, FoxCircuit sync, ProviderSession session, StringBuffer lastSync) throws Exception {
        if (current == null) {
            return;
        }
        lastSync.append('(').append(current.getStationName());
        if (!current.getResolved().equals((Object)BResolveBits.ALL)) {
            current = session.read(current.getStationName());
        }
        FoxMessage resp = null;
        FoxRequest msg = this.makePersistRequest(current, false);
        sync.writeMessage((FoxMessage)msg);
        sync.flush();
        resp = sync.readMessage();
        this.checkStatus(resp);
        if (resp.getBoolean("networkStale")) {
            lastSync.append("+ ");
            String[] subs = current.getStationRefs(BStationRole.subordinate);
            int i = 0;
            while (i < subs.length) {
                this.syncToSupervisor(session.read(subs[i]), sync, session, lastSync);
                ++i;
            }
        } else if (resp.getBoolean("stationStale")) {
            lastSync.append("[s]");
        }
        lastSync.append(')');
    }

    /*
     * Exception decompiling
     */
    private final void syncToSupervisor(FoxCircuit circuit) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [3 : 546->552)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sessionReg = new IntHashMap();
        this.nextId = 0;
    }

    public BSysDefChannel() {
        super(CHANNEL);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BSysDefChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BSysDefChannel = BSysDefChannel.class("[Lcom.tridium.nd.sysdef.BSysDefChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        slog = Log.getLog((String)"niagara.sysdef");
    }
}

