/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.sysdef.BBooleanPropertyState;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefVersion;
import com.tridium.nd.sysdef.ProviderSession;
import java.util.ListIterator;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BProviderStation
extends BComponent
implements BINiagaraStation {
    public static final Property stationName = BProviderStation.newProperty((int)1, (String)"", null);
    public static final Property alias = BProviderStation.newProperty((int)1, (String)"", null);
    public static final Property address = BProviderStation.newProperty((int)1, (String)"127.0.0.1", null);
    public static final Property foxPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property foxsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property httpPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property httpsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property niagaraDaemonPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property niagaraDaemonSslPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property foxTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property httpTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property onlyTunnelKnownStations = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property proxyAuthenticationWhenTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property services = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property subordinates = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property supervisors = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property stationVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    public static final Property networkVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    public static final Type TYPE;
    protected static final String BITS = "bits";
    private static final BIcon icon;
    private Object refLock;
    BNiagaraNetwork network;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BProviderStation;
    static /* synthetic */ Class class$javax$baja$util$BTypeSpec;

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getAlias() {
        return this.getString(alias);
    }

    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    public void setFoxPort(int v) {
        this.setInt(foxPort, v, null);
    }

    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    public void setFoxsPort(int v) {
        this.setInt(foxsPort, v, null);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int v) {
        this.setInt(httpPort, v, null);
    }

    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    public void setHttpsPort(int v) {
        this.setInt(httpsPort, v, null);
    }

    public int getNiagaraDaemonPort() {
        return this.getInt(niagaraDaemonPort);
    }

    public void setNiagaraDaemonPort(int v) {
        this.setInt(niagaraDaemonPort, v, null);
    }

    public int getNiagaraDaemonSslPort() {
        return this.getInt(niagaraDaemonSslPort);
    }

    public void setNiagaraDaemonSslPort(int v) {
        this.setInt(niagaraDaemonSslPort, v, null);
    }

    public BBooleanPropertyState getFoxTunneling() {
        return (BBooleanPropertyState)this.get(foxTunneling);
    }

    public void setFoxTunneling(BBooleanPropertyState v) {
        this.set(foxTunneling, (BValue)v, null);
    }

    public BBooleanPropertyState getHttpTunneling() {
        return (BBooleanPropertyState)this.get(httpTunneling);
    }

    public void setHttpTunneling(BBooleanPropertyState v) {
        this.set(httpTunneling, (BValue)v, null);
    }

    public BBooleanPropertyState getOnlyTunnelKnownStations() {
        return (BBooleanPropertyState)this.get(onlyTunnelKnownStations);
    }

    public void setOnlyTunnelKnownStations(BBooleanPropertyState v) {
        this.set(onlyTunnelKnownStations, (BValue)v, null);
    }

    public BBooleanPropertyState getProxyAuthenticationWhenTunneling() {
        return (BBooleanPropertyState)this.get(proxyAuthenticationWhenTunneling);
    }

    public void setProxyAuthenticationWhenTunneling(BBooleanPropertyState v) {
        this.set(proxyAuthenticationWhenTunneling, (BValue)v, null);
    }

    public BNameList getServices() {
        return (BNameList)this.get(services);
    }

    public void setServices(BNameList v) {
        this.set(services, (BValue)v, null);
    }

    public BNameList getSubordinates() {
        return (BNameList)this.get(subordinates);
    }

    public void setSubordinates(BNameList v) {
        this.set(subordinates, (BValue)v, null);
    }

    public BNameList getSupervisors() {
        return (BNameList)this.get(supervisors);
    }

    public void setSupervisors(BNameList v) {
        this.set(supervisors, (BValue)v, null);
    }

    public BSysDefVersion getStationVersion() {
        return (BSysDefVersion)this.get(stationVersion);
    }

    public void setStationVersion(BSysDefVersion v) {
        this.set(stationVersion, (BValue)v, null);
    }

    public BSysDefVersion getNetworkVersion() {
        return (BSysDefVersion)this.get(networkVersion);
    }

    public void setNetworkVersion(BSysDefVersion v) {
        this.set(networkVersion, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIpHost getIpHost() {
        return new BIpHost(this.getAddress());
    }

    public final synchronized void updateStationVersion() {
        this.setStationVersion(this.getStationVersion().increment());
    }

    public final synchronized void updateNetworkVersion() {
        this.setNetworkVersion(this.getNetworkVersion().increment());
    }

    public final synchronized void resetVersions() {
        this.setStationVersion(BSysDefVersion.make());
        this.setNetworkVersion(BSysDefVersion.make());
    }

    public final void setResolved(BResolveBits resolved) {
        if (this.get(BITS) == null) {
            this.add(BITS, (BValue)resolved, 1);
        } else {
            this.set(BITS, (BValue)resolved);
        }
    }

    public final void removeResolved() {
        if (this.get(BITS) != null) {
            this.remove(BITS);
        }
    }

    public final BResolveBits getResolved() {
        BResolveBits bits = null;
        bits = (BResolveBits)this.get(BITS);
        return bits == null ? BResolveBits.NONE : bits;
    }

    public final boolean hasService(BTypeSpec service) {
        try {
            return this.getServices().contains(SlotPath.escape((String)service.encodeToString()));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final Array getServiceTypes() {
        Class clazz = class$javax$baja$util$BTypeSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BTypeSpec = BProviderStation.class("[Ljavax.baja.util.BTypeSpec;", false);
        }
        Array result = new Array(clazz);
        String[] escapedTypes = this.getServices().getNames();
        if (escapedTypes != null) {
            int i = 0;
            while (i < escapedTypes.length) {
                try {
                    result.add((Object)BTypeSpec.DEFAULT.decodeFromString(SlotPath.unescape((String)escapedTypes[i])));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return result;
    }

    public final void setServiceTypes(Array types) {
        Object[] typeSpecs = types.trim();
        int n = 0;
        if (typeSpecs != null) {
            n = typeSpecs.length;
        }
        int len = n;
        String[] escaped = new String[len];
        int i = 0;
        while (i < len) {
            try {
                escaped[i] = SlotPath.escape((String)((BTypeSpec)typeSpecs[i]).encodeToString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
        BNameList list = BNameList.make((String[])escaped);
        if (!this.getServices().equals((Object)list)) {
            this.setServices(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addRef(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList refs = this.getList(role);
            if (!refs.contains(stationName)) {
                this.setList(BNameList.union((BNameList)refs, (BNameList)BNameList.make((String)stationName)), role);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRef(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList refs = this.getList(role);
            if (refs.contains(stationName)) {
                this.setList(BNameList.difference((BNameList)refs, (BNameList)BNameList.make((String)stationName)), role);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] getStationRefs(BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return new String[0];
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(role).getNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isReferenced(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(role).contains(stationName);
        }
    }

    protected final void setList(BNameList toSet, BStationRole role) {
        switch (role.getOrdinal()) {
            case 1: {
                this.setSubordinates(toSet);
                break;
            }
            case 2: {
                this.setSupervisors(toSet);
                break;
            }
            default: {
                throw new IllegalStateException("Role: " + role.toString() + " not supported.");
            }
        }
    }

    protected final BNameList getList(BStationRole role) {
        switch (role.getOrdinal()) {
            case 1: {
                return this.getSubordinates();
            }
            case 2: {
                return this.getSupervisors();
            }
        }
        throw new IllegalStateException("Role: " + role.toString() + " not supported.");
    }

    ProviderSession getProviderSession() {
        if (this.network != null) {
            return (ProviderSession)this.network.createSysDefSession(null);
        }
        BNiagaraNetwork net = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        return (ProviderSession)net.createSysDefSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFoxSession getFoxSession() {
        ProviderSession ps = null;
        try {
            BFoxSession session;
            ps = this.getProviderSession();
            BFoxSession bFoxSession = session = ps.getFoxSession(this);
            Object var3_4 = null;
            if (ps != null) {
                ps.close();
            }
            return bFoxSession;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_5 = null;
                if (ps == null) break block3;
                ps.close();
            }
            throw throwable;
        }
    }

    public boolean isEngaged(String interest) {
        return this.getFoxSession().isEngaged(interest);
    }

    public void engageNoRetry(String interest) throws Exception {
        this.getFoxSession().engageNoRetry(interest);
    }

    public void engageNoRetry(String interest, long failFastPeriod) throws Exception {
        this.getFoxSession().engageNoRetry(interest, failFastPeriod);
    }

    public void engageRetry(String interest) throws Exception {
        this.getFoxSession().engageRetry(interest);
    }

    public void disengage(String interest) {
        this.getFoxSession().disengage(interest);
    }

    public BValue invokeAction(BOrd componentOrd, String actionName, BValue arg) throws Exception {
        return ((BPointChannel)this.getFoxSession().getConnection().getChannels().get("point", BPointChannel.TYPE)).invoke(componentOrd.encodeToString(), actionName, arg);
    }

    public void spy(SpyWriter out) throws Exception {
        Array services = this.getServiceTypes().sort();
        out.startTable(true);
        out.w((Object)"<tr>");
        out.thTitle((Object)(services.size() + " Services"));
        out.w((Object)"</tr>");
        ListIterator iterator = services.iterator();
        while (iterator.hasNext()) {
            BTypeSpec service = (BTypeSpec)iterator.next();
            out.w((Object)"<tr>").td((Object)service).w((Object)"</tr>");
        }
        out.endTable();
        super.spy(out);
    }

    public String toString(Context cx) {
        StringBuffer buf = new StringBuffer().append(this.getStationName()).append(" [ ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("fox:" + this.getFoxPort())).toString(cx));
        if (this.getFoxsPort() != -1) {
            buf.append(", ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("foxs:" + this.getFoxsPort())).toString(cx));
        }
        buf.append(" ]");
        return buf.toString();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.refLock = new Object();
        this.network = null;
    }

    public BProviderStation() {
        this.this();
    }

    public BProviderStation(String name) {
        this.this();
        this.setStationName(name);
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BProviderStation;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BProviderStation = BProviderStation.class("[Lcom.tridium.nd.sysdef.BProviderStation;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://niagaraDriver/rc/sysDefStation.png");
    }
}

