/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BRoleManager;
import com.tridium.nd.sysdef.BSyncTask;
import com.tridium.nd.sysdef.BSysDefChannel;
import javax.baja.driver.BDeviceExt;
import javax.baja.log.Log;
import javax.baja.nd.BStationRole;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraSysDefDeviceExt
extends BDeviceExt
implements BINiagaraDeviceExt {
    public static final Property enabled = BNiagaraSysDefDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BNiagaraSysDefDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraSysDefDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property roleManager = BNiagaraSysDefDeviceExt.newProperty((int)0, (BValue)new BRoleManager(), null);
    public static final Property syncTask = BNiagaraSysDefDeviceExt.newProperty((int)0, (BValue)new BSyncTask(), null);
    public static final Type TYPE;
    private static BIcon icon;
    private static final Log log;
    private BStatus prevStatus;
    private Version remoteSysDefVersion;
    private boolean remoteIsCompatible;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BNiagaraSysDefDeviceExt;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BRoleManager getRoleManager() {
        return (BRoleManager)this.get(roleManager);
    }

    public void setRoleManager(BRoleManager v) {
        this.set(roleManager, (BValue)v, null);
    }

    public BSyncTask getSyncTask() {
        return (BSyncTask)this.get(syncTask);
    }

    public void setSyncTask(BSyncTask v) {
        this.set(syncTask, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationRole getRole() {
        return this.getRoleManager().getActualRole();
    }

    public void setRole(BStationRole role) {
        this.getRoleManager().setDesiredRole(role);
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return ((BNiagaraStation)this.getDevice()).getNiagaraNetwork();
    }

    public boolean isOperational() {
        return this.isOperational(this.getStatus());
    }

    private final boolean isOperational(BStatus status) {
        boolean bl = false;
        if (status.isDisabled() || status.isDown() || status.isFault()) {
            bl = true;
        }
        return bl ^ true;
    }

    public final BFoxClientConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public final BFoxServerConnection getServerConnection() {
        return ((BNiagaraStation)this.getParent()).getServerConnection();
    }

    public final BSysDefChannel getSysDefChannel() {
        return (BSysDefChannel)this.getClientConnection().getChannels().get("sysdef", BSysDefChannel.TYPE);
    }

    public void clientClosed() {
    }

    public void clientOpened() {
        FoxMessage hello = this.getClientConnection().session().getRemoteHello();
        this.remoteSysDefVersion = new Version(hello.getString("sysDefVersion", "0"));
        this.remoteIsCompatible = this.getNiagaraNetwork().getSysDefProvider().isCompatible(this.remoteSysDefVersion);
        this.updateStatus();
    }

    public void serverClosed() {
    }

    public void serverOpened() {
        FoxMessage hello = this.getServerConnection().session().getRemoteHello();
        this.remoteSysDefVersion = new Version(hello.getString("sysDefVersion", "0"));
        this.remoteIsCompatible = this.getNiagaraNetwork().getSysDefProvider().isCompatible(this.remoteSysDefVersion);
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        } else if (property == status) {
            if (this.becameOperational()) {
                if (log.isTraceOn()) {
                    log.trace(this.getDevice().getName() + " SysDef extension became operational.");
                }
                if (this.getRoleManager().isRetryCondition()) {
                    this.getRoleManager().execute();
                } else {
                    this.getSyncTask().execute();
                }
            }
            this.prevStatus = this.getStatus();
        }
    }

    private final boolean becameOperational() {
        boolean bl = false;
        if (!this.isOperational(this.prevStatus) && this.isOperational(this.getStatus())) {
            bl = true;
        }
        return bl;
    }

    public void updateStatus() {
        BStatus devStatus = this.getDevice().getStatus();
        BStatus newStatus = this.getStatus();
        boolean bl = false;
        if (devStatus.isDisabled() || !this.getEnabled()) {
            bl = true;
        }
        newStatus = BStatus.makeDisabled((BStatus)newStatus, (boolean)bl);
        newStatus = BStatus.makeDown((BStatus)newStatus, (boolean)devStatus.isDown());
        newStatus = BStatus.makeFault((BStatus)newStatus, (boolean)(this.remoteIsCompatible ^ true));
        if (this.remoteIsCompatible) {
            this.setFaultCause("");
        } else {
            this.setFaultCause("Fault: " + this.getDevice().getName() + " SysDef version " + this.remoteSysDefVersion + " is not compatible with this station's SysDef version: " + Sys.getBajaModule().getVendorVersion());
        }
        this.setStatus(newStatus);
    }

    public BIcon getIcon() {
        return icon;
    }

    public SysDefInterest makeInterest(String diagnostic) {
        return new SysDefInterest(this.getDevice().getName() + ": " + diagnostic);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.prevStatus = BStatus.ok;
        this.remoteSysDefVersion = Version.NULL;
        this.remoteIsCompatible = true;
    }

    public BNiagaraSysDefDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BNiagaraSysDefDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BNiagaraSysDefDeviceExt = BNiagaraSysDefDeviceExt.class("[Lcom.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"binding.png");
        log = Log.getLog((String)"niagara.sysdef");
    }

    public static final class SysDefInterest
    implements BFoxClientConnection.Interest {
        String s;
        BAbsTime creation;

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            int n = 0;
            if (this.creation != null) {
                n = this.creation.hashCode();
            }
            result = 31 * result + n;
            int n2 = 0;
            if (this.s != null) {
                n2 = this.s.hashCode();
            }
            result = 31 * result + n2;
            return result;
        }

        public final String toString() {
            return this.s + ". Created: " + this.creation;
        }

        public SysDefInterest(String s) {
            this.s = s;
            this.creation = BAbsTime.now();
        }
    }
}

