/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nd.spy.SpyStation;
import com.tridium.nv.BNiagaraVirtualGateway;
import java.io.IOException;
import javax.baja.driver.BDevice;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class SpyStations
extends SpyDir {
    public final BNiagaraNetwork network;

    public Spy find(String name) {
        BNiagaraStation station = (BNiagaraStation)this.network.getStation(name);
        return new SpyStation(station);
    }

    public void write(SpyWriter out) throws IOException {
        out.startTable(true);
        BDevice[] devices = this.network.getDevices();
        out.w((Object)"<tr>");
        out.thTitle((Object)"Station");
        out.thTitle((Object)"Status");
        out.thTitle((Object)"Client");
        out.thTitle((Object)"Server");
        out.thTitle((Object)"Points Client");
        out.thTitle((Object)"Niagara Virtuals Client");
        out.thTitle((Object)"Points/Virtuals Server");
        out.thTitle((Object)"Health");
        out.w((Object)"</tr>");
        int i = 0;
        while (i < devices.length) {
            BNiagaraStation station = (BNiagaraStation)devices[i];
            String base = station.getName();
            out.w((Object)"<tr>");
            out.td((Object)("<a href='" + base + "'>" + station.getName() + "</a>"));
            out.td((Object)station.getStatus());
            out.td((Object)("<a href='" + base + "/client'>" + station.getClientConnection().getState() + "</a>"));
            out.td((Object)("<a href='" + base + "/server'>" + station.getServerConnection().getState() + "</a>"));
            out.td((Object)("<a href='" + base + "/pointsClient'>" + SpyStations.toPointsClient(station.getPoints()) + "</a>"));
            out.td((Object)("<a href='" + base + "/niagaraVirtuals'>" + SpyStations.toNiagaraVirtuals(station.getVirtual()) + "</a>"));
            out.td((Object)("<a href='" + base + "/pointsServer'>" + SpyStations.toPointsServer(station.getPoints()) + "</a>"));
            out.td((Object)station.getHealth());
            out.w((Object)"</tr>");
            ++i;
        }
        out.endTable();
    }

    public static String toPointsClient(BNiagaraPointDeviceExt devicelet) {
        return "ProxyPoints: " + devicelet.getPoints().length;
    }

    public static String toNiagaraVirtuals(BNiagaraVirtualGateway gateway) {
        return "Niagara Virtual Components: " + gateway.getNiagaraVirtualComponents().length;
    }

    public static String toPointsServer(BNiagaraPointDeviceExt devicelet) {
        ServerWorker worker = devicelet.serverWorker;
        String count = worker != null ? "" + worker.getSubscriptionCount() : "inactive";
        return "Subscriptions: " + count;
    }

    public SpyStations(BNiagaraNetwork network) {
        this.network = network;
    }
}

