/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.spy.SpyPoint;
import java.io.IOException;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BColor;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;

public class SpyPointsClient
extends SpyDir {
    public final BNiagaraPointDeviceExt points;

    public Spy find(String name) {
        String[] path = TextUtil.split((String)name, (char)'.');
        BNiagaraPointDeviceExt c = this.points;
        int i = 0;
        while (i < path.length) {
            c = (BComponent)c.get(path[i]);
            ++i;
        }
        BControlPoint pt = (BControlPoint)c;
        BNiagaraProxyExt ext = (BNiagaraProxyExt)pt.getProxyExt();
        return new SpyPoint(ext);
    }

    public void write(SpyWriter out) throws IOException {
        out.startTable(true);
        out.w((Object)"<tr>");
        out.thTitle((Object)"Path");
        out.thTitle((Object)"Value");
        out.thTitle((Object)"PointId");
        out.thTitle((Object)"MsgId");
        out.thTitle((Object)"Tuning");
        out.thTitle((Object)"LastRead");
        out.thTitle((Object)"Subscribed");
        out.thTitle((Object)"Subscription");
        out.thTitle((Object)"SubError");
        out.w((Object)"</tr>");
        String base = this.points.getSlotPath().toString();
        BControlPoint[] points = this.points.getPoints();
        int i = 0;
        while (i < points.length) {
            BControlPoint pt = points[i];
            String path = pt.getSlotPath().toString();
            path = path.substring(base.length() + 1);
            BNiagaraProxyExt ext = (BNiagaraProxyExt)pt.getProxyExt();
            BSimple bg = pt.getStatus().getBackgroundColor(null);
            String lastReadDur = "-";
            long lastReadTicks = ext.getTuning().getLastReadTicks();
            if (lastReadTicks != 0L) {
                lastReadDur = BRelTime.toString((long)(Clock.ticks() - lastReadTicks));
            }
            out.w((Object)"<tr");
            if (bg != null) {
                out.w((Object)" bgcolor='").w((Object)SpyPointsClient.colorToHtmlString(bg)).w('\'');
            }
            out.w((Object)">");
            out.td((Object)("<a href='" + path.replace('/', '.') + "'>" + path + "</a>"));
            out.td((Object)pt.getOutStatusValue().toString((Context)pt.getFacets()));
            out.td((Object)ext.getPointId());
            out.td((Object)Integer.toString(ext.getMessageId()));
            out.td((Object)ext.getTuningPolicyName());
            out.td((Object)lastReadDur);
            out.td((Object)("" + pt.isSubscribed() + '/' + pt.getKnobCount() + '/' + pt.getSubscribers().length));
            out.td((Object)ext.getSubscriptionState());
            out.td((Object)ext.getSubscriptionError());
            out.w((Object)"</tr>\n");
            ++i;
        }
        out.endTable();
    }

    static String colorToHtmlString(Object color) {
        return ((BColor)color).toHtmlString();
    }

    public SpyPointsClient(BNiagaraPointDeviceExt points) {
        this.points = points;
    }
}

