/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualGateway;
import java.io.IOException;
import javax.baja.gx.BColor;
import javax.baja.spy.ObjectSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;

public class SpyNiagaraVirtualsClient
extends SpyDir {
    private final BNiagaraVirtualGateway gateway;

    public Spy find(String name) {
        BNiagaraVirtualComponent[] comps = this.gateway.getNiagaraVirtualComponents();
        int i = 0;
        while (i < comps.length) {
            if (name.equals(comps[i].getName())) {
                return new NiagaraVirtualComponentSpy(comps[i]);
            }
            ++i;
        }
        return null;
    }

    public void write(SpyWriter out) throws IOException {
        out.startTable(true);
        out.trTitle((Object)"Niagara Virtual Components", 6);
        out.w((Object)"<tr>");
        out.th((Object)"Name");
        out.th((Object)"Status");
        out.th((Object)"Virtual Prop Count");
        out.th((Object)"Type Spec");
        out.th((Object)"Slot ORD");
        out.th((Object)"Last Failure Cause");
        out.w((Object)"</tr>");
        BNiagaraVirtualComponent[] comps = this.gateway.getNiagaraVirtualComponents();
        int i = 0;
        while (i < comps.length) {
            StringBuffer rowBuff = new StringBuffer();
            rowBuff.append("<tr bgcolor='");
            rowBuff.append(((BColor)comps[i].getNiagaraVirtualCompInfo().getStatus().getBackgroundColor((BSimple)BColor.lightGreen)).toHtmlString());
            rowBuff.append("'>");
            out.w((Object)rowBuff.toString());
            StringBuffer nameBuff = new StringBuffer();
            nameBuff.append("<a href='");
            nameBuff.append(comps[i].getName());
            nameBuff.append("'>");
            nameBuff.append(comps[i].getDisplayName(null));
            nameBuff.append("</a>");
            out.td((Object)nameBuff.toString());
            out.td((Object)comps[i].getNiagaraVirtualCompInfo().getStatus().toString());
            out.td((Object)new Integer(comps[i].getVirtualPropertySize()));
            out.td((Object)comps[i].getNiagaraVirtualCompInfo().getTypeSpec());
            out.td((Object)comps[i].getNiagaraVirtualCompInfo().getSlotOrd());
            out.td((Object)comps[i].getNiagaraVirtualCompInfo().getLastFailureCause());
            out.w((Object)"</tr>");
            ++i;
        }
        out.endTable();
    }

    public SpyNiagaraVirtualsClient(BNiagaraVirtualGateway gateway) {
        this.gateway = gateway;
    }

    private static class NiagaraVirtualComponentSpy
    extends ObjectSpy {
        public void write(SpyWriter out) throws Exception {
            ((BNiagaraVirtualComponent)this.getObject()).spyInfo(out);
        }

        private NiagaraVirtualComponentSpy(BNiagaraVirtualComponent comp) {
            super((BObject)comp);
        }
    }
}

