/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.point.ServerEntry;
import java.util.HashMap;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.util.ICoalesceable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerWorker
extends Subscriber
implements Runnable,
ICoalesceable {
    public static final int WORKER_SLEEP = 1000;
    public static final ServerEntry[] noEntries = new ServerEntry[0];
    private final FoxLog log;
    private final BNiagaraPointDeviceExt points;
    private final BNiagaraStation station;
    private final BFoxServerConnection connection;
    private final BPointChannel channel;
    private IntHashMap byMessageId;
    private HashMap byComponent;

    public void start() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.unsubAll();
    }

    public void run() {
        try {
            FoxRequest req = this.getSubscriptionChanges();
            if (req != null) {
                this.channel.sendChange(req);
            }
        }
        catch (NotConnectedException e) {
        }
        catch (InterruptedException e) {
        }
        catch (Throwable e) {
            this.log.error("Error sendChange()", e);
        }
    }

    private final synchronized FoxRequest getSubscriptionChanges() {
        long ticksNow = Clock.ticks();
        FoxRequest msg = null;
        IntHashMap.Iterator it = this.byMessageId.iterator();
        while (it.hasNext()) {
            ServerEntry entry = (ServerEntry)it.next();
            if (!entry.sendUpdate(ticksNow)) continue;
            if (msg == null) {
                msg = this.channel.makeRequest("change");
            }
            msg.add((FoxTuple)entry.update(this.log));
            entry.changed = false;
            entry.lastSent = ticksNow;
        }
        return msg;
    }

    public ServerEntry getEntry(int messageId) {
        return (ServerEntry)this.byMessageId.get(messageId);
    }

    public ServerEntry[] getEntries(BComponent component) {
        ServerEntry[] entries = (ServerEntry[])this.byComponent.get(component);
        if (entries == null) {
            return noEntries;
        }
        return entries;
    }

    public ServerEntry[] getAllEntries() {
        return (ServerEntry[])this.byMessageId.toArray((Object[])new ServerEntry[this.byMessageId.size()]);
    }

    public synchronized void sub(ServerEntry entry) {
        this.byMessageId.put(entry.messageId, (Object)entry);
        ServerEntry[] oldEntries = this.getEntries(entry.component);
        ServerEntry[] newEntries = new ServerEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = entry;
        this.byComponent.put(entry.component, newEntries);
        try {
            super.subscribe(entry.component);
        }
        catch (Throwable e) {
            this.byMessageId.remove(entry.messageId);
            this.byComponent.remove(entry.component);
        }
    }

    public synchronized void unsub(int messageId) {
        ServerEntry entry = (ServerEntry)this.byMessageId.get(messageId);
        if (entry == null) {
            return;
        }
        this.byMessageId.remove(entry.messageId);
        BComponent component = entry.component;
        ServerEntry[] oldEntries = this.getEntries(component);
        if (oldEntries.length == 1) {
            if (oldEntries[0] != entry) {
                throw new IllegalStateException();
            }
            this.byComponent.remove(component);
            super.unsubscribe(component);
        } else {
            ServerEntry[] newEntries = new ServerEntry[oldEntries.length - 1];
            int i = 0;
            int n = 0;
            while (i < oldEntries.length) {
                if (oldEntries[i] != entry) {
                    newEntries[n++] = oldEntries[i];
                }
                ++i;
            }
            this.byComponent.put(component, newEntries);
        }
    }

    public synchronized void unsubAll() {
        super.unsubscribeAll();
        this.byMessageId.clear();
        this.byComponent.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void event(BComponentEvent event) {
        if (event.getId() != 0) {
            return;
        }
        ServerEntry[] entries = this.getEntries(event.getSourceComponent());
        int i = 0;
        while (i < entries.length) {
            Slot slot;
            ServerEntry entry = entries[i];
            if (entry.path == null || entry.path.length <= 0 || (slot = event.getSlot()) != null && slot.equals((Object)entry.path[0])) {
                ServerWorker serverWorker = this;
                synchronized (serverWorker) {
                    entry.changed = true;
                }
            }
            ++i;
        }
    }

    public String toString() {
        return this.station.getName() + ":Server Worker";
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    private final /* synthetic */ void this() {
        this.byMessageId = new IntHashMap();
        this.byComponent = new HashMap();
    }

    ServerWorker(BNiagaraPointDeviceExt points) {
        this.this();
        this.points = points;
        this.station = (BNiagaraStation)points.getDevice();
        this.connection = this.station.getServerConnection();
        this.channel = (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
        this.log = this.channel.log;
    }
}

