/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.point.BVirtualAction;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.status.BIStatus;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

public class ServerEntry
implements Comparable {
    public final int messageId;
    public final String type;
    public final String pointId;
    public int minSendTime;
    public int maxSendTime;
    public long subTime;
    public long lastSent;
    public BComponent component;
    public Property[] path;
    public BPermissions permissions;
    public boolean changed;
    public boolean sendActions;

    public FoxMessage init(BPointChannel channel) {
        boolean ok;
        FoxMessage err = new FoxMessage("pt");
        err.add("mid", this.messageId);
        try {
            try {
                OrdTarget t = BOrd.make((String)this.pointId).resolve((BObject)Sys.getStation());
                this.component = t.getComponent();
                this.path = t.getPropertyPathInComponent();
            }
            catch (NullOrdException e) {
                err.add("err", "Null ord: " + this.pointId);
                return err;
            }
            catch (UnresolvedException e) {
                err.add("err", "Unresolved ord: " + this.pointId);
                return err;
            }
            this.permissions = channel.getPermissionsFor(this.component);
            if (!this.permissions.hasOperatorRead()) {
                err.add("err", "Invalid permissions");
                return err;
            }
        }
        catch (Throwable e) {
            channel.log.error("Cannot init: " + this.pointId, e);
            err.add("err", e.toString());
            return err;
        }
        FoxMessage msg = this.update(channel.log);
        this.lastSent = this.subTime = Clock.ticks();
        boolean bl = false;
        if (msg.getString("err", null) == null) {
            bl = true;
        }
        if (ok = bl) {
            channel.getServerWorker().sub(this);
        }
        return msg;
    }

    public boolean sendUpdate(long ticksNow) {
        long nextMax = this.lastSent + (long)this.maxSendTime;
        if (ticksNow > nextMax) {
            return true;
        }
        if (!this.component.isMounted()) {
            return true;
        }
        if (!this.changed) {
            return false;
        }
        long nextMin = this.lastSent + (long)this.minSendTime;
        return nextMin <= ticksNow;
    }

    public FoxMessage update(FoxLog log) {
        FoxMessage msg = new FoxMessage("pt");
        msg.add("mid", this.messageId);
        try {
            if (!this.component.isMounted()) {
                msg.add("err", "Component removed");
                return msg;
            }
            BComponent target = this.component;
            if (this.path != null) {
                int i = 0;
                while (i < this.path.length) {
                    if ((target = ((BComplex)target).get(this.path[i])) == null) {
                        msg.add("err", "Unresolved path");
                        return msg;
                    }
                    ++i;
                }
            }
            ServerEntry.targetToMessage(this.type, (BObject)target, msg);
            if (this.sendActions) {
                msg.add((FoxTuple)ServerEntry.actionsToMessage(this.component, this.permissions, log, false));
                this.sendActions = false;
            }
        }
        catch (Exception e) {
            log.error("update", (Throwable)e);
            msg.add("err", e.toString());
        }
        return msg;
    }

    public static FoxMessage targetToMessage(String type, BObject target, FoxMessage msg) {
        try {
            try {
                switch (type.charAt(0)) {
                    case 'b': {
                        msg.add("v", ((BIBoolean)target).getBoolean());
                        break;
                    }
                    case 'n': {
                        msg.add("v", ((BINumeric)target).getNumeric());
                        break;
                    }
                    case 'e': {
                        msg.add("v", ((BIEnum)target).getEnum().getOrdinal());
                        break;
                    }
                    case 'v': {
                        if (target instanceof BComponent) {
                            System.out.println("Error: target to message is a component: " + target.getType());
                        }
                        msg.add("v", ValueDocEncoder.marshal((BValue)((BValue)target)));
                        break;
                    }
                    default: {
                        String str = target instanceof BIStatusValue ? ((BIStatusValue)target).getStatusValue().getValueValue().toString(null) : target.toString(null);
                        msg.add("v", str);
                        break;
                    }
                }
            }
            catch (Exception e) {
                msg.add("err", "Type mismatch " + type + " != " + target.getType());
                return msg;
            }
            BStatus status = BStatus.ok;
            if (target instanceof BIStatus) {
                status = ((BIStatus)target).getStatus();
            }
            msg.add("s", status.encodeToString());
            return msg;
        }
        catch (Exception e) {
            msg.add("err", "Internal error " + e);
            return msg;
        }
    }

    public static BVirtualAction[] messageToActions(FoxMessage msgList, FoxLog log) {
        try {
            FoxTuple[] tuples = msgList.list("action");
            BVirtualAction[] actions = new BVirtualAction[tuples.length];
            int i = 0;
            while (i < actions.length) {
                FoxTuple frozenTup;
                FoxMessage msg = (FoxMessage)tuples[i];
                String name = msg.getString("name");
                String display = "";
                FoxTuple displayTup = msg.getOptional("display");
                if (displayTup != null) {
                    display = ((FoxString)displayTup).value;
                }
                String paramTypeStr = msg.getString("param", null);
                String returnTypeStr = msg.getString("return", null);
                String flagsStr = msg.getString("flags", null);
                String facetsStr = msg.getString("facets", null);
                Type paramType = null;
                if (paramTypeStr != null) {
                    paramType = Sys.getType((String)paramTypeStr);
                }
                Type returnType = null;
                if (returnTypeStr != null) {
                    returnType = Sys.getType((String)returnTypeStr);
                }
                int flags = 0;
                if (flagsStr != null) {
                    flags = Flags.decodeFromString((String)flagsStr);
                }
                BFacets facets = BFacets.NULL;
                if (facetsStr != null) {
                    facets = BFacets.make((String)facetsStr);
                }
                if ((frozenTup = msg.getOptional("frozen")) != null) {
                    facets = BFacets.make((BFacets)facets, (String)"nVirtualFroz", (BIDataValue)BBoolean.make((boolean)((FoxBoolean)frozenTup).value));
                }
                actions[i] = new BVirtualAction(name, display, returnType, paramType, flags, facets);
                ++i;
            }
            return actions;
        }
        catch (Exception e) {
            log.error("messageToActions", (Throwable)e);
            return new BVirtualAction[0];
        }
    }

    public static FoxMessage actionsToMessage(BComponent component, BPermissions permissions, FoxLog log, boolean virtual) {
        FoxMessage msgList = new FoxMessage("actions");
        try {
            Action[] actions = component.getActionsArray();
            int i = 0;
            while (i < actions.length) {
                Action action = actions[i];
                if (!Flags.isHidden((BComplex)component, (Slot)action) && !(Flags.isOperator((BComplex)component, (Slot)action) ? !permissions.hasOperatorInvoke() : !permissions.hasAdminInvoke())) {
                    Type param = action.getParameterType();
                    Type ret = action.getReturnType();
                    int flags = component.getFlags((Slot)action);
                    BFacets facets = component.getSlotFacets((Slot)action);
                    FoxMessage msg = new FoxMessage("action");
                    msg.add("name", action.getName());
                    msg.add("flags", Flags.encodeToString((int)flags));
                    if (param != null) {
                        msg.add("param", param.toString());
                    }
                    if (ret != null) {
                        msg.add("return", ret.toString());
                    }
                    if (!facets.isNull()) {
                        msg.add("facets", facets.encodeToString());
                    }
                    if (virtual) {
                        BNameMap nameMap;
                        BFormat f;
                        msg.add("frozen", facets.getb("nVirtualFroz", action.isFrozen()));
                        Property nameMapProperty = component.getProperty("displayNames");
                        if (nameMapProperty != null && nameMapProperty.getType().is(BNameMap.TYPE) && (f = (nameMap = (BNameMap)component.get(nameMapProperty)).get(action.getName())) != null) {
                            msg.add("display", f.encodeToString());
                        }
                    } else {
                        msg.add("display", component.getDisplayName((Slot)action, null));
                    }
                    msgList.add((FoxTuple)msg);
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error("actionsToMessage", (Throwable)e);
        }
        return msgList;
    }

    public String toString() {
        return "[" + this.messageId + "] " + this.pointId;
    }

    public String pathToString() {
        if (this.path == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.path.length) {
            if (i > 0) {
                s.append('/');
            }
            s.append(this.path[i].getName());
            ++i;
        }
        return s.toString();
    }

    public String lastSentToString() {
        if (this.lastSent == this.subTime) {
            return "onSub";
        }
        return BRelTime.toString((long)(Clock.ticks() - this.lastSent));
    }

    public String subscribeDurationToString() {
        return BRelTime.toString((long)(Clock.ticks() - this.subTime));
    }

    public int compareTo(Object o) {
        int x = ((ServerEntry)o).messageId;
        if (x == this.messageId) {
            return 0;
        }
        if (this.messageId < x) {
            return -1;
        }
        return 1;
    }

    public ServerEntry(FoxMessage in) throws Exception {
        this.messageId = in.getInt("mid");
        this.pointId = in.getString("pid");
        this.type = in.getString("t").intern();
        this.minSendTime = in.getInt("minSend");
        this.maxSendTime = in.getInt("maxSend");
        this.sendActions = in.getBoolean("fetchActions", false);
    }
}

