/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.EngageTimeoutException;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.INiagaraProxyExt;
import java.util.ArrayList;
import javax.baja.net.NotConnectedException;
import javax.baja.util.ICoalesceable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClientWorker
implements Runnable,
ICoalesceable,
BFoxClientConnection.Interest {
    public static final int WORKER_SLEEP = 1000;
    private final FoxLog log;
    private final BNiagaraPointDeviceExt points;
    private final BNiagaraStation station;
    private final BFoxClientConnection connection;
    private final BPointChannel channel;
    private ArrayList toSub;
    private ArrayList toUnsub;
    private Object stoppedLock;
    private ArrayList stopped;

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        boolean bl = false;
        if (this == o) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        try {
            return this.station.getName() + ":Client Worker";
        }
        catch (Exception exception) {
            return this.points.toString();
        }
    }

    public void start() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
    }

    public void run() {
        try {
            this.workIt();
        }
        catch (InterruptedException e) {
        }
        catch (EngageTimeoutException e) {
            this.log.trace("EngageTimeoutException");
        }
        catch (Throwable e) {
            this.log.error("Error workIt()", e);
        }
    }

    public void workIt() throws Exception {
        this.toSub.clear();
        this.toUnsub.clear();
        boolean needConnection = this.pick();
        if (needConnection) {
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)this, this.connection.getRetryPeriod().getMillis(), true);
            }
            catch (Exception e) {
                try {
                    this.connection.disengage((BFoxClientConnection.Interest)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
        return;
        try {
            this.sendSub();
            this.sendUnsub();
            this.sendStopped();
        }
        catch (NotConnectedException e) {
            this.log.trace("NotConnectedException");
        }
        catch (Exception e) {
            this.log.error("Sending batches", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean pick() {
        Object object = this.points.stateLock;
        synchronized (object) {
            boolean needConnection = false;
            INiagaraProxyExt[] proxyExts = this.points.getProxyExtensions();
            int i = 0;
            while (i < proxyExts.length) {
                if (this.pick(proxyExts[i])) {
                    needConnection = true;
                }
                ++i;
            }
            return needConnection;
        }
    }

    private final boolean pick(INiagaraProxyExt ext) {
        BSubscriptionState subState = ext.getSubscriptionState();
        if (subState == BSubscriptionState.unsubscribed) {
            if (ext.isPointSubscribed() && !ext.isDisabled() && this.connection.isConnected()) {
                ext.pendingSubscribe();
            } else {
                return false;
            }
        }
        if (subState == BSubscriptionState.proxyError) {
            return false;
        }
        if (subState == BSubscriptionState.pendingSubscribe || subState == BSubscriptionState.sendingSubscribe) {
            this.toSub.add(ext);
        }
        if (subState == BSubscriptionState.pendingUnsubscribe || subState == BSubscriptionState.sendingUnsubscribe) {
            this.toUnsub.add(ext);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendSub() throws Exception {
        if (this.toSub.size() == 0) {
            return;
        }
        try {
            Object object = this.points.stateLock;
            synchronized (object) {
                if (!this.connection.isConnected()) {
                    throw new NotConnectedException();
                }
                int i = 0;
                while (i < this.toSub.size()) {
                    INiagaraProxyExt ext = (INiagaraProxyExt)this.toSub.get(i);
                    if (ext.getSubscriptionState() != BSubscriptionState.sendingSubscribe) {
                        ext.sendingSubscribe();
                    }
                    ++i;
                }
            }
        }
        catch (NotConnectedException nce) {
            void e;
            throw e;
        }
        catch (Exception e) {
            Object object = this.points.stateLock;
            synchronized (object) {
                int i = 0;
                while (true) {
                    if (i >= this.toSub.size()) {
                        throw e;
                    }
                    ((INiagaraProxyExt)this.toSub.get(i)).setSubscriptionState(BSubscriptionState.unsubscribed);
                    ++i;
                }
            }
        }
        try {
            this.channel.subscribe(this.toSub);
        }
        catch (Exception e) {
            Object object = this.points.stateLock;
            synchronized (object) {
                int i = 0;
                while (true) {
                    if (i >= this.toSub.size()) {
                        throw e;
                    }
                    ((INiagaraProxyExt)this.toSub.get(i)).setSubscriptionState(BSubscriptionState.unsubscribed);
                    ++i;
                }
            }
        }
        Exception e = null;
        Object object = this.points.stateLock;
        synchronized (object) {
            if (!this.connection.isConnected()) {
                throw new NotConnectedException();
            }
            int i = 0;
            while (i < this.toSub.size()) {
                try {
                    ((INiagaraProxyExt)this.toSub.get(i)).sentSubscribe();
                }
                catch (Exception ex) {
                    e = ex;
                }
                ++i;
            }
        }
        if (e == null) return;
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void sendUnsub() throws Exception {
        if (this.toUnsub.size() == 0) {
            return;
        }
        Object object = this.points.stateLock;
        // MONITORENTER : object
        if (!this.connection.isConnected()) {
            throw new NotConnectedException();
        }
        int i = 0;
        while (i < this.toUnsub.size()) {
            INiagaraProxyExt ext = (INiagaraProxyExt)this.toUnsub.get(i);
            if (ext.getSubscriptionState() != BSubscriptionState.sendingUnsubscribe) {
                ext.sendingUnsubscribe();
            }
            ++i;
        }
        // MONITOREXIT : object
        this.channel.unsubscribe(this.toUnsub);
        Exception e = null;
        object = this.points.stateLock;
        // MONITORENTER : object
        if (!this.connection.isConnected()) {
            throw new NotConnectedException();
        }
        int i2 = 0;
        while (i2 < this.toUnsub.size()) {
            try {
                ((INiagaraProxyExt)this.toUnsub.get(i2)).sentUnsubscribe();
            }
            catch (Exception ex) {
                e = ex;
            }
            ++i2;
        }
        // MONITOREXIT : object
        if (e == null) return;
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendStopped() throws Exception {
        ArrayList copy;
        if (this.stopped.size() == 0) {
            return;
        }
        Object object = this.stoppedLock;
        synchronized (object) {
            copy = this.stopped;
            this.stopped = new ArrayList();
        }
        this.channel.unsubscribe(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopped(INiagaraProxyExt ext) {
        if (ext.getSubscriptionState() == BSubscriptionState.unsubscribed) return;
        Object object = this.stoppedLock;
        synchronized (object) {
            this.stopped.add(new Integer(ext.getMessageId()));
            return;
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    private final /* synthetic */ void this() {
        this.toSub = new ArrayList();
        this.toUnsub = new ArrayList();
        this.stoppedLock = new Object();
        this.stopped = new ArrayList();
    }

    ClientWorker(BNiagaraPointDeviceExt points) {
        this.this();
        this.points = points;
        this.station = (BNiagaraStation)points.getDevice();
        this.connection = this.station.getClientConnection();
        this.channel = (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
        this.log = this.channel.log;
    }
}

