/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BNiagaraTuningPolicy;
import com.tridium.nd.point.ServerEntry;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.IProxyActionParent;
import java.util.ArrayList;
import javax.baja.control.util.BOverride;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPointChannel
extends BFoxChannel {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nd$point$BPointChannel;

    public Type getType() {
        return TYPE;
    }

    public final BNiagaraPointDeviceExt getPoints() {
        try {
            return ((BNiagaraStation)this.getConnection().getParent()).getPoints();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final ServerWorker getServerWorker() {
        return ((BNiagaraStation)this.getConnection().getParent()).getPoints().serverWorker;
    }

    private final BNiagaraNetwork getNiagaraNetwork() {
        return ((BNiagaraStation)this.getConnection().getParent()).getNiagaraNetwork();
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "sub") {
            return this.subscribe(request);
        }
        if (command == "unsub") {
            return this.unsubscribe(request);
        }
        if (command == "change") {
            return this.change(request);
        }
        if (command == "getActionDefault") {
            return this.getActionDefault(request);
        }
        if (command == "invoke") {
            return this.invoke(request);
        }
        if (command == "getActions") {
            return this.getActions(request);
        }
        if (command == "write") {
            return this.write(request);
        }
        throw new InvalidCommandException(command);
    }

    public synchronized void subscribe(ArrayList exts) throws Exception {
        try {
            BNiagaraTuningPolicy defaultPolicy = (BNiagaraTuningPolicy)this.getNiagaraNetwork().getTuningPolicies().getDefaultPolicy();
            FoxRequest req = this.makeRequest("sub");
            int i = 0;
            while (i < exts.size()) {
                INiagaraProxyExt ext = (INiagaraProxyExt)exts.get(i);
                BNiagaraTuningPolicy policy = ext instanceof BNiagaraProxyExt ? ((BNiagaraProxyExt)ext).getNiagaraTuningPolicy() : defaultPolicy;
                FoxMessage msg = new FoxMessage("pt");
                msg.add("mid", ext.getMessageId());
                msg.add("pid", ext.getPointId());
                msg.add("t", ext.getPointType());
                msg.add("minSend", (int)policy.getMinUpdateTime().getMillis());
                msg.add("maxSend", (int)policy.getMaxUpdateTime().getMillis());
                if (ext.isActionFetchRequired()) {
                    msg.add("fetchActions", true);
                }
                req.add((FoxTuple)msg);
                ++i;
            }
            FoxResponse resp = this.sendSync(req);
            if (this.isTraceOn()) {
                this.trace("c:sub");
                resp.dump();
            }
            FoxTuple[] respExts = resp.list("pt");
            int i2 = 0;
            while (i2 < respExts.length) {
                INiagaraProxyExt ext = (INiagaraProxyExt)exts.get(i2);
                FoxMessage respExt = (FoxMessage)respExts[i2];
                try {
                    this.subscribed(ext, respExt);
                }
                catch (Throwable e) {
                    this.log.error("subscribe", e);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            try {
                this.unsubscribe(exts);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private final void subscribed(INiagaraProxyExt ext, FoxMessage resp) throws Exception {
        if (ext.getMessageId() != resp.getInt("mid")) {
            throw new IllegalStateException("messageId mismatch");
        }
        this.refreshValue(ext, resp);
        FoxMessage actions = (FoxMessage)resp.getOptional("actions");
        if (actions != null) {
            ext.updateActions(ServerEntry.messageToActions(actions, this.log));
        }
    }

    private final FoxResponse subscribe(FoxRequest req) throws Exception {
        FoxTuple[] src = req.list("pt");
        if (this.isTraceOn()) {
            this.trace("s:sub");
            req.dump();
        }
        FoxResponse resp = new FoxResponse(req);
        int i = 0;
        while (i < src.length) {
            FoxMessage in = (FoxMessage)src[i];
            ServerEntry entry = new ServerEntry(in);
            resp.add((FoxTuple)entry.init(this));
            ++i;
        }
        return resp;
    }

    public synchronized void unsubscribe(ArrayList extsOrIds) throws Exception {
        FoxRequest req = this.makeRequest("unsub");
        int i = 0;
        while (i < extsOrIds.size()) {
            FoxMessage msg = new FoxMessage("pt");
            Object x = extsOrIds.get(i);
            if (x instanceof INiagaraProxyExt) {
                msg.add("mid", ((INiagaraProxyExt)x).getMessageId());
            } else {
                msg.add("mid", ((Integer)x).intValue());
            }
            req.add((FoxTuple)msg);
            ++i;
        }
        if (this.isTraceOn()) {
            this.trace("c:unsub");
            req.dump();
        }
        this.sendSync(req);
    }

    private final FoxResponse unsubscribe(FoxRequest req) throws Exception {
        FoxTuple[] src = req.list("pt");
        int i = 0;
        while (i < src.length) {
            FoxMessage in = (FoxMessage)src[i];
            this.unsubscribePoint(in);
            ++i;
        }
        return new FoxResponse(req);
    }

    private final void unsubscribePoint(FoxMessage in) {
        try {
            int messageId = in.getInt("mid");
            if (this.isTraceOn()) {
                this.trace("s:unsub " + messageId);
            }
            this.getServerWorker().unsub(messageId);
        }
        catch (Exception e) {
            this.log.error("unsubscribePoint", (Throwable)e);
        }
    }

    public void sendChange(FoxRequest req) throws Exception {
        this.sendAsync(req);
    }

    public FoxResponse change(FoxRequest req) throws Exception {
        FoxTuple[] pts = req.list("pt");
        IntHashMap map = new IntHashMap();
        int i = 0;
        while (i < pts.length) {
            FoxMessage pt = (FoxMessage)pts[i];
            map.put(pt.getInt("mid"), (Object)pt);
            ++i;
        }
        INiagaraProxyExt[] proxyExts = this.getPoints().getProxyExtensions();
        int i2 = 0;
        while (i2 < proxyExts.length) {
            FoxMessage msg;
            if (proxyExts[i2].getSubscriptionState() == BSubscriptionState.subscribed && (msg = (FoxMessage)map.get(proxyExts[i2].getMessageId())) != null) {
                try {
                    this.refreshValue(proxyExts[i2], msg);
                }
                catch (Throwable e) {
                    this.log.error("refreshValue", e);
                }
            }
            ++i2;
        }
        return null;
    }

    void refreshValue(INiagaraProxyExt ext, FoxMessage msg) throws Exception {
        String error = msg.getString("err", null);
        ext.setSubscriptionError(error);
        if (error != null) {
            return;
        }
        Object readValue = null;
        String type = ext.getPointType();
        readValue = type == "b" ? new BStatusBoolean(msg.getBoolean("v")) : (type == "n" ? new BStatusNumeric(msg.getFloat("v")) : (type == "e" ? new BStatusEnum((BEnum)BDynamicEnum.make((int)msg.getInt("v"))) : (type == "v" ? ValueDocDecoder.unmarshal((String)msg.getString("v")) : new BStatusString(msg.getString("v")))));
        if (readValue instanceof BStatusValue) {
            BStatus status = (BStatus)BStatus.DEFAULT.decodeFromString(msg.getString("s", "0"));
            ((BStatusValue)readValue).setStatus(status);
        }
        ext.readValueOk((BValue)readValue);
    }

    public BValue getActionDefault(IProxyActionParent ext, BVirtualAction action) throws Exception {
        String maxDurStr;
        FoxRequest req = this.makeRequest("getActionDefault");
        req.add("pid", ext.getPointId());
        req.add("name", action.getProxyActionName());
        if (this.isTraceOn()) {
            this.trace("c:getActionDefault");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        BValue def = null;
        String defStr = resp.getString("default", null);
        if (defStr != null && (def = ValueDocDecoder.unmarshal((String)defStr)) != null && def instanceof BOverride && (maxDurStr = resp.getString("maxOverrideDuration", null)) != null) {
            BOverride override = (BOverride)def;
            override.setMaxOverrideDuration((BRelTime)BRelTime.DEFAULT.decodeFromString(maxDurStr));
        }
        return def;
    }

    private final FoxResponse getActionDefault(FoxRequest req) throws Exception {
        String pointId = req.getString("pid");
        String name = req.getString("name");
        OrdTarget t = BOrd.make((String)pointId).resolve((BObject)Sys.getStation());
        BComponent target = t.getComponent();
        if (target == null) {
            throw new UnresolvedException(pointId);
        }
        Action action = target.getAction(name);
        if (action == null) {
            throw new UnresolvedException("No action " + name);
        }
        BValue def = target.getActionParameterDefault(action);
        FoxResponse resp = new FoxResponse(req);
        if (def != null) {
            BOverride override;
            resp.add("default", ValueDocEncoder.marshal((BValue)def));
            if (def instanceof BOverride && !(override = (BOverride)def).getMaxOverrideDuration().equals((Object)BRelTime.DEFAULT)) {
                resp.add("maxOverrideDuration", override.getMaxOverrideDuration().encodeToString());
            }
        }
        if (this.isTraceOn()) {
            this.trace("s:getActionDefault");
            resp.dump();
        }
        return resp;
    }

    public BValue invoke(IProxyActionParent proxyActionParent, BVirtualAction action, BValue arg) throws Exception {
        return this.invoke(proxyActionParent.getPointId(), action.getProxyActionName(), arg);
    }

    public BValue invoke(String ord, String actionName, BValue arg) throws Exception {
        FoxRequest req = this.makeRequest("invoke");
        req.add("pid", ord);
        req.add("name", actionName);
        if (arg != null) {
            req.add("arg", ValueDocEncoder.marshal((BValue)arg));
        }
        if (this.isTraceOn()) {
            this.trace("c:invoke");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        BValue result = null;
        String resultStr = resp.getString("return", null);
        if (resultStr != null) {
            result = ValueDocDecoder.unmarshal((String)resultStr);
        }
        return result;
    }

    private final FoxResponse invoke(FoxRequest req) throws Exception {
        String pointId = req.getString("pid");
        String name = req.getString("name");
        String argStr = req.getString("arg", null);
        OrdTarget t = BOrd.make((String)pointId).resolve((BObject)Sys.getStation());
        BComponent target = t.getComponent();
        if (target == null) {
            throw new UnresolvedException(pointId);
        }
        Action action = target.getAction(name);
        if (action == null) {
            throw new UnresolvedException("No action " + name);
        }
        BValue arg = null;
        if (argStr != null) {
            arg = ValueDocDecoder.unmarshal((String)argStr);
        }
        BValue result = null;
        try {
            result = target.invoke(action, arg, this.getSessionContext());
        }
        catch (ActionInvokeException e) {
            throw (Exception)e.getCause();
        }
        FoxResponse resp = new FoxResponse(req);
        if (result != null) {
            resp.add("return", ValueDocEncoder.marshal((BValue)result));
        }
        if (this.isTraceOn()) {
            this.trace("s:invoke");
            resp.dump();
        }
        return resp;
    }

    public BVirtualAction[] getActions(IProxyActionParent proxyActionParent) throws Exception {
        FoxRequest req = this.makeRequest("getActions");
        req.add("pid", proxyActionParent.getPointId());
        req.add("virtual", true);
        if (this.isTraceOn()) {
            this.trace("c:getActions");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        return ServerEntry.messageToActions((FoxMessage)resp.get("actions"), this.log);
    }

    public FoxResponse getActions(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BOrd ord = BOrd.make((String)req.getString("pid"));
        BComponent comp = (BComponent)ord.get((BObject)Sys.getStation());
        BPermissions permissions = this.getPermissionsFor(comp);
        if (!permissions.hasOperatorRead()) {
            throw new Exception("Invalid permissions to read Actions");
        }
        if (comp instanceof BNiagaraVirtualComponent) {
            ((BNiagaraVirtualComponent)comp).niagaraVirtualCompCheckActions();
        }
        boolean virtual = req.getBoolean("virtual");
        resp.add((FoxTuple)ServerEntry.actionsToMessage(comp, permissions, this.log, virtual));
        return resp;
    }

    public void write(BOrd ord, String name, BValue val) throws Exception {
        FoxRequest req = this.makeRequest("write");
        req.add("pid", ord.toString());
        req.add("name", name);
        req.add("val", ValueDocEncoder.marshal((BValue)val));
        if (this.isTraceOn()) {
            this.trace("c:write");
            req.dump();
        }
        this.sendSync(req);
    }

    private final FoxResponse write(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BOrd ord = BOrd.make((String)req.getString("pid"));
        BComponent comp = (BComponent)ord.get((BObject)this);
        String name = req.getString("name");
        if (name == null) {
            throw new UnresolvedException("No Property name decoded");
        }
        Property p = comp.getProperty(name);
        if (p == null) {
            throw new UnresolvedException("Invalid Property name");
        }
        BValue val = ValueDocDecoder.unmarshal((String)req.getString("val"));
        comp.set(p, val, this.getSessionContext());
        return resp;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPointChannel() {
        super("point");
    }

    static {
        Class clazz = class$com$tridium$nd$point$BPointChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$point$BPointChannel = BPointChannel.class("[Lcom.tridium.nd.point.BPointChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

