/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryExport;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraSystemHistoryExport
extends BNiagaraHistoryExport {
    public static final Property historyId = BNiagaraSystemHistoryExport.newProperty((int)7, (BValue)BHistoryId.NULL, null);
    public static final Property systemTagPatterns = BNiagaraSystemHistoryExport.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nd$history$BNiagaraSystemHistoryExport;

    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public void setHistoryId(BHistoryId v) {
        this.set(historyId, (BValue)v, null);
    }

    public String getSystemTagPatterns() {
        return this.getString(systemTagPatterns);
    }

    public void setSystemTagPatterns(String v) {
        this.setString(systemTagPatterns, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExecute() {
        BNiagaraHistoryDeviceExt devicelet;
        block18: {
            block17: {
                block16: {
                    block15: {
                        this.executeInProgress();
                        devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
                        try {
                            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                        }
                        catch (Exception e) {
                            this.executeFail(e);
                            if (!devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) return;
                            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                            return;
                        }
                        try {
                            try {
                                String list = this.getSystemTagPatterns();
                                if (list == null || list.length() < 1) {
                                    this.executeFail("System Tag Patterns is null.");
                                    Object var3_6 = null;
                                    break block15;
                                }
                                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                                BHistoryDatabase db = service.getDatabase();
                                if (!(db instanceof BLocalHistoryDatabase)) {
                                    this.executeFail("Local history database not available.");
                                    break block16;
                                }
                                BHistoryConfig[] matchingConfigs = ((BLocalHistoryDatabase)db).getConfigs(list);
                                if (matchingConfigs == null || matchingConfigs.length < 1) {
                                    this.executeFail("No matching histories found for System Tag Patterns provided.");
                                    break block17;
                                }
                                BArchiveChannel archiveChannel = devicelet.getClientArchiveChannel();
                                BHistoryChannel historyChannel = devicelet.getClientHistoryChannel();
                                int len = matchingConfigs.length;
                                int i = 0;
                                while (true) {
                                    if (i >= len) {
                                        this.executeOk();
                                        break block18;
                                    }
                                    BHistoryId id = matchingConfigs[i].getId();
                                    BIHistory history = db.resolveHistory(id);
                                    BHistorySummary summary = historyChannel.getSummary(id);
                                    if (summary == null) {
                                        archiveChannel.createHistory(history.getConfig());
                                    } else {
                                        archiveChannel.updateConfig(history.getConfig());
                                    }
                                    Object startTime = null;
                                    if (summary != null) {
                                        startTime = summary.getLastTimestamp();
                                        startTime = startTime.isNull() ? null : startTime.add(BRelTime.make((long)1L));
                                    }
                                    historyChannel.append(id, history.timeQuery(startTime, null).cursor());
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                this.executeFail(e);
                                Object var3_9 = null;
                                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_10 = null;
                            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                            throw throwable;
                        }
                    }
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    return;
                }
                Object var3_7 = null;
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                return;
            }
            Object var3_8 = null;
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            return;
        }
        Object var3_11 = null;
        devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nd$history$BNiagaraSystemHistoryExport;
        if (clazz == null) {
            clazz = class$com$tridium$nd$history$BNiagaraSystemHistoryExport = BNiagaraSystemHistoryExport.class("[Lcom.tridium.nd.history.BNiagaraSystemHistoryExport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

