/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.file;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.util.BSimpleMap;
import javax.baja.driver.util.BDescriptor;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileScheme;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNiagaraFileDescriptor
extends BDescriptor
implements BFoxClientConnection.Interest {
    public static final Property files = BNiagaraFileDescriptor.newProperty((int)0, (BValue)BSimpleMap.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"niagaraDriver:FileOrdsFE"));
    public static final Property fileOverwritePolicy = BNiagaraFileDescriptor.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    public static final Type TYPE;
    private static final Log log;
    private static final Version checksumVersionStart;
    private Object syncObj;
    private boolean executeInProgress;
    private BRelTime lastExecutionTime;
    private BRelTime longestExecutionTime;
    private BRelTime shortestExecutionTime;
    private long totalSuccessfulExecutions;
    private long totalFailedExecutions;
    static /* synthetic */ Class class$com$tridium$nd$file$BNiagaraFileDescriptor;

    public BSimpleMap getFiles() {
        return (BSimpleMap)this.get(files);
    }

    public void setFiles(BSimpleMap v) {
        this.set(files, (BValue)v, null);
    }

    public BFileOverwritePolicy getFileOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(fileOverwritePolicy);
    }

    public void setFileOverwritePolicy(BFileOverwritePolicy v) {
        this.set(fileOverwritePolicy, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraFileDeviceExt;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BNiagaraFileDeviceExt deviceExt = (BNiagaraFileDeviceExt)this.getParent();
        deviceExt.getNiagaraNetwork().getWorkers().process(new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    /*
     * Exception decompiling
     */
    public void doExecute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 23->58)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void doFileExecute(BFileSpace var1) throws Exception;

    protected void createAllFiles(BFileSpace sourceSpace, BOrd sourceFileOrd, BFileSpace targetSpace, BOrd targetFileOrd) throws Exception {
        FilePath sourceFilePath = this.getFilePath(sourceFileOrd);
        BIFile sourceFile = sourceSpace.findFile(sourceFilePath);
        FilePath targetFilePath = this.getFilePath(targetFileOrd);
        BIFile targetFile = targetSpace.findFile(targetFilePath);
        if (sourceFile == null) {
            throw new Exception("Could not find " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " File: " + sourceFileOrd);
        }
        if (sourceFile.isDirectory()) {
            if (targetFile != null && !targetFile.isDirectory()) {
                throw new Exception(BNiagaraFileDescriptor.toSpaceText(targetSpace) + " File is not a Directory: " + targetFilePath);
            }
            if (targetFile == null) {
                targetSpace.makeDir(targetFilePath);
            }
            BIFile[] sourceFileKids = ((BIDirectory)sourceFile).listFiles();
            int i = 0;
            while (i < sourceFileKids.length) {
                FilePath newFilePath = targetFilePath.merge(sourceFileKids[i].getFileName());
                if (sourceFileKids[i].isDirectory()) {
                    targetSpace.makeDir(newFilePath);
                }
                this.createAllFiles(sourceSpace, BOrd.make((OrdQuery)sourceFileKids[i].getFilePath()), targetSpace, BOrd.make((OrdQuery)newFilePath));
                ++i;
            }
        } else {
            if (targetFile != null && targetFile.isDirectory()) {
                throw new Exception(BNiagaraFileDescriptor.toSpaceText(targetSpace) + " File is a Directory!");
            }
            this.createFile(sourceSpace, sourceFileOrd, targetSpace, targetFileOrd);
        }
    }

    private final void createFile(BFileSpace sourceSpace, BOrd sourceFileOrd, BFileSpace targetSpace, BOrd targetFileOrd) throws Exception {
        FilePath sourceFilePath = this.getFilePath(sourceFileOrd);
        BIFile sourceFile = sourceSpace.findFile(sourceFilePath);
        if (sourceFile == null) {
            throw new Exception("Could not find " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " File: " + sourceFilePath);
        }
        FilePath targetFilePath = this.getFilePath(targetFileOrd);
        BIFile targetFile = targetSpace.findFile(targetFilePath);
        if (targetFile == null) {
            if (log.isTraceOn()) {
                log.trace("Creating file from " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + ": " + sourceFilePath);
            }
            this.createFile(targetSpace, targetFilePath, sourceFile);
        } else if (targetFile != null && this.getFileOverwritePolicy() == BFileOverwritePolicy.lastModified) {
            BAbsTime targetFileModified;
            BAbsTime sourceFileModified = this.toNearestSecond(sourceFile.getLastModified());
            if (sourceFileModified.isAfter(targetFileModified = this.toNearestSecond(targetFile.getLastModified()))) {
                if (log.isTraceOn()) {
                    log.trace("File lastModified different. Creating/overwriting file from " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + ": " + sourceFilePath);
                }
                this.createFile(targetSpace, targetFilePath, sourceFile);
            } else if (log.isTraceOn()) {
                log.trace("File dates are the same - ignoring: " + sourceFilePath);
            }
        } else if (targetFile != null && this.getFileOverwritePolicy() == BFileOverwritePolicy.checksum && targetFile instanceof BAbstractFile && sourceFile instanceof BAbstractFile) {
            long sourceCrc = ((BAbstractFile)sourceFile).getCrc();
            long targetCrc = ((BAbstractFile)targetFile).getCrc();
            if (sourceCrc == (long)-1) {
                throw new Exception("Failed to get CRC from file: " + sourceFile.getFilePath());
            }
            if (targetCrc == (long)-1) {
                throw new Exception("Failed to get CRC from file: " + targetFile.getFilePath());
            }
            if (sourceCrc != targetCrc) {
                if (log.isTraceOn()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("File checksum is different. Creating/overwriting file from ");
                    buff.append(BNiagaraFileDescriptor.toSpaceText(sourceSpace));
                    buff.append(": ");
                    buff.append(sourceFilePath);
                    buff.append(" (");
                    buff.append(sourceCrc);
                    buff.append(") (");
                    buff.append(targetCrc);
                    buff.append(")");
                    log.trace(buff.toString());
                }
                this.createFile(targetSpace, targetFilePath, sourceFile);
            } else if (log.isTraceOn()) {
                log.trace("File checksums are the same - ignoring: " + sourceFilePath);
            }
        } else {
            throw new Exception("Failed to create " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " file: " + targetFileOrd);
        }
    }

    private final BIFile createFile(BFileSpace fileSpace, FilePath filePath, BIFile file) throws Exception {
        fileSpace.delete(filePath);
        BIFile newFile = fileSpace.makeFile(filePath);
        FileUtil.pipe((BIFile)file, (BIFile)newFile);
        if (newFile instanceof BAbstractFile && !((BAbstractFile)newFile).setLastModified(file.getLastModified())) {
            throw new Exception("Could not set lastModified on " + BNiagaraFileDescriptor.toSpaceText(fileSpace) + "file: " + filePath);
        }
        return newFile;
    }

    private final FilePath getFilePath(BOrd ord) throws Exception {
        OrdQuery[] queries = ord.parse();
        int i = 0;
        while (i < queries.length) {
            if (queries[i].getScheme().equals(BFileScheme.INSTANCE.getId())) {
                return new FilePath(queries[i].getBody());
            }
            ++i;
        }
        throw new Exception("Could not find File Scheme in ORD: " + ord);
    }

    private final BAbsTime toNearestSecond(BAbsTime absTime) {
        return BAbsTime.make((int)absTime.getYear(), (BMonth)absTime.getMonth(), (int)absTime.getDay(), (int)absTime.getHour(), (int)absTime.getMinute(), (int)absTime.getSecond(), (int)0, (BTimeZone)absTime.getTimeZone());
    }

    private static final String toSpaceText(BFileSpace fileSpace) {
        if (fileSpace instanceof BFoxFileSpace) {
            return "Remote";
        }
        return "Local";
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Niagara File Descriptor");
        out.prop((Object)"Last Execution Time", (Object)this.lastExecutionTime);
        out.prop((Object)"Longest Execution Time", (Object)this.longestExecutionTime);
        out.prop((Object)"Shortest Execution Time", (Object)this.shortestExecutionTime);
        out.prop((Object)"Total Successful Executions", (Object)String.valueOf(this.totalSuccessfulExecutions));
        out.prop((Object)"Total Failed Executions", (Object)String.valueOf(this.totalFailedExecutions));
        out.endProps();
        super.spy(out);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.syncObj = new Object();
        this.executeInProgress = false;
        this.lastExecutionTime = BRelTime.DEFAULT;
        this.longestExecutionTime = BRelTime.DEFAULT;
        this.shortestExecutionTime = BRelTime.DEFAULT;
        this.totalSuccessfulExecutions = 0L;
        this.totalFailedExecutions = 0L;
    }

    public BNiagaraFileDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$file$BNiagaraFileDescriptor;
        if (clazz == null) {
            clazz = class$com$tridium$nd$file$BNiagaraFileDescriptor = BNiagaraFileDescriptor.class("[Lcom.tridium.nd.file.BNiagaraFileDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"niagara.file");
        checksumVersionStart = new Version("3.5");
    }
}

