/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.BIUpdatableAlarmSource;
import com.tridium.alarm.BStationRecipient;
import com.tridium.alarm.BTextCustomizer;
import com.tridium.alarm.BTextOp;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraAlarmDeviceExt
extends BAlarmDeviceExt
implements BINiagaraDeviceExt,
BFoxClientConnection.Interest,
BIUpdatableAlarmSource {
    public static final Property alarmClass = BNiagaraAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:DeviceExtAlarmClassFE")));
    public static final Property sourceName = BNiagaraAlarmDeviceExt.newProperty((int)0, (BValue)new BTextCustomizer(BTextOp.prepend, BFormat.make((String)"%parent.parent.displayName%:")), null);
    public static final Property workerState = BNiagaraAlarmDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property lastSendTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureCause = BNiagaraAlarmDeviceExt.newProperty((int)1, (String)"", null);
    public static final Action updateAlarm = BNiagaraAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final Log logger;
    private Queue workQueue;
    AlarmWorker worker;
    private BStatus oldStatus;
    static /* synthetic */ Class class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt;
    static /* synthetic */ Class class$com$tridium$alarm$BStationRecipient;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BTextCustomizer getSourceName() {
        return (BTextCustomizer)this.get(sourceName);
    }

    public void setSourceName(BTextCustomizer v) {
        this.set(sourceName, (BValue)v, null);
    }

    public String getWorkerState() {
        return this.getString(workerState);
    }

    public void setWorkerState(String v) {
        this.setString(workerState, v, null);
    }

    public BAbsTime getLastSendTime() {
        return (BAbsTime)this.get(lastSendTime);
    }

    public void setLastSendTime(BAbsTime v) {
        this.set(lastSendTime, (BValue)v, null);
    }

    public BAbsTime getLastSendFailureTime() {
        return (BAbsTime)this.get(lastSendFailureTime);
    }

    public void setLastSendFailureTime(BAbsTime v) {
        this.set(lastSendFailureTime, (BValue)v, null);
    }

    public String getLastSendFailureCause() {
        return this.getString(lastSendFailureCause);
    }

    public void setLastSendFailureCause(String v) {
        this.setString(lastSendFailureCause, v, null);
    }

    public void updateAlarm(BAlarmRecord alarm) {
        this.invoke(updateAlarm, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BDevice device = this.getDevice();
        BStatus status = device.getStatus();
        if ((this.oldStatus.isStale() || this.oldStatus.isDisabled()) && !status.isDisabled()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isDisabled() && status.isDisabled()) {
            if (this.worker != null) {
                this.worker.kill("disabled");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isFault()) && !status.isFault()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isFault() && status.isFault()) {
            if (this.worker != null) {
                this.worker.kill("fault");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isDown()) && !status.isDown()) {
            this.initWorker(true);
        } else if (!this.oldStatus.isDown()) {
            status.isDown();
        }
        this.oldStatus = status;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.updateStatus();
        }
    }

    public void stationStarted() throws Exception {
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initWorker(boolean enqueueMissedAlarms) {
        Queue queue = this.workQueue;
        synchronized (queue) {
            this.workQueue.clear();
            if (enqueueMissedAlarms) {
                this.workQueue.enqueue((Object)new InitNewAlarms(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAlarmUpdates(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAckPending());
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
            if (this.worker == null) {
                this.worker = new AlarmWorker(this, this.workQueue);
            }
            if (!this.worker.isRunning()) {
                this.worker.start();
            }
            return;
        }
    }

    public void stopped() {
        if (this.worker != null) {
            this.worker.kill("ext stopped");
            this.worker = null;
        }
    }

    public void doUpdateAlarm(BAlarmRecord alarm) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("BNiagaraAlarms.doUpdateAlarm: " + alarm.getTimestamp() + ' ' + alarm.getAlarmClass() + ' ' + alarm.getSource());
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(alarm));
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarm) throws Exception {
        BAlarmRecord ackRequest = (BAlarmRecord)alarm.newCopy();
        if (logger.isTraceOn()) {
            logger.trace("BNiagaraAlarms.doAckAlarm: " + ackRequest.getTimestamp() + ' ' + ackRequest.getAlarmClass() + ' ' + ackRequest.getSource());
        }
        BOrdList src = ackRequest.getSource();
        BOrdList newSrc = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
        ackRequest.setSource(newSrc);
        BObject hyperlink = ackRequest.getAlarmData().get("hyperlinkOrd");
        if (hyperlink != null) {
            BNiagaraStation station = (BNiagaraStation)this.getParent();
            String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
            if (hyperlink.toString().startsWith(toRemove)) {
                String newHyperlink = hyperlink.toString().substring(toRemove.length());
                ackRequest.setAlarmData(BFacets.make((BFacets)ackRequest.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlink)));
            }
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(ackRequest));
        }
        return BBoolean.make((boolean)true);
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(record));
        }
    }

    public BStationRecipient[] getRegisteredStationRecipients() {
        try {
            Class clazz = class$com$tridium$alarm$BStationRecipient;
            if (clazz == null) {
                clazz = class$com$tridium$alarm$BStationRecipient = BNiagaraAlarmDeviceExt.class("[Lcom.tridium.alarm.BStationRecipient;", false);
            }
            Array recipients = new Array(clazz);
            this.doGetRegisteredRecipients(Sys.getService((Type)BAlarmService.TYPE), recipients);
            return (BStationRecipient[])recipients.trim();
        }
        catch (Exception e) {
            return new BStationRecipient[0];
        }
    }

    private final void doGetRegisteredRecipients(BComponent obj, Array recipients) {
        BComponent[] children = obj.getChildComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof BAlarmClassFolder) {
                this.doGetRegisteredRecipients(children[i], recipients);
            } else if (children[i] instanceof BStationRecipient && this.getDevice() != null && ((BStationRecipient)children[i]).getRemoteStation().equals(this.getDevice().getName())) {
                recipients.add((Object)children[i]);
            }
            ++i;
        }
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("NiagaraAlarmDeviceExt");
        out.prop((Object)"deviceStatus", (Object)("" + this.oldStatus));
        out.prop((Object)"queueSize", (Object)("" + this.workQueue.size()));
        int qSize = this.workQueue.size() > 3 ? 3 : this.workQueue.size();
        Object[] qArray = this.workQueue.toArray();
        int i = 0;
        while (i < qSize) {
            out.prop((Object)("queueElem" + i), (Object)("" + qArray[i].getClass()));
            ++i;
        }
        if (this.worker == null) {
            out.prop((Object)"worker", (Object)"null");
        } else {
            out.prop((Object)"worker", (Object)this.getWorkerState());
        }
        out.endProps();
        super.spy(out);
    }

    private final AlarmRecordQueueItem makeAlarmRecordQueueItem(BAlarmRecord record) {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (alarmService.getCoalesceAlarms()) {
            return new CoalesceableAlarmRecordQueueItem(record);
        }
        return new AlarmRecordQueueItem(record);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.workQueue = new CoalesceQueue();
        this.oldStatus = BStatus.stale;
    }

    public BNiagaraAlarmDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt = BNiagaraAlarmDeviceExt.class("[Lcom.tridium.nd.alarm.BNiagaraAlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"niagara.alarms");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitNewAlarms
    implements InitJob {
        BAbsTime startTime;

        public void execute() {
            String str = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + '\'';
            BStationRecipient[] recips = BNiagaraAlarmDeviceExt.this.getRegisteredStationRecipients();
            if (recips.length <= 0) {
                return;
            }
            BOrd ord = BOrd.make((String)str);
            BICollection result = (BICollection)ord.resolve().get();
            Cursor cur = result.cursor();
            Array[] alarmClasses = new Array[4];
            int c = 0;
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                String esc = alarm.getAlarmData().gets(BAlarmClass.ESCALATED, null);
                int escalationLevel = 0;
                if (esc != null) {
                    if (esc.equals(BAlarmClass.LEVEL_1)) {
                        escalationLevel = 1;
                    } else if (esc.equals(BAlarmClass.LEVEL_2)) {
                        escalationLevel = 2;
                    } else if (esc.equals(BAlarmClass.LEVEL_3)) {
                        escalationLevel = 3;
                    }
                }
                int i = 0;
                while (i < recips.length) {
                    alarmClasses[0] = new Array((Object[])recips[i].getSubscribedAlarmClasses());
                    alarmClasses[1] = new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(1));
                    alarmClasses[2] = new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(2));
                    alarmClasses[3] = new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(3));
                    int a = 0;
                    while (a <= escalationLevel) {
                        if (alarmClasses[a].contains((Object)alarm.getAlarmClass()) && recips[i].accept(alarm)) {
                            BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(alarm));
                            ++c;
                        }
                        ++a;
                    }
                    ++i;
                }
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + c + " alarms");
            }
        }

        public InitNewAlarms(BAbsTime startTime) {
            this.startTime = startTime;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitAlarmUpdates
    implements InitJob {
        BAbsTime startTime;

        public void execute() {
            String str = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + '\'';
            str = str + " AND source LIKE '%" + BNiagaraAlarmDeviceExt.this.getSlotPath() + "' AND alarmData LIKE '%notes=%' AND ackState != alarm:AckState.ackPending";
            BOrd ord = BOrd.make((String)str);
            BICollection result = (BICollection)ord.resolve().get();
            Cursor cur = result.cursor();
            int c = 0;
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(alarm));
                ++c;
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + c + " alarms");
            }
        }

        public InitAlarmUpdates(BAbsTime startTime) {
            this.startTime = startTime;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitAckPending
    implements InitJob {
        public void execute() {
            String str = "alarm:|bql:select * from ackPendingAlarms";
            BOrd ord = BOrd.make((String)str);
            BICollection result = (BICollection)ord.resolve().get();
            Cursor cur = result.cursor();
            int c = 0;
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                BOrdList src = alarm.getSource();
                if (src.size() == 0 || !src.get(src.size() - 1).toString().equals(BNiagaraAlarmDeviceExt.this.getSlotPath().toString())) continue;
                BAlarmRecord ackRequest = (BAlarmRecord)alarm.newCopy();
                BOrdList newSrc = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
                ackRequest.setSource(newSrc);
                BObject hyperlink = ackRequest.getAlarmData().get("hyperlinkOrd");
                if (hyperlink != null) {
                    BNiagaraStation station = (BNiagaraStation)BNiagaraAlarmDeviceExt.this.getParent();
                    String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
                    if (hyperlink.toString().startsWith(toRemove)) {
                        String newHyperlink = hyperlink.toString().substring(toRemove.length());
                        ackRequest.setAlarmData(BFacets.make((BFacets)ackRequest.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlink)));
                    }
                }
                BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(ackRequest));
                ++c;
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + c + " alarm acks");
            }
        }

        InitAckPending() {
        }
    }

    static class CoalesceableAlarmRecordQueueItem
    extends AlarmRecordQueueItem
    implements ICoalesceable {
        public ICoalesceable coalesce(ICoalesceable obj) {
            if (obj instanceof AlarmRecordQueueItem && ((AlarmRecordQueueItem)obj).record.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                return this;
            }
            return obj;
        }

        public Object getCoalesceKey() {
            return this.record.getUuid();
        }

        CoalesceableAlarmRecordQueueItem(BAlarmRecord record) {
            super(record);
        }
    }

    static class AlarmRecordQueueItem
    implements ICoalesceable {
        BAlarmRecord record;

        public ICoalesceable coalesce(ICoalesceable obj) {
            if (obj instanceof AlarmRecordQueueItem && ((AlarmRecordQueueItem)obj).record.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                return this;
            }
            return obj;
        }

        public Object getCoalesceKey() {
            return this.record.getUuid().toString() + this.record.getSourceState().toString();
        }

        AlarmRecordQueueItem(BAlarmRecord record) {
            this.record = (BAlarmRecord)record.newCopy();
        }
    }

    static interface InitJob {
        public void execute();
    }
}

