/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import com.tridium.alarm.BTextOp;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmChannel
extends BFoxChannel {
    public static final Action alarmAck = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action alarmUpdate = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final Log logger;
    BUser lastUser;
    static /* synthetic */ Class class$com$tridium$nd$alarm$BAlarmChannel;
    static /* synthetic */ Class class$com$tridium$alarm$AlarmClassRouteAlarmInvocation;

    public void alarmAck(BAlarmRecord alarm) {
        this.invoke(alarmAck, (BValue)alarm, null);
    }

    public void alarmUpdate(BAlarmRecord alarm) {
        this.invoke(alarmUpdate, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (logger.isTraceOn()) {
            logger.trace("AlarmChannel.command = " + command);
        }
        try {
            if (command == "new") {
                return this.newAlarms(request);
            }
            if (command == "ack") {
                return this.ackAlarms(request);
            }
            if (command == "update") {
                return this.updateAlarms(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        throw new InvalidCommandException(command);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == alarmAck) {
            Queue q = (Queue)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).fw(601);
            q.enqueue((Object)AlarmClassRouteAlarmInvocation.make((BComponent)this, (Action)action, (BAlarmRecord)((BAlarmRecord)argument), (Context)cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    private final FoxResponse newAlarms(FoxRequest request) throws Exception {
        Class clazz;
        if (logger.isTraceOn()) {
            logger.trace("recieved: new");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.adminWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + msgs.length + " alarms");
        }
        if ((clazz = class$com$tridium$alarm$AlarmClassRouteAlarmInvocation) == null) {
            clazz = class$com$tridium$alarm$AlarmClassRouteAlarmInvocation = BAlarmChannel.class("[Lcom.tridium.alarm.AlarmClassRouteAlarmInvocation;", false);
        }
        Array futuresArray = new Array(clazz);
        int i = 0;
        while (i < msgs.length) {
            String newName;
            BString sourceName;
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            BAlarmChannel.modifyAlarmClass(alarm, devicelet);
            BOrdList src = alarm.getSource();
            BOrdList newSrc = BOrdList.add((BOrdList)src, (BOrd)BOrd.make((OrdQuery)devicelet.getSlotPath()));
            alarm.setSource(newSrc);
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: new -> routeAlarm " + alarm.getTimestamp() + ' ' + alarm.getSource().encodeToString());
            }
            if ((sourceName = (BString)alarm.getAlarmData().get("sourceName")) != null) {
                newName = this.getDeviceExt().getSourceName().customize(sourceName.toString());
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
            } else if (this.getDeviceExt().getSourceName().getOp() == BTextOp.replace) {
                newName = this.getDeviceExt().getSourceName().customize("");
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
            }
            BObject hyperlink = alarm.getAlarmData().get("hyperlinkOrd");
            if (hyperlink != null) {
                BNiagaraStation station = (BNiagaraStation)this.getDeviceExt().getParent();
                String prependString = AlarmWorker.makeStationSessionOrdSegment(station);
                BString hyperlinkString = (BString)hyperlink;
                if (!hyperlink.toString().startsWith(prependString)) {
                    hyperlinkString = BString.make((String)(prependString + hyperlink.toString()));
                }
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)hyperlinkString));
            }
            BAlarmClass alarmClassObj = as.lookupAlarmClass(alarm.getAlarmClass());
            AlarmClassRouteAlarmInvocation future = (AlarmClassRouteAlarmInvocation)alarmClassObj.post(BAlarmClass.routeAlarm, (BValue)alarm, null);
            futuresArray.add((Object)future);
            ++i;
        }
        AlarmClassRouteAlarmInvocation[] futures = (AlarmClassRouteAlarmInvocation[])futuresArray.trim();
        boolean dbWritesFinished = false;
        while (!dbWritesFinished) {
            dbWritesFinished = true;
            int i2 = 0;
            while (i2 < futures.length) {
                if (!futures[i2].isFinished()) {
                    dbWritesFinished = false;
                }
                ++i2;
            }
            Thread.sleep(10L);
        }
        boolean dbWriteFailed = false;
        Exception dbWriteException = null;
        int i3 = 0;
        while (i3 < futures.length) {
            dbWriteException = futures[i3].getException();
            if (dbWriteException != null) {
                dbWriteFailed = true;
            }
            ++i3;
        }
        if (request.getBoolean("dbWriteSuccessEnabled", false)) {
            resp.add("dbWriteSuccess", dbWriteFailed ^ true);
            if (dbWriteFailed) {
                resp.add("failureCause", dbWriteException.getMessage());
            }
        }
        return resp;
    }

    private static final void modifyAlarmClass(BAlarmRecord alarm, BNiagaraAlarmDeviceExt devicelet) {
        String alarmClass = devicelet.getAlarmClass();
        if (alarmClass == null || alarmClass.equals("")) {
            return;
        }
        alarm.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)SlotPath.unescape((String)alarmClass), (String)"%alarmClass%", (String)SlotPath.unescape((String)alarm.getAlarmClass()))));
    }

    public void newAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("new");
        msg.add("dbWriteSuccessEnabled", true);
        BAbsTime lastTime = BAbsTime.NULL;
        if (logger.isTraceOn()) {
            logger.trace("sending " + alarms.length + " alarms");
        }
        int i = 0;
        while (i < alarms.length) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (alarms[i].getLastUpdate().isAfter(lastTime)) {
                lastTime = alarms[i].getLastUpdate();
            }
            ++i;
        }
        try {
            FoxResponse resp = this.sendSync(msg);
            if (!resp.getBoolean("dbWriteSuccess", true)) {
                throw new Exception(resp.getString("failureCause", "Remote Alarm Database Failure"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    public void ackAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("ack");
        if (logger.isTraceOn()) {
            logger.trace("sending " + alarms.length + " alarm acks");
        }
        BAbsTime lastTime = BAbsTime.NULL;
        int i = 0;
        while (i < alarms.length) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (alarms[i].getLastUpdate().isAfter(lastTime)) {
                lastTime = alarms[i].getLastUpdate();
            }
            ++i;
        }
        if (logger.isTraceOn()) {
            logger.trace("sending: ack");
        }
        try {
            this.sendAsync(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    private final FoxResponse ackAlarms(FoxRequest request) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("received: ack");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.adminWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + msgs.length + " alarm acks");
        }
        int i = 0;
        while (i < msgs.length) {
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: ack -> routeAlarm: " + alarm.getTimestamp() + ' ');
            }
            this.alarmAck(alarm);
            ++i;
        }
        return resp;
    }

    public void doAlarmAck(BAlarmRecord alarm) throws Exception {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase db = as.getAlarmDb();
        BAlarmRecord dbRec = db.getRecord(alarm.getUuid());
        if (dbRec == null) {
            if (logger.isTraceOn()) {
                logger.trace("add new alarm");
            }
            alarm.setLastUpdate(BAbsTime.now());
            db.append(alarm);
        } else if (dbRec.getAckState() != BAckState.acked) {
            if (logger.isTraceOn()) {
                logger.trace("update alarm ackState = " + alarm.getAckState());
            }
            alarm.setLastUpdate(BAbsTime.now());
            BObject sourceName = dbRec.getAlarmData().get("sourceName");
            if (sourceName != null) {
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)((BIDataValue)sourceName)));
            }
            db.update(alarm);
        } else {
            if (logger.isTraceOn()) {
                logger.trace("already have ack for " + alarm.getUuid() + " notifying sender...");
            }
            this.getDeviceExt().doRouteAlarm(dbRec);
            return;
        }
        if (dbRec != null) {
            alarm.setAlarmClass(dbRec.getAlarmClass());
        }
        as.ackAlarm(alarm);
    }

    public void updateAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("update");
        if (logger.isTraceOn()) {
            logger.trace("sending " + alarms.length + " alarm updates");
        }
        BAbsTime lastTime = BAbsTime.NULL;
        int i = 0;
        while (i < alarms.length) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (alarms[i].getLastUpdate().isAfter(lastTime)) {
                lastTime = alarms[i].getLastUpdate();
            }
            ++i;
        }
        if (logger.isTraceOn()) {
            logger.trace("sending: update");
        }
        try {
            this.sendAsync(msg);
        }
        catch (InvalidCommandException ice) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    private final FoxResponse updateAlarms(FoxRequest request) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("received: update");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.operatorWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + msgs.length + " alarm updates");
        }
        int i = 0;
        while (i < msgs.length) {
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: update -> routeToSource: " + alarm.getTimestamp() + ' ');
            }
            this.alarmUpdate(alarm);
            ++i;
        }
        return resp;
    }

    public void doAlarmUpdate(BAlarmRecord alarm) throws Exception {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        boolean isUseful = true;
        BAlarmDatabase db = as.getAlarmDb();
        BAlarmRecord dbRec = db.getRecord(alarm.getUuid());
        if (dbRec == null) {
            if (logger.isTraceOn()) {
                logger.trace("add updated alarm");
            }
            alarm.setLastUpdate(BAbsTime.now());
            db.append(alarm);
            dbRec = alarm;
        } else {
            if (logger.isTraceOn()) {
                logger.trace("update updated alarm");
            }
            if (alarm.getAlarmData().get("notes") != null && !alarm.getAlarmData().get("notes").equals((Object)dbRec.getAlarmData().get("notes"))) {
                dbRec.setAlarmData(BFacets.make((BFacets)dbRec.getAlarmData(), (String)"notes", (BIDataValue)((BIDataValue)alarm.getAlarmData().get("notes"))));
                dbRec.setLastUpdate(BAbsTime.now());
                db.update(dbRec);
            } else {
                isUseful = false;
            }
        }
        if (isUseful) {
            as.doRouteToSource(dbRec);
            as.doRouteAlarm(dbRec);
        }
    }

    public final BNiagaraAlarmDeviceExt getDeviceExt() {
        try {
            return ((BNiagaraStation)this.getConnection().getParent()).getAlarms();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmChannel() {
        super("alarm");
    }

    static {
        Class clazz = class$com$tridium$nd$alarm$BAlarmChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$alarm$BAlarmChannel = BAlarmChannel.class("[Lcom.tridium.nd.alarm.BAlarmChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"niagara.alarms");
    }
}

