/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.BAlarmChannel;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmWorker
implements Runnable,
ICoalesceable {
    public static int WORKER_SLEEP = 1000;
    private Queue workQueue;
    private BNiagaraAlarmDeviceExt ext;
    private BNiagaraStation station;
    private boolean isAlive;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;
    static /* synthetic */ Class class$javax$baja$util$BUuid;

    private final BFoxClientConnection getConnection() throws Exception {
        return this.station.getClientConnection();
    }

    private final BAlarmChannel getAlarmChannel() throws Exception {
        return (BAlarmChannel)this.getConnection().getChannels().get("alarm", BAlarmChannel.TYPE);
    }

    public void start() {
        this.isAlive = true;
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, WORKER_SLEEP);
        }
    }

    public void kill() {
        this.kill("");
    }

    public void kill(String reason) {
        this.isAlive = false;
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.ext.setWorkerState("stopped (" + reason + ')');
        if (BNiagaraAlarmDeviceExt.logger.isTraceOn()) {
            BNiagaraAlarmDeviceExt.logger.trace("stopped (" + reason + ')');
        }
    }

    public boolean isRunning() {
        return this.isAlive;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [5 : 867->873)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isNextAlarmOfType(Queue q, BAckState state) {
        Object obj = q.peek();
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)) {
            return false;
        }
        boolean bl = false;
        if (((BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)obj).record.getAckState() == state) {
            bl = true;
        }
        return bl;
    }

    private final void sendAlarmUpdates(BAlarmRecord[] alarms) throws Exception {
        int i = 0;
        while (i < alarms.length) {
            BAlarmRecord alarm = alarms[i];
            BOrdList src = alarm.getSource();
            src = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
            alarm.setSource(src);
            BObject hyperlink = alarm.getAlarmData().get("hyperlinkOrd");
            if (hyperlink != null) {
                BNiagaraStation station = (BNiagaraStation)this.getAlarmChannel().getDeviceExt().getParent();
                String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
                if (hyperlink.toString().startsWith(toRemove)) {
                    String newHyperlink = hyperlink.toString().substring(toRemove.length());
                    alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlink)));
                }
            }
            ++i;
        }
        this.getAlarmChannel().updateAlarms(alarms);
    }

    static final String makeStationSessionOrdSegment(BNiagaraStation station) {
        StringBuffer buff = new StringBuffer();
        buff.append(station.getAddress().toString());
        buff.append("|fox");
        if (station.getClientConnection().getUseFoxs()) {
            buff.append("s");
        }
        buff.append(":");
        buff.append(station.getFoxPort());
        buff.append("|");
        return buff.toString();
    }

    public String toString() {
        try {
            return this.station.getName() + ":Alarm Worker";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isAlive = false;
    }

    AlarmWorker(BNiagaraAlarmDeviceExt ext, Queue workQueue) {
        this.this();
        this.ext = ext;
        this.workQueue = workQueue;
        this.station = (BNiagaraStation)ext.getDevice();
    }
}

