/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BServerConnections;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BCyclicThreadPoolWorker;
import com.tridium.nd.BNiagaraFoxService;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.BNiagaraStationFolder;
import com.tridium.nd.BStationDiscoveryJob;
import com.tridium.nd.alarm.BAlarmChannel;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.point.BNiagaraTuningPolicyMap;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.schedule.BScheduleChannel;
import com.tridium.nd.spy.SpyIndex;
import com.tridium.nd.sysdef.BBogProvider;
import com.tridium.nd.sysdef.BLocalSysDefStation;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nd.virtual.BNiagaraVirtualNetworkExt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraNetwork;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.spy.Spy;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BNiagaraNetwork
extends BDeviceNetwork
implements BIService,
NiagaraNetwork,
BINiagaraNetwork {
    public static final Property localStation = BNiagaraNetwork.newProperty((int)0, (BValue)new BLocalSysDefStation(), null);
    public static final Property sysDefProvider = BNiagaraNetwork.newProperty((int)0, (BValue)new BBogProvider(), null);
    public static final Property foxService = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraFoxService(), null);
    public static final Property tuningPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraTuningPolicyMap(), null);
    public static final Property historyPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    public static final Property workers = BNiagaraNetwork.newProperty((int)0, (BValue)new BCyclicThreadPoolWorker("NiagaraNetwork:SharedWorkers", Integer.MAX_VALUE), null);
    public static final Property virtualPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraVirtualNetworkExt(), null);
    public static final Action resetAllConnections = BNiagaraNetwork.newAction((int)144, null);
    public static final Action submitStationDiscoveryJob = BNiagaraNetwork.newAction((int)0, null);
    public static final Action rebuildStationMap = BNiagaraNetwork.newAction((int)20, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    public static final Log log;
    HashMap stations;
    static /* synthetic */ Class class$com$tridium$nd$BNiagaraNetwork;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxServerConnection;

    public final BLocalSysDefStation getLocalStation() {
        return (BLocalSysDefStation)this.get(localStation);
    }

    public final void setLocalStation(BLocalSysDefStation v) {
        this.set(localStation, (BValue)v, null);
    }

    public final BSysDefProvider getSysDefProvider() {
        return (BSysDefProvider)this.get(sysDefProvider);
    }

    public final void setSysDefProvider(BSysDefProvider v) {
        this.set(sysDefProvider, (BValue)v, null);
    }

    public final BNiagaraFoxService getFoxService() {
        return (BNiagaraFoxService)this.get(foxService);
    }

    public final void setFoxService(BNiagaraFoxService v) {
        this.set(foxService, (BValue)v, null);
    }

    public final BNiagaraTuningPolicyMap getTuningPolicies() {
        return (BNiagaraTuningPolicyMap)this.get(tuningPolicies);
    }

    public final void setTuningPolicies(BNiagaraTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public final BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    public final void setHistoryPolicies(BHistoryNetworkExt v) {
        this.set(historyPolicies, (BValue)v, null);
    }

    public final BCyclicThreadPoolWorker getWorkers() {
        return (BCyclicThreadPoolWorker)this.get(workers);
    }

    public final void setWorkers(BCyclicThreadPoolWorker v) {
        this.set(workers, (BValue)v, null);
    }

    public final BNiagaraVirtualNetworkExt getVirtualPolicies() {
        return (BNiagaraVirtualNetworkExt)this.get(virtualPolicies);
    }

    public final void setVirtualPolicies(BNiagaraVirtualNetworkExt v) {
        this.set(virtualPolicies, (BValue)v, null);
    }

    public final void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    public final BOrd submitStationDiscoveryJob() {
        return (BOrd)this.invoke(submitStationDiscoveryJob, null, null);
    }

    public final void rebuildStationMap() {
        this.invoke(rebuildStationMap, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type getDeviceType() {
        return BNiagaraStation.TYPE;
    }

    public final Type getDeviceFolderType() {
        return BNiagaraStationFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "niagaraDriver");
    }

    public final NiagaraStation getStation(String name) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (this.stations == null) {
            this.rebuildStationMap();
        }
        return (NiagaraStation)this.stations.get(name);
    }

    public final BINiagaraStation getNiagaraStation(String name) {
        if (!this.isRunning() || this.stations == null) {
            throw new NotRunningException();
        }
        return (BINiagaraStation)this.stations.get(name);
    }

    public final SysDefSession createSysDefSession(Context context) {
        this.loadSlots();
        return this.getSysDefProvider().createSession(context);
    }

    public final void scheduleSync(BStationRole role) {
        BDevice[] stations = this.getDevices();
        int i = 0;
        while (i < stations.length) {
            BNiagaraStation station = (BNiagaraStation)stations[i];
            if (station.getSysDef().getRole().equals((Object)role)) {
                station.getSysDef().getSyncTask().schedule();
            }
            ++i;
        }
    }

    private final void syncNonPeers() {
        this.scheduleSync(BStationRole.subordinate);
        this.scheduleSync(BStationRole.supervisor);
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() throws Exception {
        Spy.ROOT.add("niagaraNetwork", (Spy)new SpyIndex(this));
        this.updateLocalStation();
    }

    private final void updateLocalStation() {
        BLocalSysDefStation localStation = this.getLocalStation();
        String actualStationName = Sys.getStation().getStationName();
        String address = Sys.getLocalHost().getHostAddress();
        boolean anyChanged = false;
        if (!localStation.getStationName().equals(actualStationName)) {
            localStation.setStationName(actualStationName);
            localStation.resetVersions();
            anyChanged = true;
        }
        if (!localStation.getAddress().equals(address)) {
            localStation.setAddress(address);
            anyChanged = true;
        }
        if (anyChanged) {
            if (log.isTraceOn()) {
                log.trace("Niagara Network detected changes to the local station while it was offline.");
            }
            localStation.updateStationVersion();
        }
    }

    public final void serviceStopped() throws Exception {
    }

    public final void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.rebuildStationMap();
        this.getWorkers().register(this, -1);
    }

    public final void stopped() throws Exception {
        super.stopped();
        this.getWorkers().unregister(this);
    }

    public final void doResetAllConnections() {
        Set keySet = this.stations.keySet();
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            try {
                String name = (String)keys.next();
                BNiagaraStation station = (BNiagaraStation)this.getNiagaraStation(name);
                station.getClientConnection().manualDisconnect();
                station.getServerConnection().forceDisconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BServerConnections connectionsFolder = this.getFoxService().getServerConnections();
        Class clazz = class$com$tridium$fox$sys$BFoxServerConnection;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxServerConnection = BNiagaraNetwork.class("[Lcom.tridium.fox.sys.BFoxServerConnection;", false);
        }
        BFoxServerConnection[] connections = (BFoxServerConnection[])connectionsFolder.getChildren(clazz);
        int i = 0;
        while (i < connections.length) {
            try {
                connections[i].forceDisconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public final BOrd doSubmitStationDiscoveryJob(Context cx) {
        return new BStationDiscoveryJob(this).submit(cx);
    }

    public final void doRebuildStationMap() {
        if (!this.isRunning()) {
            return;
        }
        String myStationName = Sys.getStation().getStationName();
        HashMap<String, BNiagaraStation> map = new HashMap<String, BNiagaraStation>();
        BDevice[] devices = this.getDevices();
        int i = 0;
        while (i < devices.length) {
            BNiagaraStation station = (BNiagaraStation)devices[i];
            String name = station.getName();
            if (name.equals(myStationName)) {
                station.configFail("Station name is same as this station");
            } else if (map.get(name) != null) {
                station.configFail("Duplicate station name under NiagaraNework");
            } else {
                map.put(name, station);
                station.configOk();
            }
            ++i;
        }
        this.stations = map;
        BStationRole[] roles = new BStationRole[]{BStationRole.subordinate, BStationRole.supervisor};
        boolean needPurge = false;
        int r = 0;
        while (r < roles.length) {
            String[] names = this.getLocalStation().getStationRefs(roles[r]);
            int i2 = 0;
            while (i2 < names.length) {
                if (this.getStation(names[i2]) == null) {
                    if (log.isTraceOn()) {
                        log.trace("Removing deleted station: " + names[i2] + " from " + (Object)((Object)roles[r]));
                    }
                    this.getLocalStation().removeRef(names[i2], roles[r]);
                    needPurge = true;
                }
                ++i2;
            }
            ++r;
        }
        if (needPurge) {
            this.getSysDefProvider().purge();
        }
    }

    public final IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals((Object)resetAllConnections)) {
            try {
                Invocation i = new Invocation((BComponent)this, action, null, cx);
                try {
                    this.getWorkers().process(i);
                    return null;
                }
                catch (NotRunningException e) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.post(action, arg, cx);
    }

    public final void renamed(Property prop, String old, Context context) {
        super.renamed(prop, old, context);
        this.rebuildStationMap();
    }

    public final void childParented(Property prop, BValue v, Context context) {
        super.childParented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public final void childUnparented(Property prop, BValue v, Context context) {
        super.childUnparented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public final AgentList getAgents(Context cx) {
        return BNiagaraNetwork.filterProvAgentList((BComponent)this, super.getAgents(cx));
    }

    static final AgentList filterProvAgentList(BComponent comp, AgentList result) {
        int ixProvisioningManager = result.indexOf("provisioningNiagara:ProvisioningManager");
        if (ixProvisioningManager >= 0) {
            BNiagaraNetwork niagaraNetwork = null;
            if (comp instanceof BNiagaraNetwork) {
                niagaraNetwork = (BNiagaraNetwork)comp;
            } else {
                BComplex p = comp.getParent();
                while (p != null) {
                    if (p instanceof BNiagaraNetwork) {
                        niagaraNetwork = (BNiagaraNetwork)p;
                        break;
                    }
                    p = p.getParent();
                }
            }
            boolean removeProvManager = true;
            if (niagaraNetwork != null && niagaraNetwork.isMounted()) {
                try {
                    Type provNetExtType = Sys.getType((String)"provisioningNiagara:ProvisioningNiagaraNetworkExt");
                    niagaraNetwork.lease();
                    SlotCursor cursor = niagaraNetwork.getProperties();
                    while (cursor.nextComponent()) {
                        if (!cursor.get().getType().is(provNetExtType)) continue;
                        removeProvManager = false;
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (removeProvManager) {
                result.remove(ixProvisioningManager);
            } else {
                int ixStationManager = result.indexOf("niagaraDriver:StationManager");
                if (ixProvisioningManager < ixStationManager) {
                    result.swap(ixProvisioningManager, ixStationManager);
                }
            }
        }
        return result;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stations = null;
    }

    public BNiagaraNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$BNiagaraNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$nd$BNiagaraNetwork = BNiagaraNetwork.class("[Lcom.tridium.nd.BNiagaraNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE, BINiagaraNetwork.TYPE};
        BFoxChannelRegistry.getPrototype().add("point", (BValue)new BPointChannel());
        BFoxChannelRegistry.getPrototype().add("schedule", (BValue)new BScheduleChannel());
        BFoxChannelRegistry.getPrototype().add("alarm", (BValue)new BAlarmChannel());
        BFoxChannelRegistry.getPrototype().add("history", (BValue)new BHistoryChannel());
        BFoxChannelRegistry.getPrototype().add("archive", (BValue)new BArchiveChannel());
        BFoxChannelRegistry.getPrototype().add("usersync", (BValue)new BUserSyncChannel());
        BFoxChannelRegistry.getPrototype().add("niagaraVirtual", (BValue)new BNiagaraVirtualChannel());
        BFoxChannelRegistry.getPrototype().add("sysdef", (BValue)new BSysDefChannel());
        log = Log.getLog((String)"niagaraDriver");
    }
}

