/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.spy.SpyCyclicThreadPoolWorker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCyclicThreadPoolWorker
extends BThreadPoolWorker
implements Runnable {
    public static final Type TYPE;
    private static boolean spyWorkEnabled;
    private static long spyWorkLimit;
    private static boolean spyWorkStackTracesEnabled;
    Hashtable registeredObjects;
    String threadNamePrefix;
    ThreadGroup threadGroup;
    int queueSize;
    ThreadPoolWorker worker;
    Queue queue;
    boolean isAlive;
    Thread cycleMonitor;
    long lastScanTicks;
    long minScanTicks;
    long maxScanTicks;
    long sumScanTicks;
    long numScans;
    long lastSleepTicks;
    long sumSleepTicks;
    int maxWorkInQueue;
    private Map spyWorkMap;
    private volatile long maxWorkTime;
    private volatile long minWorkTime;
    private volatile String maxWorkName;
    static /* synthetic */ Class class$com$tridium$nd$BCyclicThreadPoolWorker;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void register(Object work, long cycleTime) {
        Hashtable hashtable = this.registeredObjects;
        synchronized (hashtable) {
            RegisteredObjectInfo info;
            block5: {
                if (this.worker == null) {
                    this.queue = this.queueSize > 0 ? new CoalesceQueue(this.queueSize) : new CoalesceQueue();
                }
                break block5;
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
                this.worker.setMaxThreads(this.getMaxThreads());
                ThreadGroup tGroup = this.threadGroup != null ? this.threadGroup : Thread.currentThread().getThreadGroup();
                this.worker.start(tGroup, this.getWorkerThreadName());
                this.isAlive = true;
                this.cycleMonitor = new Thread(tGroup, this, this.getWorkerThreadName() + "_CycleMonitor");
                this.cycleMonitor.start();
            }
            if (work instanceof Runnable) {
                work = this.findWork((Runnable)work);
            }
            info = (info = (RegisteredObjectInfo)this.registeredObjects.remove(work)) == null ? new RegisteredObjectInfo(cycleTime) : new RegisteredObjectInfo(cycleTime, info.lastExecuteTicks);
            this.registeredObjects.put(work, info);
            this.registeredObjects.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unregister(Object work) {
        Hashtable hashtable = this.registeredObjects;
        synchronized (hashtable) {
            block9: {
                block10: {
                    if (work instanceof Runnable) {
                        work = this.findWork((Runnable)work);
                    }
                    this.registeredObjects.remove(work);
                    if (!this.registeredObjects.isEmpty()) break block9;
                    this.isAlive = false;
                    if (this.cycleMonitor != null) {
                        this.cycleMonitor.interrupt();
                    }
                    this.cycleMonitor = null;
                    if (this.worker == null) break block10;
                    try {
                        this.worker.stop();
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        this.worker = null;
                        throw throwable;
                    }
                    {
                        Object var5_5 = null;
                        this.worker = null;
                    }
                }
                if (this.queue != null) {
                    this.queue.clear();
                }
                this.queue = null;
            }
            this.registeredObjects.notifyAll();
            return;
        }
    }

    private final Work findWork(Runnable runnable) {
        Enumeration keys = this.registeredObjects.keys();
        while (keys.hasMoreElements()) {
            Object obj = keys.nextElement();
            if (!(obj instanceof Work) || ((Work)obj).runnable != runnable) continue;
            return (Work)obj;
        }
        return new Work(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void process(Object work) {
        if (this.queue == null) throw new NotRunningException();
        if (spyWorkEnabled && work != null) {
            SpyWorkInfo info;
            Map map = this.spyWorkMap;
            synchronized (map) {
                String key = work.toString();
                info = (SpyWorkInfo)this.spyWorkMap.get(key);
                if (info == null) {
                    info = new SpyWorkInfo();
                    info.name = key;
                    if (spyWorkStackTracesEnabled) {
                        StringWriter out = new StringWriter();
                        new Exception().printStackTrace(new PrintWriter(out));
                        info.stackTrace = out.toString();
                    }
                    this.spyWorkMap.put(key, info);
                } else {
                    SpyWorkInfo spyWorkInfo = info;
                    spyWorkInfo.count = spyWorkInfo.count + 1L;
                    BAbsTime now = BAbsTime.now();
                    if (info.count > 1L) {
                        SpyWorkInfo spyWorkInfo2 = info;
                        spyWorkInfo2.totalMillisBtwnSubmits = spyWorkInfo2.totalMillisBtwnSubmits + (now.getMillis() - info.last.getMillis());
                    }
                    info.last = now;
                }
            }
            if (work instanceof Runnable) {
                work = work instanceof ICoalesceable ? new SpyWorkWrapperCoaleasable((Runnable)work, info) : new SpyWorkWrapper((Runnable)work, info);
            }
        }
        this.queue.enqueue(work);
        this.maxWorkInQueue = Math.max(this.maxWorkInQueue, this.queue.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        Hashtable hashtable = this.registeredObjects;
        synchronized (hashtable) {
            while (this.isAlive) {
                try {
                    long sleepTime;
                    long scanStartTicks;
                    block16: {
                        scanStartTicks = Clock.ticks();
                        sleepTime = -1;
                        Enumeration keys = this.registeredObjects.keys();
                        long minCycleTicks = 100L;
                        while (true) {
                            if (!keys.hasMoreElements()) {
                                if (sleepTime >= 0L) break;
                                sleepTime = minCycleTicks;
                                break block16;
                            }
                            Object obj = keys.nextElement();
                            RegisteredObjectInfo info = (RegisteredObjectInfo)this.registeredObjects.get(obj);
                            if (info.cycleTime <= 0L) continue;
                            minCycleTicks = Math.min(info.cycleTime, minCycleTicks);
                            long lastExecute = info.lastExecuteTicks;
                            boolean isWork = obj instanceof Work;
                            if (isWork) {
                                Work work = (Work)obj;
                                if (work.alive) continue;
                                lastExecute = work.lastExecuteTicks;
                            }
                            long currentTicks = Clock.ticks();
                            if (lastExecute < 0L || currentTicks - lastExecute >= info.cycleTime) {
                                this.process(obj);
                                info.lastExecuteTicks = currentTicks;
                            }
                            long ticksTillNextExecute = info.lastExecuteTicks + info.cycleTime - currentTicks;
                            if (sleepTime < 0L) {
                                sleepTime = ticksTillNextExecute;
                                continue;
                            }
                            sleepTime = Math.min(sleepTime, ticksTillNextExecute);
                        }
                        if (sleepTime < 100L) {
                            sleepTime = 100L;
                        }
                    }
                    this.lastScanTicks = Clock.ticks() - scanStartTicks;
                    this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                    this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                    this.sumScanTicks += this.lastScanTicks;
                    this.lastSleepTicks = sleepTime;
                    this.sumSleepTicks += this.lastSleepTicks;
                    ++this.numScans;
                    this.registeredObjects.wait(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }
    }

    public Worker getWorker() {
        return this.worker;
    }

    protected void startWorker() {
    }

    protected void stopWorker() {
    }

    protected String getWorkerThreadName() {
        if (this.threadNamePrefix != null) {
            return this.threadNamePrefix;
        }
        return super.getWorkerThreadName();
    }

    public void spy(SpyWriter out) throws Exception {
        new SpyCyclicThreadPoolWorker((BNiagaraNetwork)this.getParent()).write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spyRegisteredOverview(SpyWriter out) throws Exception {
        Hashtable hashtable = this.registeredObjects;
        synchronized (hashtable) {
            double avgScan;
            out.startProps();
            out.trTitle((Object)"CyclicThreadPoolWorker", 2);
            int size = this.registeredObjects.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.queue != null) {
                n = this.queue.size();
            }
            out.prop((Object)"WorkWaitingInQueue", (Object)stringBuffer.append(n).toString());
            out.prop((Object)"MaxWorkWaitingInQueue", (Object)("" + this.maxWorkInQueue));
            out.prop((Object)"RegisteredObjects", (Object)(size + " (see table below for complete listing)"));
            out.prop((Object)"ScansCompleted", (Object)("" + this.numScans));
            out.prop((Object)"LastScanTicks", (Object)(this.lastScanTicks + " ms"));
            out.prop((Object)"MinScanTicks", (Object)(this.minScanTicks + " ms"));
            out.prop((Object)"MaxScanTicks", (Object)(this.maxScanTicks + " ms"));
            if (this.numScans > 0L) {
                avgScan = (double)this.sumScanTicks / (double)this.numScans;
                out.prop((Object)"AvgScanTicks", (Object)(avgScan + " ms"));
            }
            out.prop((Object)"LastSleepTicks", (Object)(this.lastSleepTicks + " ms"));
            if (this.numScans > 0L) {
                avgScan = (double)this.sumSleepTicks / (double)this.numScans;
                out.prop((Object)"AvgSleepTicks", (Object)(avgScan + " ms"));
            }
            out.endProps();
            return;
        }
    }

    public void spyRegisteredObjects(SpyWriter out) throws Exception {
        int size = this.registeredObjects.size();
        if (size > 0) {
            out.startTable(true);
            out.trTitle((Object)("Registered Objects: " + BAbsTime.make()), 6);
            out.w((Object)"<tr>").th((Object)"Object").th((Object)"CycleTime").th((Object)"LastCycleExecute").th((Object)"alive").th((Object)"lastWorkExecute").th((Object)"ticksBtwnExecutes").w((Object)"</tr>\n");
            Enumeration keys = this.registeredObjects.keys();
            BAbsTime now = BAbsTime.now();
            long nowTicks = Clock.ticks();
            BFacets showMillis = BFacets.make((String)"showMilliseconds", (boolean)true);
            while (keys.hasMoreElements()) {
                Object obj = keys.nextElement();
                boolean isWork = obj instanceof Work;
                Work w = isWork ? (Work)obj : null;
                RegisteredObjectInfo info = (RegisteredObjectInfo)this.registeredObjects.get(obj);
                out.tr((Object)obj.toString(), (Object)(info.cycleTime > 0L ? info.cycleTime + " ms" : "n/a"), (Object)(info.cycleTime > 0L && info.lastExecuteTicks >= 0L ? BAbsTime.now().subtract(BRelTime.make((long)(Clock.ticks() - info.lastExecuteTicks))).toString((Context)showMillis) : "n/a"), (Object)(isWork ? "" + w.alive : "n/a"), (Object)(isWork && w.lastExecuteTicks >= 0L ? BAbsTime.now().subtract(BRelTime.make((long)(Clock.ticks() - w.lastExecuteTicks))).toString((Context)showMillis) : "n/a"), (Object)(isWork && w.ticksBetweenExecutes >= 0L ? "" + w.ticksBetweenExecutes : "n/a"));
            }
            out.endTable();
        }
    }

    public void spyWorker(SpyWriter out) throws Exception {
        super.spy(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spyWorkInfo(SpyWriter out) {
        out.startProps().prop((Object)"Spy Work: ", (Object)(spyWorkEnabled ? "Enabled" : "Disabled"));
        if (!spyWorkEnabled) {
            out.endProps();
            return;
        }
        out.prop((Object)"Spy Work Limit: ", (Object)String.valueOf(spyWorkLimit)).prop((Object)"Max Work Time: ", (Object)BRelTime.make((long)this.maxWorkTime)).prop((Object)"Min Work Time: ", (Object)BRelTime.make((long)this.minWorkTime)).prop((Object)"Max Work: ", (Object)this.maxWorkName).endProps();
        out.startTable(true);
        out.trTitle((Object)"Processed Work", 7);
        out.w((Object)"<tr>").thTitle((Object)"Index").thTitle((Object)"Name").thTitle((Object)"Count").thTitle((Object)"Last Submit").thTitle((Object)"Max").thTitle((Object)"Min").thTitle((Object)"Avg Millis Btwn Submits").w((Object)"</tr>");
        Map map = this.spyWorkMap;
        synchronized (map) {
            int index = 0;
            Iterator keys = this.spyWorkMap.keySet().iterator();
            while (keys.hasNext()) {
                ++index;
                String name = (String)keys.next();
                SpyWorkInfo info = (SpyWorkInfo)this.spyWorkMap.get(name);
                String nameHtml = name;
                if (spyWorkStackTracesEnabled) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("<a href='spy:/niagaraNetwork/").append("threadPoolWorker").append("/").append("work").append("/stack").append(index).append("'>").append(name).append("</a>");
                    nameHtml = buff.toString();
                }
                out.tr((Object)String.valueOf(index), (Object)nameHtml, (Object)String.valueOf(info.count), (Object)info.last.toTimeString((Context)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)), (Object)BRelTime.make((long)info.max), (Object)BRelTime.make((long)info.min), (Object)(info.count > 0L ? String.valueOf(info.totalMillisBtwnSubmits / info.count) : "-"));
            }
        }
        out.endTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spyWorkStackTrace(int index, SpyWriter out) {
        block4: {
            SpyWorkInfo info = null;
            Map map = this.spyWorkMap;
            synchronized (map) {
                if (spyWorkStackTracesEnabled && index <= this.spyWorkMap.size()) {
                    info = (SpyWorkInfo)this.spyWorkMap.values().toArray()[index - 1];
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var4_4
                if (info == null) break block4;
            }
            out.startProps().prop((Object)"Spy Work Name: ", (Object)info.name).endProps().w((Object)"<p>This is the stack trace when the Work was submitted. It's not an error...").w((Object)"<hr><pre>").w((Object)info.stackTrace).w((Object)"</pre>");
        }
    }

    static /* synthetic */ String access$3(BCyclicThreadPoolWorker bCyclicThreadPoolWorker) {
        return bCyclicThreadPoolWorker.maxWorkName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.registeredObjects = new Hashtable();
        this.queueSize = Integer.getInteger("niagara.network.workerPool.queueSize", 150000);
        this.lastScanTicks = 0L;
        this.minScanTicks = Long.MAX_VALUE;
        this.maxScanTicks = Long.MIN_VALUE;
        this.sumScanTicks = 0L;
        this.numScans = 0L;
        this.lastSleepTicks = 0L;
        this.sumSleepTicks = 0L;
        this.maxWorkInQueue = 0;
        this.spyWorkMap = spyWorkEnabled ? new SpyWorkMap() : null;
        this.maxWorkTime = 0L;
        this.minWorkTime = Long.MAX_VALUE;
        this.maxWorkName = " - ";
    }

    public BCyclicThreadPoolWorker() {
        this.this();
    }

    public BCyclicThreadPoolWorker(String threadNamePrefix, int maxThreads) {
        this(null, threadNamePrefix, maxThreads);
    }

    public BCyclicThreadPoolWorker(ThreadGroup threadGroup, String threadNamePrefix, int maxThreads) {
        super(maxThreads);
        this.this();
        this.threadGroup = threadGroup;
        this.threadNamePrefix = threadNamePrefix;
    }

    public BCyclicThreadPoolWorker(ThreadGroup threadGroup, String threadNamePrefix, int maxThreads, int queueSize) {
        this(threadGroup, threadNamePrefix, maxThreads);
        this.queueSize = queueSize;
    }

    static {
        Class clazz = class$com$tridium$nd$BCyclicThreadPoolWorker;
        if (clazz == null) {
            clazz = class$com$tridium$nd$BCyclicThreadPoolWorker = BCyclicThreadPoolWorker.class("[Lcom.tridium.nd.BCyclicThreadPoolWorker;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        spyWorkEnabled = Boolean.getBoolean("niagara.network.spywork");
        spyWorkLimit = Long.getLong("niagara.network.spywork.limit", 1000L);
        spyWorkStackTracesEnabled = Boolean.getBoolean("niagara.network.spywork.stacktrace");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RegisteredObjectInfo {
        long cycleTime;
        long lastExecuteTicks;

        private final /* synthetic */ void this() {
            this.lastExecuteTicks = -1;
        }

        RegisteredObjectInfo(long cycleTime) {
            this.this();
            this.cycleTime = cycleTime;
        }

        RegisteredObjectInfo(long cycleTime, long lastExecuteTicks) {
            this.this();
            this.cycleTime = cycleTime;
            this.lastExecuteTicks = lastExecuteTicks;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Work
    implements Runnable,
    ICoalesceable {
        Runnable runnable;
        volatile boolean alive;
        volatile long lastExecuteTicks;
        long ticksBetweenExecutes;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.alive = true;
                this.runnable.run();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.alive = false;
                long now = Clock.ticks();
                this.ticksBetweenExecutes = now - this.lastExecuteTicks;
                this.lastExecuteTicks = now;
                throw throwable;
            }
            {
                Object var2_3 = null;
                this.alive = false;
            }
            long now = Clock.ticks();
            this.ticksBetweenExecutes = now - this.lastExecuteTicks;
            this.lastExecuteTicks = now;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Work) {
                boolean bl = false;
                if (this.runnable == ((Work)obj).runnable) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public String toString() {
            return this.runnable.toString();
        }

        public Object getCoalesceKey() {
            return this.runnable;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        private final /* synthetic */ void this() {
            this.alive = false;
            this.lastExecuteTicks = -1;
            this.ticksBetweenExecutes = -1;
        }

        Work(Runnable runnable) {
            this.this();
            this.runnable = runnable;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class SpyWorkInfo {
        private String name;
        private long count;
        private BAbsTime last;
        private long totalMillisBtwnSubmits;
        private volatile long max;
        private volatile long min;
        private String stackTrace;

        private final /* synthetic */ void this() {
            this.count = 0L;
            this.last = BAbsTime.now();
            this.totalMillisBtwnSubmits = 0L;
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.stackTrace = "";
        }

        private SpyWorkInfo() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SpyWorkWrapperCoaleasable
    extends SpyWorkWrapper
    implements ICoalesceable {
        public Object getCoalesceKey() {
            return this.asCoalesceable().getCoalesceKey();
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return this.asCoalesceable().coalesce(c);
        }

        private final ICoalesceable asCoalesceable() {
            return (ICoalesceable)this.r;
        }

        private SpyWorkWrapperCoaleasable(Runnable r, SpyWorkInfo info) {
            super(r, info);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SpyWorkWrapper
    implements Runnable {
        protected Runnable r;
        private SpyWorkInfo info;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long t0 = Clock.ticks();
            try {
                this.r.run();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                long t = Clock.ticks() - t0;
                if (t > this.info.max) {
                    this.info.max = t;
                }
                if (t < this.info.min) {
                    this.info.min = t;
                }
                if (t > BCyclicThreadPoolWorker.this.maxWorkTime) {
                    BCyclicThreadPoolWorker.this.maxWorkTime = t;
                    BCyclicThreadPoolWorker.this.maxWorkName = this.r.toString();
                }
                if (t >= BCyclicThreadPoolWorker.this.minWorkTime) throw throwable;
                BCyclicThreadPoolWorker.this.minWorkTime = t;
                throw throwable;
            }
            {
                Object var4_4 = null;
            }
            long t = Clock.ticks() - t0;
            if (t > this.info.max) {
                this.info.max = t;
            }
            if (t < this.info.min) {
                this.info.min = t;
            }
            if (t > BCyclicThreadPoolWorker.this.maxWorkTime) {
                BCyclicThreadPoolWorker.this.maxWorkTime = t;
                BCyclicThreadPoolWorker.this.maxWorkName = this.r.toString();
            }
            if (t >= BCyclicThreadPoolWorker.this.minWorkTime) return;
            BCyclicThreadPoolWorker.this.minWorkTime = t;
        }

        public String toString() {
            return this.r.toString();
        }

        public int hashCode() {
            return this.r.hashCode();
        }

        public boolean equals(Object arg) {
            if (arg == null) {
                return false;
            }
            if (this.r == null) {
                return false;
            }
            return this.r.equals(arg);
        }

        private SpyWorkWrapper(Runnable r, SpyWorkInfo info) {
            this.r = r;
            this.info = info;
        }
    }

    private static class SpyWorkMap
    extends LinkedHashMap {
        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean bl = false;
            if ((long)this.size() > spyWorkLimit) {
                bl = true;
            }
            return bl;
        }

        private SpyWorkMap() {
        }
    }
}

