/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.test;

import com.tridium.js.test.BTestJs;
import java.io.File;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public class BJasmineTest
extends BTestJs {
    public static final Type TYPE = Sys.loadType(BJasmineTest.class);
    private volatile boolean testPassed = false;

    public Type getType() {
        return TYPE;
    }

    protected void setupJasmine() throws Exception {
        String string = Sys.getBajaHome().getAbsolutePath().replace("\\", "/") + "/reports/testng/junitreports/";
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("JUnit reports directory " + string + "does not exist. Creating...");
            file.mkdirs();
        }
        this.runJs(BOrd.make((String)"module://rhino/com/tridium/js/test/rhinoFakeBrowser.js"));
        this.runJs(BOrd.make((String)"module://js/com/tridium/js/ext/jasmine/jasmine.js"));
        if (file.exists()) {
            System.out.println("Exporting Jasmine -> JUnit test results to " + string);
            this.runJs(BOrd.make((String)"module://rhino/com/tridium/js/test/jasmine-reporters/jasmine.junit_reporter.js"));
            String string2 = "jasmine.getEnv().addReporter(new jasmine.JUnitXmlReporter('" + string + "', true, true));";
            this.runJs(string2, "set up junit reporter");
        } else {
            System.out.println("No test reports directory at " + string + ". Jasmine -> JUnit test results will not be exported.");
        }
        this.runJs(BOrd.make((String)"module://rhino/com/tridium/js/test/rhinoRunJasmine.js"));
        this.getExecutor().waitToBeEmpty();
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.testPassed = false;
        this.setupJasmine();
    }

    protected void runJasmineTests(String string, BOrd ... bOrdArray) throws Exception {
        for (BOrd bOrd : bOrdArray) {
            this.runJs(bOrd);
        }
        this.runJs(string, "Run Jasmine Test");
        this.getExecutor().waitToBeEmpty();
        Assert.assertTrue((boolean)this.isTestPassed(), (String)"rhinoRunJasmine.js did not call test.passTest()");
    }

    protected void runJasmineTests(BOrd ... bOrdArray) throws Exception {
        this.runJasmineTests("rhinoRunJasmine();", bOrdArray);
    }

    public final void passTest() {
        this.testPassed = true;
    }

    public final boolean isTestPassed() {
        return this.testPassed;
    }
}

