/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.rhino;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class JavaScriptSession {
    private Context cx;
    private Scriptable scope;

    private JavaScriptSession() {
    }

    public static JavaScriptSession make() {
        return new JavaScriptSession();
    }

    public void start() {
        this.cx = Context.enter();
        this.cx.setOptimizationLevel(-1);
        this.scope = this.cx.initStandardObjects();
    }

    public void stop() {
        Context.exit();
        this.cx = null;
        this.scope = null;
    }

    public final void runJs(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        this.runJs(bufferedReader, file.getName());
    }

    public final void runJs(BIFile bIFile) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
        this.runJs(bufferedReader, bIFile.getFileName());
    }

    public final void runJs(BOrd bOrd) throws IOException {
        this.runJs((BIFile)bOrd.get());
    }

    public final void runJs(String string, String string2) throws IOException {
        if (this.cx == null) {
            throw new IllegalStateException("Must call start()");
        }
        this.cx.evaluateString(this.scope, string, string2, 1, null);
    }

    public final void runJs(Reader reader, String string) throws IOException {
        if (this.cx == null) {
            throw new IllegalStateException("Must call start()");
        }
        this.cx.evaluateReader(this.scope, reader, string, 1, null);
    }

    public final void addJavaToJsProp(String string, Object object) {
        if (this.cx == null) {
            throw new IllegalStateException("Must call start()");
        }
        ScriptableObject.putProperty(this.scope, string, Context.javaToJS(object, this.scope));
    }

    public final void addJavaClsToJs(Class clazz) {
        if (this.cx == null) {
            throw new IllegalStateException("Must call start()");
        }
        NativeJavaClass nativeJavaClass = new NativeJavaClass(this.scope, clazz);
        ScriptableObject.putProperty(this.scope, clazz.getSimpleName(), (Object)nativeJavaClass);
    }

    public final Object toObject(Object object) {
        return Context.toObject(object, this.scope);
    }

    public final void addJavaMethodToJs(Method method) {
        this.addJavaToJsProp(method.getName(), new FunctionObject(method.getName(), method, this.scope));
    }

    public final Context getContext() {
        return this.cx;
    }

    public final Scriptable getScope() {
        return this.scope;
    }
}

