/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusAsync.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusAsync.BModbusAsyncNetwork;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Clock;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusAsyncRxDriver
extends CommReceiver {
    protected static final int IDLE = 0;
    protected static final int READ_DATA = 1;
    protected static final int WAIT_FOR_FRAME_START = 2;
    protected static String RTU_PARTIAL_MESSAGE = "RTU (client) partial message received ";
    protected static String ASCII_PARTIAL_MESSAGE = "ASCII (client) partial message received ";
    private Log rxLog;
    private BModbusAsyncNetwork network;
    private int responseSize;
    private int snifferResponseSize;
    private int rcvCount;
    private int frameStart;
    private int comType;
    private int state;
    private ByteBuffer rcvBuffer;
    private ModbusReceivedMessage msg;
    long rxCharTicks;

    protected ReceivedMessage receive() throws Exception {
        this.rcvCount = 0;
        this.rcvBuffer.reset();
        boolean bl = false;
        while (!bl) {
            int n = this.getInputStream().read();
            if (n != -1) {
                this.rxCharTicks = Clock.ticks();
                if (this.state == 0) continue;
                this.logTrace("Received char: 0x" + Integer.toHexString(n));
                if (this.comType == 0) {
                    bl = this.processASCIICharacter(n);
                    continue;
                }
                bl = this.processRTUCharacter(n);
                continue;
            }
            long l = Clock.ticks();
            long l2 = l - this.rxCharTicks;
            long l3 = this.network.getMaxRxInterCharacterDelay().getMillis();
            if (l3 == 0L) {
                this.logTrace("Not checking inter-char timing.");
                l3 = -1;
            }
            String string = RTU_PARTIAL_MESSAGE;
            if (this.isAsciiProtocol() && l3 > 0L) {
                l3 = 1000L;
                string = ASCII_PARTIAL_MESSAGE;
            }
            if (this.rcvCount <= 0 || l3 <= 0L || l2 <= l3) continue;
            this.network.incrementPartialRxMsgs();
            this.rxLog.message(string + ByteArrayUtil.toHexString((byte[])this.rcvBuffer.toByteArray()));
            if (this.rxCharTicks > 0L) {
                this.rxLog.message(" character deltaT = " + l2 + ", expected: " + this.responseSize + ", received: " + this.rcvCount);
            }
            this.rxCharTicks = l;
            this.rcvCount = 0;
            this.state = 0;
        }
        if (this.msg == null) {
            this.msg = new ModbusReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength());
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
        }
        return this.msg;
    }

    private final boolean processRTUCharacter(int n) {
        byte by = (byte)(n & 0xFF);
        if (this.network.getSnifferMode()) {
            if (this.snifferResponseSize == 0) {
                this.snifferResponseSize = this.network.getRtuSnifferModeBufferSize();
            }
            this.rcvBuffer.write((int)by);
            --this.snifferResponseSize;
            if (this.snifferResponseSize == 0) {
                return true;
            }
        } else {
            switch (this.state) {
                case 2: {
                    if (n != this.frameStart) {
                        this.logTrace("ModbusAsyncRxDriver received unexpected character: " + Integer.toString(n, 16));
                        break;
                    }
                    this.state = 1;
                }
                case 1: {
                    this.rcvBuffer.write((int)by);
                    boolean bl = false;
                    if (this.rcvCount == 1) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (n > 127) {
                        bl2 = true;
                    }
                    if (bl & bl2) {
                        this.responseSize = 4;
                    }
                    ++this.rcvCount;
                    --this.responseSize;
                    this.rxLog.trace("rc= " + this.rcvCount + " rs= " + this.responseSize);
                    if (this.responseSize != 0) break;
                    this.logTrace("messageReceived: " + ByteArrayUtil.toHexString((byte[])this.rcvBuffer.toByteArray()));
                    this.state = 0;
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean processASCIICharacter(int n) {
        byte by = (byte)(n & 0xFF);
        switch (this.state) {
            case 2: {
                if (n != 58) break;
                this.state = 1;
                this.rcvBuffer.write((int)by);
                this.rcvCount = 1;
                break;
            }
            case 1: {
                if (n == 58) {
                    this.rxLog.message(ASCII_PARTIAL_MESSAGE + new String(this.rcvBuffer.toByteArray()));
                    this.rcvCount = 0;
                    this.rcvBuffer.reset();
                }
                this.rcvBuffer.write((int)by);
                ++this.rcvCount;
                if (n != 10) break;
                this.logTrace("Message received: " + new String(this.rcvBuffer.toByteArray()));
                this.state = 0;
                return true;
            }
        }
        return false;
    }

    public void setFrameStart(int n) {
        this.state = 0;
        while (this.isRxInProcess()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.frameStart = n;
        this.rcvCount = 0;
        this.rcvBuffer.reset();
        boolean bl = false;
        this.state = 2;
    }

    public boolean isRxInProcess() {
        long l = this.network.getMinRxFrameEnd().getMillis();
        boolean bl = false;
        if (Clock.ticks() - this.rxCharTicks < l) {
            bl = true;
        }
        return bl;
    }

    public void setComType(int n) {
        this.comType = n;
    }

    public void setResponseSize(int n) {
        this.responseSize = n;
    }

    protected boolean isAsciiProtocol() {
        boolean bl = false;
        if (this.comType == 0) {
            bl = true;
        }
        return bl;
    }

    private final void logTrace(String string) {
        if (this.network.getModbusLog().isTraceOn()) {
            this.network.getModbusLog().trace(string);
        } else if (this.rxLog.isTraceOn()) {
            this.rxLog.trace(string);
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.snifferResponseSize = 0;
        this.state = 2;
        this.rcvBuffer = new ByteBuffer();
        this.msg = null;
        this.rxCharTicks = 0L;
    }

    public ModbusAsyncRxDriver(BModbusAsyncNetwork bModbusAsyncNetwork) {
        String string;
        this.this();
        this.network = bModbusAsyncNetwork;
        if (bModbusAsyncNetwork == null) {
            this.rxLog = Log.getLog((String)"modbusAsync.rx");
        }
        if (!SlotPath.isValidName((String)(string = bModbusAsyncNetwork.getName() + '_' + bModbusAsyncNetwork.getSerialPortConfig().getPortName() + "_rx"))) {
            string = SlotPath.escape((String)string);
        }
        this.rxLog = Log.getLog((String)string);
    }
}

