/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusAsync;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusAsync.BModbusAsyncDevice;
import com.tridium.modbusAsync.BModbusAsyncDeviceFolder;
import com.tridium.modbusAsync.comm.ModbusAsyncSerialComm;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.enums.BModbusDataModeEnum;
import com.tridium.modbusCore.messages.ModbusMessage;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusAsyncNetwork
extends BModbusClientNetwork
implements BISerialHelperParent {
    public static final Property interMessageDelay = BModbusAsyncNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property maxRxInterCharacterDelay = BModbusAsyncNetwork.newProperty((int)4, (BValue)BRelTime.make((long)50L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property minRxFrameEnd = BModbusAsyncNetwork.newProperty((int)4, (BValue)BRelTime.make((long)20L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property rxPriority = BModbusAsyncNetwork.newProperty((int)4, (boolean)false, null);
    public static final Property serialPortConfig = BModbusAsyncNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property modbusDataMode = BModbusAsyncNetwork.newProperty((int)0, (BValue)BModbusDataModeEnum.rtu, null);
    public static final Property snifferMode = BModbusAsyncNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property rtuSnifferModeBufferSize = BModbusAsyncNetwork.newProperty((int)0, (int)8, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    public static final Type TYPE;
    private Log log;
    private boolean commActive;
    private boolean networkInitialized;
    static /* synthetic */ Class class$com$tridium$modbusAsync$BModbusAsyncNetwork;

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BRelTime getMaxRxInterCharacterDelay() {
        return (BRelTime)this.get(maxRxInterCharacterDelay);
    }

    public void setMaxRxInterCharacterDelay(BRelTime bRelTime) {
        this.set(maxRxInterCharacterDelay, (BValue)bRelTime, null);
    }

    public BRelTime getMinRxFrameEnd() {
        return (BRelTime)this.get(minRxFrameEnd);
    }

    public void setMinRxFrameEnd(BRelTime bRelTime) {
        this.set(minRxFrameEnd, (BValue)bRelTime, null);
    }

    public boolean getRxPriority() {
        return this.getBoolean(rxPriority);
    }

    public void setRxPriority(boolean bl) {
        this.setBoolean(rxPriority, bl, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public BModbusDataModeEnum getModbusDataMode() {
        return (BModbusDataModeEnum)this.get(modbusDataMode);
    }

    public void setModbusDataMode(BModbusDataModeEnum bModbusDataModeEnum) {
        this.set(modbusDataMode, (BValue)bModbusDataModeEnum, null);
    }

    public boolean getSnifferMode() {
        return this.getBoolean(snifferMode);
    }

    public void setSnifferMode(boolean bl) {
        this.setBoolean(snifferMode, bl, null);
    }

    public int getRtuSnifferModeBufferSize() {
        return this.getInt(rtuSnifferModeBufferSize);
    }

    public void setRtuSnifferModeBufferSize(int n) {
        this.setInt(rtuSnifferModeBufferSize, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        Thread thread;
        Comm comm;
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)rxPriority) && (comm = this.getComm()) instanceof ModbusAsyncSerialComm && (thread = ((ModbusAsyncSerialComm)comm).getRxThread()) != null) {
            if (this.getRxPriority()) {
                thread.setPriority(7);
            } else {
                thread.setPriority(5);
            }
        }
    }

    public Type getDeviceType() {
        return BModbusAsyncDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BModbusAsyncDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "modbusAsync");
    }

    public int getModbusMode() {
        return this.getModbusDataMode().getOrdinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getNameSubscriber().subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log = this.log;
        synchronized (log) {
            this.log = this.getLog();
            return;
        }
    }

    public void startComm() throws Exception {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            this.configFail("No port selected for Modbus communication.");
        } else {
            try {
                super.startComm();
            }
            catch (Exception exception) {
                this.configFail("Could not enable Modbus serial communication (" + exception + ')');
                throw exception;
            }
            this.configOk();
        }
        if (!(this.isDisabled() || this.isDown() || this.isFault())) {
            if (this.getModbusLog().isTraceOn()) {
                this.getModbusLog().trace("*** Starting serial comm for " + this.getName() + " ***");
            }
            if (!this.initializeNetwork()) {
                this.getModbusLog().warning("Unable to initialize network " + this.getName() + "!!");
            }
        }
    }

    public Log getLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        return Log.getLog((String)string);
    }

    protected Comm makeComm() {
        return new ModbusAsyncSerialComm(this);
    }

    public void stopComm() throws Exception {
        super.stopComm();
        this.commActive = false;
        this.networkInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        Log log = Log.getLog((String)string);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log2 = this.log;
        synchronized (log2) {
            if (this.log != null) {
                log.setSeverity(this.log.getSeverity());
                if (!log.getLogName().equals(this.log.getLogName())) {
                    Log.deleteLog((String)this.log.getLogName());
                }
            }
            this.log = log;
        }
        super.updateLog();
    }

    public void reopenPort() {
        try {
            String string = this.getSerialPortConfig().getPortName();
            if (string.equals("none")) {
                this.configFail("No port selected for Modbus communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception exception) {
            this.getLog().error("BModbusAsyncNetwork caught exception in reopenPort(): ", (Throwable)exception);
        }
    }

    private final void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log.isTraceOn()) {
                this.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    private final boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            this.getModbusLog().warning("Unable to start Serial Comm for " + this.getName());
            this.commActive = false;
            return false;
        }
        try {
            ((ModbusAsyncSerialComm)this.getComm()).getSerialPort().enableReceiveThreshold(1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.getModbusLog().error(this.getName() + ", ModbusAsyncSerialComm: Unable to perform enableReceiveThreshold = 1.  Exception- ", (Throwable)unsupportedOperationException);
        }
        this.networkInitialized = true;
        return true;
    }

    public boolean isCommActive() {
        boolean bl = false;
        if (this.commActive && super.isCommActive()) {
            bl = true;
        }
        return bl;
    }

    public Message sendSync(Message message, BRelTime bRelTime, int n) {
        if (this.getSnifferMode() || !this.isCommActive()) {
            return null;
        }
        Message message2 = super.sendSync(message, bRelTime, n);
        try {
            BModbusClientDevice bModbusClientDevice = this.findDeviceInNetwork(((ModbusMessage)message).deviceAddress);
            if (bModbusClientDevice != null) {
                if (message2 != null) {
                    bModbusClientDevice.pingOk();
                    bModbusClientDevice.resetPingsFailed();
                } else if (bModbusClientDevice.incrementPingsFailed() > this.getMaxFailsUntilDeviceDown()) {
                    bModbusClientDevice.pingFail(this.getLexicon().getText("pingFail"));
                }
            }
        }
        catch (Exception exception) {}
        return message2;
    }

    protected void processNameSubscriberEvent(BComponentEvent bComponentEvent) {
        super.processNameSubscriberEvent(bComponentEvent);
        try {
            if (bComponentEvent.getId() == 0 && bComponentEvent.getSlot().equals((Object)BSerialHelper.portName)) {
                this.updateLog();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = null;
        this.commActive = false;
        this.networkInitialized = false;
    }

    public BModbusAsyncNetwork() {
        this.this();
        this.setResponseTimeout(BRelTime.make((long)1000L));
    }

    static {
        Class clazz = class$com$tridium$modbusAsync$BModbusAsyncNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$modbusAsync$BModbusAsyncNetwork = BModbusAsyncNetwork.class("[Lcom.tridium.modbusAsync.BModbusAsyncNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

