/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.EmailUtil;
import javax.baja.data.BIDataValue;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailService;
import javax.baja.email.BStore;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIncomingAccount
extends BEmailAccount {
    public static final Property port = BIncomingAccount.newProperty((int)0, (int)110, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property store = BIncomingAccount.newProperty((int)0, (BValue)BStore.pop3, null);
    public static final Property deliveryPolicy = BIncomingAccount.newProperty((int)0, (BValue)BDeliveryPolicy.delete, null);
    public static final Topic received = BIncomingAccount.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$email$BIncomingAccount;

    public BStore getStore() {
        return (BStore)this.get(store);
    }

    public void setStore(BStore bStore) {
        this.set(store, (BValue)bStore, null);
    }

    public BDeliveryPolicy getDeliveryPolicy() {
        return (BDeliveryPolicy)this.get(deliveryPolicy);
    }

    public void setDeliveryPolicy(BDeliveryPolicy bDeliveryPolicy) {
        this.set(deliveryPolicy, (BValue)bDeliveryPolicy, null);
    }

    public void fireReceived(BEmail bEmail) {
        this.fire(received, (BValue)bEmail, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void poll() throws Exception {
        Folder folder = this.getInbox();
        folder.open(2);
        if (folder.getMessageCount() == 0) {
            folder.close(false);
            return;
        }
        BEmailService.log.trace("BIncomingAccount just received " + folder.getMessageCount() + " email(s).");
        Message[] messageArray = folder.getMessages();
        FetchProfile fetchProfile = new FetchProfile();
        fetchProfile.add(FetchProfile.Item.ENVELOPE);
        fetchProfile.add(FetchProfile.Item.FLAGS);
        fetchProfile.add("X-Mailer");
        folder.fetch(messageArray, fetchProfile);
        int n = 0;
        while (n < messageArray.length) {
            Message message;
            block11: {
                message = messageArray[n];
                String string = "?";
                try {
                    string = message.getSubject();
                    BEmail bEmail = EmailUtil.fromMessage(message);
                    this.fireReceived(bEmail);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BEmailService bEmailService = this.getService();
                    if (bEmailService == null) break block11;
                    BEmailService.log.error("BIncomingAccount could not process message: " + string, (Throwable)exception);
                }
            }
            if (this.getDeliveryPolicy() == BDeliveryPolicy.delete) {
                message.setFlag(Flags.Flag.DELETED, true);
            } else if (this.getDeliveryPolicy() == BDeliveryPolicy.markAsRead) {
                message.setFlag(Flags.Flag.SEEN, true);
            } else if (this.getDeliveryPolicy() == BDeliveryPolicy.markAsUnread) {
                message.setFlag(Flags.Flag.SEEN, false);
            }
            ++n;
        }
        if (this.getDeliveryPolicy() == BDeliveryPolicy.delete) {
            folder.close(true);
        } else {
            folder.close(false);
        }
    }

    private final Folder getInbox() throws Exception {
        Session session = this.mailPlatformHandler.getIncomingSession(this, this.store());
        Store store = session.getStore(this.store());
        store.connect();
        Folder folder = store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default mail folder");
        }
        if ((folder = folder.getFolder("INBOX")) == null) {
            throw new IllegalStateException("No inbox folder.");
        }
        return folder;
    }

    private final String store() {
        switch (this.getStore().getOrdinal()) {
            case 0: {
                return "pop3";
            }
            case 1: {
                return "imap";
            }
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$email$BIncomingAccount;
        if (clazz == null) {
            clazz = class$javax$baja$email$BIncomingAccount = BIncomingAccount.class("[Ljavax.baja.email.BIncomingAccount;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"inbox.png");
    }
}

