/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.mail.internet.InternetAddress;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BEmailAddress
extends BSimple
implements BIValidator {
    public static final BEmailAddress DEFAULT;
    public static final BEmailAddress NULL;
    public static final Type TYPE;
    private String address;
    private String personal;
    static /* synthetic */ Class class$javax$baja$email$BEmailAddress;

    public static final BEmailAddress make(String string, String string2) {
        return new BEmailAddress(string, string2);
    }

    public static final BEmailAddress make(String string) {
        return new BEmailAddress(string, null);
    }

    public final String getAddress() {
        return this.address;
    }

    public final String getPersonal() {
        return this.personal;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL || (this.personal == null || this.personal.length() == 0) && (this.address == null || this.address.length() == 0)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        if (this.personal != null && this.address != null) {
            return this.address.hashCode() ^ this.personal.hashCode();
        }
        if (this.address != null) {
            return this.address.hashCode();
        }
        if (this.personal != null) {
            return this.personal.hashCode();
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (object instanceof BEmailAddress) {
            BEmailAddress bEmailAddress = (BEmailAddress)((Object)object);
            if (this.address == null && bEmailAddress.address != null) {
                return false;
            }
            if (this.address != null && bEmailAddress.address == null) {
                return false;
            }
            if (this.address != null && !this.address.equals(bEmailAddress.address)) {
                return false;
            }
            if (this.personal == null && bEmailAddress.personal != null) {
                return false;
            }
            if (this.personal != null && bEmailAddress.personal == null) {
                return false;
            }
            return this.personal == null || this.personal.equals(bEmailAddress.personal);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.isNull()) {
            return "";
        }
        if (this.address == null && this.personal == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.address);
        if (this.personal != null) {
            stringBuffer.append('|').append(this.personal);
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string == null) {
            return NULL;
        }
        if (string.equals("")) {
            return NULL;
        }
        int n = string.indexOf(124);
        if (n == -1) {
            return BEmailAddress.make(string);
        }
        return BEmailAddress.make(string.substring(0, n), string.substring(n + 1));
    }

    public final void validate(BObject bObject, Context context) throws CannotValidateException {
        BEmailAddress bEmailAddress = (BEmailAddress)bObject;
        if (bEmailAddress.getAddress() == null || bEmailAddress.getAddress().length() == 0) {
            return;
        }
        InternetAddress internetAddress = new InternetAddress();
        try {
            internetAddress.setAddress(bEmailAddress.getAddress());
            internetAddress.setPersonal(bEmailAddress.getPersonal());
            internetAddress.validate();
        }
        catch (Exception exception) {
            throw new CannotValidateException(exception.getMessage(), (Throwable)exception);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public static final void main(String[] stringArray) throws Exception {
        BEmailAddress[] bEmailAddressArray = new BEmailAddress[]{BEmailAddress.make("a@b", "cdefg"), BEmailAddress.make("a@b", "cdefg"), BEmailAddress.make("a@b"), BEmailAddress.make("e@f"), BEmailAddress.make("e@f"), BEmailAddress.make(null, null), BEmailAddress.make(null), BEmailAddress.make("")};
        int n = 0;
        while (n < bEmailAddressArray.length) {
            int n2 = n + 1;
            while (n2 < bEmailAddressArray.length) {
                System.out.println((Object)((Object)bEmailAddressArray[n]) + ", " + (Object)((Object)bEmailAddressArray[n2]) + ", " + bEmailAddressArray[n].equals((Object)bEmailAddressArray[n2]));
                ++n2;
            }
            ++n;
        }
        System.out.println("---------------------------------------------");
        System.out.println(NULL.encodeToString());
        System.out.println(NULL.decodeFromString(""));
        System.out.println(NULL.decodeFromString("z@y|aaa"));
        System.out.println(NULL.decodeFromString("z@y"));
        System.out.println(NULL.decodeFromString("z@y|"));
        System.out.println(NULL.decodeFromString("|aaa"));
        System.out.println(NULL.decodeFromString("|"));
        System.out.println(NULL.decodeFromString(null));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BEmailAddress(String string, String string2) {
        if (string != null && (string.indexOf(124) != -1 || string.indexOf(59) != -1)) {
            throw new LocalizableRuntimeException("email", "illegalAddress", new Object[]{string});
        }
        if (string2 != null && (string2.indexOf(124) != -1 || string2.indexOf(59) != -1)) {
            throw new LocalizableRuntimeException("email", "illegalPersonalName", new Object[]{string2});
        }
        this.address = string == null ? null : string.trim();
        this.personal = string2;
    }

    static {
        NULL = DEFAULT = new BEmailAddress(null, null);
        Class clazz = class$javax$baja$email$BEmailAddress;
        if (clazz == null) {
            clazz = class$javax$baja$email$BEmailAddress = BEmailAddress.class("[Ljavax.baja.email.BEmailAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

