/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.MailPlatformHandler;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailService;
import javax.baja.security.BPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BEmailAccount
extends BComponent
implements BIStatus {
    public static final Property hostname = BEmailAccount.newProperty((int)0, (String)new String(), null);
    public static final Property port = BEmailAccount.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property account = BEmailAccount.newProperty((int)0, (String)new String(), null);
    public static final Property password = BEmailAccount.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property pollrate = BEmailAccount.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property enabled = BEmailAccount.newProperty((int)0, (boolean)true, null);
    public static final Property status = BEmailAccount.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property lastPollSuccess = BEmailAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastPollFailure = BEmailAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastPollFailureCause = BEmailAccount.newProperty((int)1, (String)"", null);
    public static final Property debug = BEmailAccount.newProperty((int)0, (boolean)false, null);
    public static final Property useSsl = BEmailAccount.newProperty((int)0, (boolean)false, null);
    public static final Property useStartTls = BEmailAccount.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static Context doNotChange;
    private Poller poller;
    protected MailPlatformHandler mailPlatformHandler;
    static /* synthetic */ Class class$javax$baja$email$BEmailAccount;

    public String getHostname() {
        return this.getString(hostname);
    }

    public void setHostname(String string) {
        this.setString(hostname, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public String getAccount() {
        return this.getString(account);
    }

    public void setAccount(String string) {
        this.setString(account, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BRelTime getPollrate() {
        return (BRelTime)this.get(pollrate);
    }

    public void setPollrate(BRelTime bRelTime) {
        this.set(pollrate, (BValue)bRelTime, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BAbsTime getLastPollSuccess() {
        return (BAbsTime)this.get(lastPollSuccess);
    }

    public void setLastPollSuccess(BAbsTime bAbsTime) {
        this.set(lastPollSuccess, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastPollFailure() {
        return (BAbsTime)this.get(lastPollFailure);
    }

    public void setLastPollFailure(BAbsTime bAbsTime) {
        this.set(lastPollFailure, (BValue)bAbsTime, null);
    }

    public String getLastPollFailureCause() {
        return this.getString(lastPollFailureCause);
    }

    public void setLastPollFailureCause(String string) {
        this.setString(lastPollFailureCause, string, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public boolean getUseSsl() {
        return this.getBoolean(useSsl);
    }

    public void setUseSsl(boolean bl) {
        this.setBoolean(useSsl, bl, null);
    }

    public boolean getUseStartTls() {
        return this.getBoolean(useStartTls);
    }

    public void setUseStartTls(boolean bl) {
        this.setBoolean(useStartTls, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BEmailService getService() {
        BComplex bComplex = this.getParent();
        if (bComplex == null) {
            return null;
        }
        if (bComplex instanceof BEmailService) {
            return (BEmailService)bComplex;
        }
        return null;
    }

    protected void addSslProvider() throws Exception {
        this.mailPlatformHandler.checkSslSupport();
    }

    public boolean isOperational() {
        BStatus bStatus = this.getStatus();
        boolean bl = false;
        if (!bStatus.isDisabled() && !bStatus.isFault()) {
            bl = true;
        }
        return bl;
    }

    public void updateStatus() {
        BEmailService bEmailService = this.getService();
        boolean bl = this.isOperational();
        int n = this.getStatus().getBits();
        int n2 = 0;
        n2 = !this.getEnabled() || bEmailService.isDisabled() ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
        n2 = bEmailService.isFault() ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
        if (n == n2) {
            return;
        }
        this.setStatus(BStatus.make((int)n2));
        boolean bl2 = this.isOperational();
        if (bl != bl2) {
            if (bl2) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
    }

    protected void enabled() {
        this.beginPolling();
    }

    protected void disabled() {
        this.endPolling();
    }

    void beginPolling() {
        if (this.getService().isFatalFault()) {
            throw new IllegalStateException();
        }
        if (this.poller == null) {
            this.poller = new Poller();
            this.poller.start();
        }
    }

    void endPolling() {
        if (this.poller != null) {
            this.poller.kill();
            this.poller = null;
        }
    }

    public void started() throws Exception {
        super.started();
        this.mailPlatformHandler = MailPlatformHandler.getInstance();
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
        if (context != doNotChange) {
            if (property == useSsl) {
                if (this.getUseSsl()) {
                    this.set(useStartTls, (BValue)BBoolean.FALSE, doNotChange);
                }
            } else if (property == useStartTls && this.getUseStartTls()) {
                this.set(useSsl, (BValue)BBoolean.FALSE, doNotChange);
            }
        }
    }

    public abstract void poll() throws Exception;

    private final void doPoll() {
        block2: {
            try {
                this.poll();
                this.setLastPollSuccess(BAbsTime.now());
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
            }
            catch (Throwable throwable) {
                this.setLastPollFailure(BAbsTime.now());
                this.setLastPollFailureCause(throwable.toString());
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                throwable.printStackTrace();
                BEmailService bEmailService = this.getService();
                if (bEmailService == null) break block2;
                BEmailService.log.error("BEmailAccount could not poll: ", throwable);
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.poller = null;
        this.mailPlatformHandler = null;
    }

    public BEmailAccount() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$email$BEmailAccount;
        if (clazz == null) {
            clazz = class$javax$baja$email$BEmailAccount = BEmailAccount.class("[Ljavax.baja.email.BEmailAccount;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        doNotChange = new BasicContext();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Poller
    extends Thread {
        private boolean alive;

        private final void kill() {
            this.alive = false;
            this.interrupt();
        }

        public void run() {
            this.alive = true;
            while (this.alive) {
                try {
                    Poller.sleep(Math.max(BEmailAccount.this.getPollrate().getMillis(), 1000L));
                }
                catch (InterruptedException interruptedException) {
                    this.alive = false;
                    break;
                }
                BEmailAccount.this.doPoll();
            }
        }

        private final /* synthetic */ void this() {
            this.alive = false;
        }

        private Poller() {
            super("EmailAccountPoller");
            this.this();
            this.setContextClassLoader(this.getClass().getClassLoader());
        }
    }
}

