/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.alarm;

import com.tridium.alarm.user.BIUserAlarmRecipient;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEmailRecipient
extends BAlarmRecipient
implements BIUserAlarmRecipient {
    public static final Property to = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property cc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property bcc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property language = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)6)));
    public static final Property emailAccount = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"email:OutgoingAccountFE")));
    public static final Property subject = BEmailRecipient.newProperty((int)0, (BValue)BFormat.make((String)"Niagara Alarm From %alarmData.sourceName%"), null);
    public static final Property body = BEmailRecipient.newProperty((int)0, (BValue)BEmailRecipient.makeDefaultEmailFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Type TYPE;
    private static final BIcon icon;
    public static final BFacets TIME_FACETS;
    public Lexicon lex;
    static /* synthetic */ Class class$com$tridium$email$alarm$BEmailRecipient;

    public BEmailAddressList getTo() {
        return (BEmailAddressList)this.get(to);
    }

    public void setTo(BEmailAddressList bEmailAddressList) {
        this.set(to, (BValue)bEmailAddressList, null);
    }

    public BEmailAddressList getCc() {
        return (BEmailAddressList)this.get(cc);
    }

    public void setCc(BEmailAddressList bEmailAddressList) {
        this.set(cc, (BValue)bEmailAddressList, null);
    }

    public BEmailAddressList getBcc() {
        return (BEmailAddressList)this.get(bcc);
    }

    public void setBcc(BEmailAddressList bEmailAddressList) {
        this.set(bcc, (BValue)bEmailAddressList, null);
    }

    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String string) {
        this.setString(language, string, null);
    }

    public String getEmailAccount() {
        return this.getString(emailAccount);
    }

    public void setEmailAccount(String string) {
        this.setString(emailAccount, string, null);
    }

    public BFormat getSubject() {
        return (BFormat)this.get(subject);
    }

    public void setSubject(BFormat bFormat) {
        this.set(subject, (BValue)bFormat, null);
    }

    public BFormat getBody() {
        return (BFormat)this.get(body);
    }

    public void setBody(BFormat bFormat) {
        this.set(body, (BValue)bFormat, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        this.sendAlarm(this.getTo(), bAlarmRecord);
    }

    private final void sendAlarm(BEmailAddressList bEmailAddressList, BAlarmRecord bAlarmRecord) {
        BEmailService bEmailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
        BOutgoingAccount bOutgoingAccount = (BOutgoingAccount)bEmailService.loadSlots().get(this.getEmailAccount());
        if (bOutgoingAccount == null) {
            BEmailService.log.error("Alarm email recipient can not find '" + this.getEmailAccount() + "' outgoing account.");
            return;
        }
        String string = this.getLanguage();
        if (string.equals("")) {
            string = Sys.getLanguage();
        }
        EmailContext emailContext = new EmailContext(string);
        BEmail bEmail = new BEmail();
        bEmail.setTo(bEmailAddressList);
        bEmail.setCc(this.getCc());
        bEmail.setBcc(this.getBcc());
        bEmail.setDate(BAbsTime.now());
        bEmail.setSubject(BFormat.make((String)this.getSubject().format((Object)bAlarmRecord, (Context)emailContext)).format((Object)bAlarmRecord, (Context)emailContext));
        String string2 = BFormat.make((String)this.getBody().format((Object)bAlarmRecord, (Context)emailContext)).format((Object)bAlarmRecord, (Context)emailContext);
        bEmail.setBody(new BTextPart("", string2));
        bEmail.getHeaders().addHeader("Message-ID", "alarm." + bAlarmRecord.getUuid().toString((Context)emailContext));
        bOutgoingAccount.send(bEmail);
    }

    public static BFormat makeDefaultEmailFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Source:      %alarmData.sourceName%\n");
        stringBuffer.append("Timestamp:   %timestamp%\n");
        stringBuffer.append("State:       %sourceState% / %ackState%\n");
        stringBuffer.append("Priority:    %priority%\n");
        stringBuffer.append("Alarm Class: %alarmClass%\n");
        stringBuffer.append("Text:        %alarmData.msgText%\n");
        return BFormat.make((String)stringBuffer.toString());
    }

    public void handleAlarmForUser(BUser bUser, BAlarmRecord bAlarmRecord) {
        if (this.accept(bAlarmRecord)) {
            this.sendAlarm(BEmailAddressList.make(bUser.getEmail()), bAlarmRecord);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$email$alarm$BEmailRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$email$alarm$BEmailRecipient = BEmailRecipient.class("[Lcom.tridium.email.alarm.BEmailRecipient;", false);
        }
        this.lex = Lexicon.make((Class)clazz);
    }

    public BEmailRecipient() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$email$alarm$BEmailRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$email$alarm$BEmailRecipient = BEmailRecipient.class("[Lcom.tridium.email.alarm.BEmailRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"email.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
        TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EmailContext
    implements Context {
        String lang;

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return new BUser();
        }

        public BFacets getFacets() {
            return TIME_FACETS;
        }

        public BObject getFacet(String string) {
            return this.getFacets().get(string);
        }

        public String getLanguage() {
            return this.lang;
        }

        public EmailContext(String string) {
            this.lang = string;
        }
    }
}

